/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.AssociationEvent;
import org.babyfish.jimmer.sql.event.AssociationListener;
import org.babyfish.jimmer.sql.event.ChangedRef;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.EntityListener;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.impl.BackRefIds;
import org.babyfish.jimmer.sql.event.impl.EvictContext;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class TriggersImpl
implements Triggers {
    private final boolean transaction;
    private JSqlClientImplementor sqlClient;
    private final CopyOnWriteArrayList<EntityListener<ImmutableSpi>> globalEntityListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<AssociationListener> globalAssociationListeners = new CopyOnWriteArrayList();
    private final ConcurrentMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>> entityTableListenerMultiMap = new ConcurrentHashMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>>();
    private final ConcurrentMap<ImmutableProp, CopyOnWriteArrayList<AssociationListener>> associationListenerMultiMap = new ConcurrentHashMap<ImmutableProp, CopyOnWriteArrayList<AssociationListener>>();

    public TriggersImpl(boolean transaction) {
        this.transaction = transaction;
    }

    public void initialize(JSqlClientImplementor sqlClient) {
        if (this.sqlClient != null) {
            throw new IllegalStateException("sqlClient cannot be changed after initialized");
        }
        if (sqlClient == null) {
            throw new IllegalArgumentException("sqlClient cannot be null");
        }
        this.sqlClient = sqlClient;
    }

    @Override
    public void addEntityListener(EntityListener<?> listener) {
        this.addEntityListener((ImmutableType)null, listener);
    }

    @Override
    public void addEntityListener(ImmutableType immutableType, EntityListener<?> listener) {
        if (listener != null) {
            if (immutableType == null) {
                this.globalEntityListeners.add(listener);
            } else {
                this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).add(listener);
            }
        }
    }

    @Override
    public void removeEntityListener(EntityListener<?> listener) {
        this.removeEntityListener((ImmutableType)null, listener);
    }

    @Override
    public void removeEntityListener(ImmutableType immutableType, EntityListener<?> listener) {
        if (listener != null) {
            if (immutableType == null) {
                this.globalEntityListeners.remove(listener);
            } else {
                this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).remove(listener);
            }
        }
    }

    @Override
    public void addAssociationListener(AssociationListener listener) {
        this.addAssociationListener((ImmutableProp)null, listener);
    }

    @Override
    public void addAssociationListener(ImmutableProp prop, AssociationListener listener) {
        if (prop != null && !prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (listener != null) {
            if (prop == null) {
                this.globalAssociationListeners.add(listener);
            } else {
                this.associationListenerMultiMap.computeIfAbsent(prop, it -> new CopyOnWriteArrayList()).add(listener);
            }
        }
    }

    @Override
    public void removeAssociationListener(AssociationListener listener) {
        this.removeAssociationListener((ImmutableProp)null, listener);
    }

    @Override
    public void removeAssociationListener(ImmutableProp prop, AssociationListener listener) {
        if (prop != null && !prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (listener != null) {
            if (prop == null) {
                this.globalAssociationListeners.remove(listener);
            } else {
                this.associationListenerMultiMap.computeIfAbsent(prop, it -> new CopyOnWriteArrayList()).remove(listener);
            }
        }
    }

    @Override
    public void fireEntityTableChange(Object oldRow, Object newRow, Connection con, Object reason) {
        if (oldRow == null && newRow == null) {
            return;
        }
        if (oldRow != null && !(oldRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldRow must be immutable");
        }
        if (newRow != null && !(newRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newRow must be immutable");
        }
        EntityEvent<ImmutableSpi> event = new EntityEvent<ImmutableSpi>((ImmutableSpi)oldRow, (ImmutableSpi)newRow, con, reason);
        List<EntityListener<ImmutableSpi>> listeners = this.entityListeners(event.getImmutableType());
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            for (EntityListener<ImmutableSpi> listener : listeners) {
                try {
                    listener.onChange(event);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if ((throwable = this.fireAssociationEventByEntityEvent(event, throwable)) instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    @Override
    public void fireMiddleTableDelete(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            this.fireMiddleTableDeleteImpl(mappedBy, targetId, sourceId, con, reason);
        } else {
            this.fireMiddleTableDeleteImpl(prop, sourceId, targetId, con, reason);
        }
    }

    private void fireMiddleTableDeleteImpl(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        AssociationEvent e;
        ImmutableProp inverseProp = prop.getOpposite();
        List<AssociationListener> listeners = this.associationListeners(prop);
        List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            e = new AssociationEvent(prop, sourceId, targetId, null, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (!inverseListeners.isEmpty()) {
            e = new AssociationEvent(inverseProp, targetId, sourceId, null, con, reason);
            for (AssociationListener inverseListener : inverseListeners) {
                try {
                    inverseListener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    @Override
    public void fireMiddleTableInsert(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            this.fireMiddleTableInsertImpl(mappedBy, targetId, sourceId, con, reason);
        } else {
            this.fireMiddleTableInsertImpl(prop, sourceId, targetId, con, reason);
        }
    }

    private void fireMiddleTableInsertImpl(ImmutableProp prop, Object sourceId, Object targetId, Connection con, Object reason) {
        AssociationEvent e;
        ImmutableProp inverseProp = prop.getOpposite();
        List<AssociationListener> listeners = this.associationListeners(prop);
        List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
        Throwable throwable = null;
        if (!listeners.isEmpty()) {
            e = new AssociationEvent(prop, sourceId, null, targetId, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (!inverseListeners.isEmpty()) {
            e = new AssociationEvent(inverseProp, targetId, null, sourceId, con, reason);
            for (AssociationListener inverseListener : inverseListeners) {
                try {
                    inverseListener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            throw (Error)throwable;
        }
    }

    @Override
    public void fireEntityEvict(ImmutableType type, Object sourceId, Connection con, Object reason) {
        EvictContext ctx = EvictContext.get();
        if (ctx != null && !ctx.add(type, sourceId)) {
            return;
        }
        List<EntityListener<ImmutableSpi>> listeners = this.entityListeners(type);
        if (!listeners.isEmpty()) {
            Throwable throwable = null;
            EntityEvent e = EntityEvent.evict(type, sourceId, con, reason);
            for (EntityListener<ImmutableSpi> listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
            if ((throwable = this.fireAssociationEventByEntityEvent(e, throwable)) instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }

    @Override
    public void fireAssociationEvict(ImmutableProp prop, Object sourceId, Connection con, Object reason) {
        EvictContext ctx = EvictContext.get();
        if (ctx != null && !ctx.add(prop, sourceId)) {
            return;
        }
        List<AssociationListener> listeners = this.associationListeners(prop);
        if (!listeners.isEmpty()) {
            Throwable throwable = null;
            AssociationEvent e = new AssociationEvent(prop, sourceId, con, reason);
            for (AssociationListener listener : listeners) {
                try {
                    listener.onChange(e);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }

    private List<EntityListener<ImmutableSpi>> entityListeners(ImmutableType type) {
        ArrayList<EntityListener<ImmutableSpi>> listeners = new ArrayList<EntityListener<ImmutableSpi>>(this.globalEntityListeners);
        ConcurrentMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>> map = this.entityTableListenerMultiMap;
        for (ImmutableType t : type.getAllTypes()) {
            CopyOnWriteArrayList list = (CopyOnWriteArrayList)map.get(t);
            if (list == null) continue;
            listeners.addAll(list);
        }
        return listeners;
    }

    private List<AssociationListener> associationListeners(ImmutableProp prop) {
        if (prop == null) {
            return Collections.emptyList();
        }
        ArrayList<AssociationListener> listeners = new ArrayList<AssociationListener>(this.globalAssociationListeners);
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.associationListenerMultiMap.get(prop);
        if (list != null) {
            listeners.addAll(list);
        }
        return listeners;
    }

    @Override
    public boolean isTransaction() {
        return this.transaction;
    }

    private Throwable fireAssociationEventByEntityEvent(EntityEvent<?> event, Throwable throwable) {
        ImmutableType type = event.getImmutableType();
        if (!event.isEvict()) {
            for (ImmutableProp prop : type.getProps().values()) {
                AssociationEvent e;
                ChangedRef changedRef;
                if (!prop.isColumnDefinition() || !prop.isAssociation(TargetLevel.PERSISTENT) || (changedRef = event.getChangedRef(prop)) == null) continue;
                ChangedRef fkRef = changedRef.toIdRef();
                Object childId = event.getId();
                Object oldFk = fkRef.getOldValue();
                Object newFk = fkRef.getNewValue();
                Connection con = event.getConnection();
                Object reason = event.getReason();
                ImmutableProp inverseProp = prop.getOpposite();
                List<AssociationListener> listeners = this.associationListeners(prop);
                List<AssociationListener> inverseListeners = this.associationListeners(inverseProp);
                if (!listeners.isEmpty()) {
                    e = new AssociationEvent(prop, childId, oldFk, newFk, con, reason);
                    for (AssociationListener listener : listeners) {
                        try {
                            listener.onChange(e);
                        }
                        catch (Error | RuntimeException ex) {
                            if (throwable != null) continue;
                            throwable = ex;
                        }
                    }
                }
                if (inverseListeners.isEmpty()) continue;
                if (oldFk != null) {
                    e = new AssociationEvent(inverseProp, oldFk, childId, null, con, reason);
                    for (AssociationListener inverseListener : inverseListeners) {
                        try {
                            inverseListener.onChange(e);
                        }
                        catch (Error | RuntimeException ex) {
                            if (throwable != null) continue;
                            throwable = ex;
                        }
                    }
                }
                if (newFk == null) continue;
                e = new AssociationEvent(inverseProp, newFk, null, childId, con, reason);
                for (AssociationListener inverseListener : inverseListeners) {
                    try {
                        inverseListener.onChange(e);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            }
        }
        MetadataStrategy metadataStrategy = this.sqlClient().getMetadataStrategy();
        ImmutableType thisType = event.getImmutableType();
        for (ImmutableProp backProp : this.sqlClient().getEntityManager().getAllBackProps(thisType)) {
            ImmutableProp mappedBy;
            EvictContext ctx;
            if (!backProp.isAssociation(TargetLevel.PERSISTENT) || (ctx = EvictContext.get()) != null && !ctx.isAllowed(backProp) || !event.isEvict() && backProp.isTargetForeignKeyReal(metadataStrategy) || !event.isEvict() && (mappedBy = backProp.getMappedBy()) != null && mappedBy.isTargetForeignKeyReal(metadataStrategy)) continue;
            List<?> backRefIds = BackRefIds.findBackRefIds(this.sqlClient, backProp, event.getId(), event.getConnection());
            for (Object backRefId : backRefIds) {
                try {
                    this.fireAssociationEvict(backProp, backRefId, event.getConnection());
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
        }
        return throwable;
    }

    private JSqlClientImplementor sqlClient() {
        JSqlClientImplementor sqlClient = this.sqlClient;
        if (sqlClient == null) {
            throw new IllegalStateException("The triggers are not ready because the initialization of sqlClient is 'MANUAL' but the sqlClient is not initialized");
        }
        return sqlClient;
    }
}

