/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.meta.SqlTypeStrategy;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.jetbrains.annotations.Nullable;

public interface Dialect
extends SqlTypeStrategy {
    public static final String FAKE_UPDATE_COMMENT = "/* fake update to return all ids */";

    public void paginate(PaginationContext var1);

    @Nullable
    default public UpdateJoin getUpdateJoin() {
        return null;
    }

    default public String getSelectIdFromSequenceSql(String sequenceName) {
        throw new ExecutionException("Sequence is not supported by '" + this.getClass().getName() + "'");
    }

    @Nullable
    default public String getOverrideIdentityIdSql() {
        return null;
    }

    default public boolean isDeletedAliasRequired() {
        return false;
    }

    @Nullable
    default public String getOffsetOptimizationNumField() {
        return null;
    }

    default public boolean isMultiInsertionSupported() {
        return true;
    }

    default public boolean isArraySupported() {
        return false;
    }

    default public boolean isAnyEqualityOfArraySupported() {
        return this.isArraySupported();
    }

    default public <T> T[] getArray(ResultSet rs, int col, Class<T[]> arrayType) throws SQLException {
        throw new UnsupportedOperationException("`Dialect.getArray` is not supported");
    }

    default public boolean isTupleSupported() {
        return true;
    }

    default public boolean isTupleCountSupported() {
        return false;
    }

    @Nullable
    default public String getConstantTableName() {
        return null;
    }

    default public Class<?> getJsonBaseType() {
        return String.class;
    }

    default public Object jsonToBaseValue(Object json, ObjectMapper objectMapper) throws Exception {
        return objectMapper.writeValueAsString(json);
    }

    default public Object baseValueToJson(Object baseValue, JavaType javaType, ObjectMapper objectMapper) throws Exception {
        return objectMapper.readValue((String)baseValue, javaType);
    }

    default public boolean isForeignKeySupported() {
        return true;
    }

    default public boolean isIgnoreCaseLikeSupported() {
        return false;
    }

    default public int resolveJdbcType(Class<?> sqlType) {
        return 1111;
    }

    default public Reader<?> unknownReader(Class<?> sqlType) {
        return null;
    }

    @Nullable
    default public String getJsonLiteralSuffix() {
        return null;
    }

    default public String transCacheOperatorTableDDL() {
        throw new UnsupportedOperationException("The current dialect \"" + this.getClass().getName() + "\" does not know how to create table `JIMMER_TRANS_CACHE_OPERATOR`");
    }

    default public int getMaxInListSize() {
        return 1000;
    }

    default public String arrayTypeSuffix() {
        return "[]";
    }

    default public boolean isIdFetchableByKeyUpdate() {
        return false;
    }

    default public boolean isUpsertSupported() {
        return false;
    }

    default public boolean isUpsertWithOptimisticLockSupported() {
        return false;
    }

    default public boolean isUpsertWithMultipleUniqueConstraintSupported() {
        return true;
    }

    default public boolean isUpsertWithNullableKeySupported() {
        return false;
    }

    default public boolean isTransactionAbortedByError() {
        return false;
    }

    default public boolean isBatchUpdateExceptionUnreliable() {
        return false;
    }

    public void update(UpdateContext var1);

    public void upsert(UpsertContext var1);

    public static interface UpsertContext {
        public boolean hasUpdatedColumns();

        public boolean hasOptimisticLock();

        public boolean hasGeneratedId();

        public List<ValueGetter> getConflictGetters();

        public UpsertContext sql(String var1);

        public UpsertContext sql(ValueGetter var1);

        public UpsertContext enter(AbstractSqlBuilder.ScopeType var1);

        public UpsertContext separator();

        public UpsertContext leave();

        public UpsertContext appendTableName();

        public UpsertContext appendInsertedColumns();

        public UpsertContext appendConflictColumns();

        public UpsertContext appendInsertingValues();

        public UpsertContext appendUpdatingAssignments(String var1, String var2);

        public UpsertContext appendOptimisticLockCondition(String var1);

        public UpsertContext appendGeneratedId();
    }

    public static interface UpdateContext {
        public boolean isUpdatedByKey();

        public UpdateContext sql(String var1);

        public UpdateContext sql(ValueGetter var1);

        public UpdateContext enter(AbstractSqlBuilder.ScopeType var1);

        public UpdateContext separator();

        public UpdateContext leave();

        public UpdateContext appendTableName();

        public UpdateContext appendAssignments();

        public UpdateContext appendPredicates();

        public UpdateContext appendId();
    }
}

