/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.spi.AbstractBinder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrackingConsumerBinder<K>
extends AbstractBinder<K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrackingConsumerBinder.class);

    public AbstractTrackingConsumerBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker) {
        super(type, prop);
        if (tracker != null) {
            tracker.addInvalidateListener(new InvalidateListenerImpl());
            tracker.addReconnectListener(new ReconnectListenerImpl());
        }
    }

    protected abstract void invalidateAll();

    private class InvalidateListenerImpl
    implements CacheTracker.InvalidationListener {
        private InvalidateListenerImpl() {
        }

        @Override
        public void onInvalidate(CacheTracker.InvalidateEvent event) {
            boolean match;
            boolean bl = event.getProp() != null ? AbstractTrackingConsumerBinder.this.prop == event.getProp() : (match = AbstractTrackingConsumerBinder.this.type == event.getType() && AbstractTrackingConsumerBinder.this.prop == null);
            if (match) {
                AbstractTrackingConsumerBinder.this.deleteAll(event.getIds(), null);
            }
        }
    }

    private class ReconnectListenerImpl
    implements CacheTracker.ReconnectListener {
        private ReconnectListenerImpl() {
        }

        @Override
        public void onReconnect() {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Cache.DeleteAll > {}", (Object)AbstractTrackingConsumerBinder.this.toString(true));
            }
            AbstractTrackingConsumerBinder.this.invalidateAll();
        }
    }
}

