/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import java.util.UUID;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.redisson.InvalidateMessage;
import org.babyfish.jimmer.sql.cache.spi.AbstractCacheTracker;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;

public class RedissonCacheTracker
extends AbstractCacheTracker {
    private static final String CHANNEL = "_jimmer_:invalidate";
    private final UUID trackerId = UUID.randomUUID();
    private final RTopic topic;

    public RedissonCacheTracker(RedissonClient redissonClient) {
        this.topic = redissonClient.getTopic(CHANNEL);
        this.topic.addListener(InvalidateMessage.class, (MessageListener)new MessageListener<InvalidateMessage>(){

            public void onMessage(CharSequence channel, InvalidateMessage msg) {
                if (!msg.trackerId.equals(RedissonCacheTracker.this.trackerId)) {
                    RedissonCacheTracker.this.firer().invalidate(msg.toEvent());
                }
            }
        });
        this.topic.addListener((StatusListener)new BaseStatusListener(){

            public void onSubscribe(String channel) {
                RedissonCacheTracker.this.firer().reconnect();
            }
        });
    }

    @Override
    protected void publishInvalidationEvent(CacheTracker.InvalidateEvent event) {
        this.topic.publish((Object)new InvalidateMessage(this.trackerId, event));
    }
}

