/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.chain.LockableBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedissonCacheLocker
implements CacheLocker {
    private final RedissonClient redissonClient;
    private final int lockUpgradeThreshold;

    public RedissonCacheLocker(RedissonClient redissonClient) {
        this(redissonClient, 64);
    }

    public RedissonCacheLocker(RedissonClient redissonClient, int lockUpgradeThreshold) {
        if (lockUpgradeThreshold < 2) {
            throw new IllegalArgumentException("lockUpgradeThreshold cannot be less than 2");
        }
        this.redissonClient = Objects.requireNonNull(redissonClient, "redissonClient cannot be null");
        this.lockUpgradeThreshold = lockUpgradeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locking(@NotNull LockableBinder<?, ?> binder, @NotNull Set<?> missedKeys, @Nullable Duration waitingDuration, @NotNull Duration lockingDuration, CacheLocker.Action action) throws InterruptedException {
        RLock lock;
        String lockPrefix = "$lock$" + binder.keyPrefix();
        if (missedKeys.size() >= this.lockUpgradeThreshold) {
            lock = this.redissonClient.getLock(lockPrefix);
        } else {
            lockPrefix = lockPrefix + '-';
            TreeSet<String> lockNames = new TreeSet<String>();
            for (Object missedKey : missedKeys) {
                lockNames.add(lockPrefix + missedKey);
            }
            RLock[] locks = new RLock[lockNames.size()];
            int index = 0;
            for (String lockName : lockNames) {
                locks[index++] = this.redissonClient.getLock(lockName);
            }
            lock = this.redissonClient.getMultiLock(locks);
        }
        if (waitingDuration == null) {
            lock.lockInterruptibly(lockingDuration.toMillis(), TimeUnit.MILLISECONDS);
            try {
                action.execute(true);
            }
            finally {
                lock.unlock();
            }
        } else if (lock.tryLock(waitingDuration.toMillis(), lockingDuration.toMillis(), TimeUnit.MILLISECONDS)) {
            try {
                action.execute(true);
            }
            finally {
                lock.unlock();
            }
        } else {
            action.execute(false);
        }
    }
}

