/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.chain.Binder;
import org.babyfish.jimmer.sql.cache.chain.CacheChain;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.LockedBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainCacheImpl<K, V>
implements Cache<K, V> {
    private static final ThreadLocal<CacheLoader<?, ?>> LOADER_LOCAL = new ThreadLocal();
    protected final ImmutableType type;
    protected final ImmutableProp prop;
    protected final Node<K, V> node;

    public ChainCacheImpl(List<Binder<K>> binders) {
        if (binders.isEmpty()) {
            throw new IllegalArgumentException("binders cannot be empty");
        }
        ImmutableType cacheType = null;
        ImmutableProp cacheProp = null;
        Node<K, V> node = this.createTailNode();
        ListIterator<Binder<K>> itr = binders.listIterator(binders.size());
        while (itr.hasPrevious()) {
            Binder<K> binder = itr.previous();
            ImmutableType type = binder.type();
            ImmutableProp prop = binder.prop();
            if (cacheType == null) {
                cacheType = type;
                cacheProp = prop;
            } else if (cacheType != type || cacheProp != prop) {
                throw new IllegalArgumentException("Not all binders belong to same type/prop");
            }
            node = this.createNode(binder, node);
        }
        this.type = cacheType;
        this.prop = cacheProp;
        this.node = node;
    }

    @Override
    @NotNull
    public ImmutableType type() {
        return this.type;
    }

    @Override
    @Nullable
    public ImmutableProp prop() {
        return this.prop;
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull CacheEnvironment<K, V> env) {
        return ChainCacheImpl.usingCacheLoading(env.getLoader(), () -> this.node.loadAll(keys));
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys, Object reason) {
        this.node.deleteAll(keys, reason);
    }

    protected Node<K, V> createNode(Object binder, Node<K, V> next) {
        if (binder instanceof LoadingBinder) {
            return new LoadingNode<K, V>((LoadingBinder)binder, next);
        }
        return new SimpleNode<K, V>((SimpleBinder)binder, next);
    }

    protected TailNode<K, V> createTailNode() {
        return new TailNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R> R usingCacheLoading(CacheLoader<?, ?> loader, Supplier<R> block) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        CacheLoader<?, ?> oldLoader = LOADER_LOCAL.get();
        LOADER_LOCAL.set(loader);
        try {
            R r = block.get();
            return r;
        }
        finally {
            if (oldLoader != null) {
                LOADER_LOCAL.set(oldLoader);
            } else {
                LOADER_LOCAL.remove();
            }
        }
    }

    protected static <K, V> CacheLoader<K, V> currentCacheLoader() {
        CacheLoader<?, ?> loader = LOADER_LOCAL.get();
        if (loader == null) {
            throw new IllegalStateException("Cache binder can only be called by chain cache");
        }
        return loader;
    }

    protected static class TailNode<K, V>
    implements Node<K, V> {
        protected TailNode() {
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            CacheLoader loader = ChainCacheImpl.currentCacheLoader();
            return loader.loadAll(keys);
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
        }
    }

    protected static interface Node<K, V>
    extends CacheChain<K, V> {
        public void deleteAll(@NotNull Collection<K> var1, Object var2);
    }

    private static class LoadingNode<K, V>
    implements Node<K, V> {
        private final LoadingBinder<K, V> binder;
        private final Node<K, V> next;

        LoadingNode(LoadingBinder<K, V> binder, Node<K, V> next) {
            this.binder = binder;
            this.next = next;
            binder.initialize(next);
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            return this.binder.getAll(keys);
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
            this.next.deleteAll(keys, reason);
            this.binder.deleteAll(keys, reason);
        }
    }

    protected static class SimpleNode<K, V>
    implements Node<K, V> {
        protected final SimpleBinder<K, V> binder;
        protected final Node<K, V> next;

        protected SimpleNode(SimpleBinder<K, V> binder, Node<K, V> next) {
            this.binder = binder;
            this.next = next;
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            Map<K, V> map = this.binder.getAll(keys);
            if (map.size() < keys.size()) {
                if (this.binder instanceof LockedBinder) {
                    LockedBinder lockedBinder = (LockedBinder)((Object)this.binder);
                    Set<K> missedKeys = SimpleNode.missedKeys(keys, map);
                    try {
                        lockedBinder.locker().locking(lockedBinder.unwrap(), missedKeys, lockedBinder.waitDuration(), lockedBinder.leaseDuration(), locked -> this.loadAllForNext(missedKeys, map, locked));
                    }
                    catch (ExecutionException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new ExecutionException("Failed to load missed data and update cache", ex);
                    }
                } else {
                    this.loadAllForNext(SimpleNode.missedKeys(keys, map), map, true);
                }
            }
            return map;
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
            if (keys.isEmpty()) {
                return;
            }
            if (this.binder instanceof LockedBinder) {
                LockedBinder lockedBinder = (LockedBinder)((Object)this.binder);
                try {
                    lockedBinder.locker().locking(lockedBinder.unwrap(), keys instanceof Set ? (Set<Object>)keys : new LinkedHashSet<K>(keys), null, lockedBinder.leaseDuration(), locked -> {
                        this.next.deleteAll(keys, reason);
                        this.binder.deleteAll(keys, reason);
                    });
                }
                catch (ExecutionException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new ExecutionException("Failed to delete keys from cache", ex);
                }
            } else {
                this.next.deleteAll(keys, reason);
                this.binder.deleteAll(keys, reason);
            }
        }

        private static <K, V> Set<K> missedKeys(Collection<K> keys, Map<K, V> loadedMap) {
            LinkedHashSet<K> missedKeys = new LinkedHashSet<K>();
            for (K key : keys) {
                if (loadedMap.containsKey(key)) continue;
                missedKeys.add(key);
            }
            return missedKeys;
        }

        private void loadAllForNext(Collection<K> missedKeys, Map<K, V> loadedMap, boolean updateBinder) {
            Map mapFromNext = this.next.loadAll(missedKeys);
            if (mapFromNext.size() < missedKeys.size()) {
                mapFromNext = new HashMap(mapFromNext);
                if (updateBinder) {
                    for (K missedKey : missedKeys) {
                        if (mapFromNext.containsKey(missedKey)) continue;
                        mapFromNext.put(missedKey, null);
                    }
                }
            }
            if (updateBinder) {
                this.binder.setAll(mapFromNext);
            }
            loadedMap.putAll(mapFromNext);
        }
    }
}

