/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.impl.value.AbstractValueGetter;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.Nullable;

class SimpleValueGetter
extends AbstractValueGetter {
    private final Table<?> table;
    private final boolean rawId;
    private final String columnName;

    SimpleValueGetter(JSqlClientImplementor sqlClientImplementor, ImmutableProp valueProp, Table<?> table, boolean rawId, String columnName) {
        super(sqlClientImplementor, valueProp);
        this.table = table;
        this.rawId = rawId;
        this.columnName = Objects.requireNonNull(columnName, "The column name cannot be null");
    }

    @Override
    protected Object getRaw(Object value) {
        return value;
    }

    public int hashCode() {
        return this.valueProp.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleValueGetter)) {
            return false;
        }
        SimpleValueGetter other = (SimpleValueGetter)obj;
        return this.valueProp.equals((Object)other.valueProp);
    }

    public String toString() {
        return this.valueProp.toString();
    }

    @Override
    public final ImmutableProp getValueProp() {
        return this.valueProp;
    }

    @Override
    @Nullable
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean isNullable() {
        return this.valueProp.isNullable();
    }

    @Override
    public void renderTo(AbstractSqlBuilder<?> builder) {
        if (this.table != null && builder instanceof SqlBuilder) {
            AstContext astContext = ((SqlBuilder)builder).getAstContext();
            TableImplementor<?> tableImplementor = TableProxies.resolve(this.table, astContext);
            if (this.valueProp.isId() && (this.rawId || TableUtils.isRawIdAllowed(tableImplementor, builder.sqlClient()))) {
                String middleTableAlias = tableImplementor.getMiddleTableAlias();
                if (middleTableAlias != null) {
                    builder.sql(middleTableAlias);
                } else {
                    builder.sql(tableImplementor.getParent().getAlias());
                }
            } else {
                builder.sql(tableImplementor.getAlias());
            }
            builder.sql(".");
        }
        builder.sql(this.columnName);
    }
}

