/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;

public class MergedNode
extends AbstractDataManager<String, MergedNode> {
    final AbstractMutableStatementImpl statement;
    final String alias;
    final String middleTableAlias;
    private TableImpl<?> innerChild;
    private TableImpl<?> leftChild;
    private TableImpl<?> rightChild;
    private TableImpl<?> fullChild;
    private final TableImplementors tableImplementors = new TableImplementors();

    public MergedNode(AbstractMutableStatementImpl statement, ImmutableProp joinProp) {
        this.statement = statement;
        StatementContext ctx = statement.getContext();
        if (joinProp != null) {
            if (joinProp.isMiddleTableDefinition()) {
                this.middleTableAlias = statement.getContext().allocateTableAlias();
            } else {
                if (joinProp.getSqlTemplate() == null && !joinProp.hasStorage()) {
                    throw new AssertionError((Object)"Internal bug: Join property has not storage");
                }
                this.middleTableAlias = null;
            }
        } else {
            this.middleTableAlias = null;
        }
        this.alias = ctx.allocateTableAlias();
    }

    TableImplementor<?> table(String joinName, AbstractMutableStatementImpl statement, ImmutableProp joinProp, JoinType joinType, Function<MergedNode, TableImpl<?>> supplier) {
        MergedNode childNode = (MergedNode)this.getValue(joinName);
        if (childNode == null) {
            childNode = new MergedNode(statement, joinProp);
            this.putValue(joinName, childNode);
        }
        return childNode.table(joinType, supplier);
    }

    TableImplementor<?> table(JoinType joinType, Function<MergedNode, TableImpl<?>> supplier) {
        switch (joinType) {
            case LEFT: {
                if (this.leftChild != null) {
                    return this.leftChild;
                }
                this.leftChild = supplier.apply(this);
                return this.leftChild;
            }
            case RIGHT: {
                if (this.rightChild != null) {
                    return this.rightChild;
                }
                this.rightChild = supplier.apply(this);
                return this.rightChild;
            }
            case FULL: {
                if (this.fullChild != null) {
                    return this.fullChild;
                }
                this.fullChild = supplier.apply(this);
                return this.fullChild;
            }
        }
        if (this.innerChild != null) {
            return this.innerChild;
        }
        this.innerChild = supplier.apply(this);
        return this.innerChild;
    }

    public JoinType getMergedJoinType(AstContext ctx) {
        TableImpl<?> i = this.innerChild;
        if (i != null && ctx.getTableUsedState(i) != TableUsedState.NONE) {
            return JoinType.INNER;
        }
        TableImpl<?> l = this.leftChild;
        TableImpl<?> r = this.rightChild;
        TableImpl<?> f = this.fullChild;
        JoinType mergedJoinType = null;
        if (l != null && ctx.getTableUsedState(l) != TableUsedState.NONE) {
            mergedJoinType = JoinType.LEFT;
        }
        if (r != null && ctx.getTableUsedState(r) != TableUsedState.NONE) {
            if (mergedJoinType != null) {
                return JoinType.INNER;
            }
            mergedJoinType = JoinType.RIGHT;
        }
        if (f != null && ctx.getTableUsedState(f) != TableUsedState.NONE) {
            if (mergedJoinType != null) {
                return JoinType.INNER;
            }
            mergedJoinType = JoinType.FULL;
        }
        return mergedJoinType;
    }

    public void accept(AstVisitor visitor) {
        if (this.innerChild != null) {
            this.innerChild.accept(visitor);
        } else if (this.leftChild != null) {
            this.leftChild.accept(visitor);
        } else if (this.rightChild != null) {
            this.rightChild.accept(visitor);
        } else {
            this.fullChild.accept(visitor);
        }
    }

    public void renderTo(SqlBuilder builder) {
        AstContext ctx = builder.getAstContext();
        TableImpl<SqlBuilder> i = this.innerChild;
        TableImpl<SqlBuilder> l = this.leftChild;
        TableImpl<SqlBuilder> r = this.rightChild;
        TableImpl<SqlBuilder> f = this.fullChild;
        if (i != null && ctx.getTableUsedState(i) == TableUsedState.USED) {
            i.renderTo(builder);
        } else if (l != null && ctx.getTableUsedState(l) == TableUsedState.USED) {
            l.renderTo(builder);
        } else if (r != null && ctx.getTableUsedState(r) == TableUsedState.USED) {
            r.renderTo(builder);
        } else if (f != null && ctx.getTableUsedState(f) == TableUsedState.USED) {
            f.renderTo(builder);
        } else if (i != null && ctx.getTableUsedState(i) != TableUsedState.NONE) {
            i.renderTo(builder);
        } else if (l != null && ctx.getTableUsedState(l) != TableUsedState.NONE) {
            l.renderTo(builder);
        } else if (r != null && ctx.getTableUsedState(r) != TableUsedState.NONE) {
            r.renderTo(builder);
        } else if (f != null && ctx.getTableUsedState(f) != TableUsedState.NONE) {
            f.renderTo(builder);
        }
    }

    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        AstContext ctx = builder.getAstContext();
        TableImpl<?> i = this.innerChild;
        TableImpl<?> l = this.leftChild;
        TableImpl<?> r = this.rightChild;
        TableImpl<?> f = this.fullChild;
        if (i != null && ctx.getTableUsedState(i) != TableUsedState.NONE) {
            i.renderJoinAsFrom(builder, mode);
        } else if (l != null && ctx.getTableUsedState(l) != TableUsedState.NONE) {
            l.renderJoinAsFrom(builder, mode);
        } else if (r != null && ctx.getTableUsedState(r) != TableUsedState.NONE) {
            r.renderJoinAsFrom(builder, mode);
        } else if (ctx.getTableUsedState(f) != TableUsedState.NONE) {
            f.renderJoinAsFrom(builder, mode);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MergedTable{");
        if (this.innerChild != null) {
            builder.append(",").append("innerChild=").append(this.innerChild);
        }
        if (this.leftChild != null) {
            builder.append(",").append("leftChild=").append(this.leftChild);
        }
        if (this.rightChild != null) {
            builder.append(",").append("rightChild=").append(this.rightChild);
        }
        if (this.fullChild != null) {
            builder.append(",").append("fullChild=").append(this.fullChild);
        }
        builder.append("}");
        return builder.toString();
    }

    @NotNull
    public Iterable<TableImplementor<?>> tableImplementors() {
        return this.tableImplementors;
    }

    private class TableImplementors
    implements Iterable<TableImplementor<?>> {
        private TableImplementors() {
        }

        @Override
        @NotNull
        public Iterator<TableImplementor<?>> iterator() {
            return new Itr();
        }
    }

    private class Itr
    implements Iterator<TableImplementor<?>> {
        private int step;

        public Itr() {
            this.step = MergedNode.this.innerChild != null ? 0 : (MergedNode.this.leftChild != null ? 1 : (MergedNode.this.rightChild != null ? 2 : (MergedNode.this.fullChild != null ? 3 : 4)));
        }

        @Override
        public boolean hasNext() {
            return this.step < 4;
        }

        @Override
        public TableImplementor<?> next() {
            int step = this.step;
            TableImplementor<?> ti = this.tableImplementor(step);
            if (ti == null) {
                throw new NoSuchElementException();
            }
            while (step < 4 && this.tableImplementor(++step) == null) {
            }
            this.step = step;
            return ti;
        }

        private TableImplementor<?> tableImplementor(int step) {
            switch (step) {
                case 0: {
                    return MergedNode.this.innerChild;
                }
                case 1: {
                    return MergedNode.this.leftChild;
                }
                case 2: {
                    return MergedNode.this.rightChild;
                }
                case 3: {
                    return MergedNode.this.fullChild;
                }
            }
            return null;
        }
    }
}

