/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetcherSelectionImpl<T>
implements FetcherSelection<T>,
Ast {
    private final FetchPath path;
    private final Table<?> table;
    private final PropExpression.Embedded<?> embeddedPropExpression;
    private final Fetcher<?> fetcher;
    @Nullable
    private final Function<?, ?> converter;

    public FetcherSelectionImpl(Table<T> table, Fetcher<T> fetcher) {
        this.path = null;
        this.table = table;
        this.embeddedPropExpression = null;
        this.fetcher = fetcher;
        this.converter = null;
    }

    public FetcherSelectionImpl(Table<T> table, FetchPath path, Fetcher<T> fetcher) {
        this.path = path;
        this.table = table;
        this.embeddedPropExpression = null;
        this.fetcher = fetcher;
        this.converter = null;
    }

    public FetcherSelectionImpl(Table<?> table, Fetcher<?> fetcher, @Nullable Function<?, T> converter) {
        this.path = null;
        this.table = table;
        this.fetcher = fetcher;
        this.embeddedPropExpression = null;
        this.converter = converter;
    }

    public FetcherSelectionImpl(PropExpression.Embedded<T> embeddedPropExpression, Fetcher<T> fetcher) {
        this.path = null;
        this.table = ((PropExpressionImplementor)((Object)embeddedPropExpression)).getTable();
        this.fetcher = fetcher;
        this.embeddedPropExpression = embeddedPropExpression;
        this.converter = null;
    }

    public FetcherSelectionImpl(PropExpression.Embedded<?> embeddedPropExpression, Fetcher<?> fetcher, @Nullable Function<?, ?> converter) {
        this.path = null;
        this.table = ((PropExpressionImplementor)((Object)embeddedPropExpression)).getTable();
        this.fetcher = fetcher;
        this.embeddedPropExpression = embeddedPropExpression;
        this.converter = converter;
    }

    public Table<?> getTable() {
        return this.table;
    }

    @Override
    public FetchPath getPath() {
        return this.path;
    }

    @Override
    public PropExpression.Embedded<?> getEmbeddedPropExpression() {
        return this.embeddedPropExpression;
    }

    @Override
    public Fetcher<?> getFetcher() {
        return this.fetcher;
    }

    @Override
    @Nullable
    public Function<?, ?> getConverter() {
        return this.converter;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ImmutableProp embeddedRawReferenceProp = this.getEmbeddedRawReferenceProp(visitor.getAstContext().getSqlClient());
        if (embeddedRawReferenceProp != null) {
            visitor.visitTableReference(TableProxies.resolve(TableUtils.parent(this.table), visitor.getAstContext()), embeddedRawReferenceProp, true);
            return;
        }
        for (Field field : this.fetcher.getFieldMap().values()) {
            ImmutableProp prop = field.getProp();
            if (!prop.isColumnDefinition() && !(prop.getSqlTemplate() instanceof FormulaTemplate)) continue;
            visitor.visitTableReference(TableProxies.resolve(this.table, visitor.getAstContext()), prop, field.isRawId());
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> abstractBuilder) {
        SqlBuilder builder = abstractBuilder.assertSimple();
        MetadataStrategy strategy = builder.getAstContext().getSqlClient().getMetadataStrategy();
        ImmutableProp embeddedRawReferenceProp = this.getEmbeddedRawReferenceProp(builder.sqlClient());
        for (Field field : this.fetcher.getFieldMap().values()) {
            if (field.getProp().isFormula() && field.getProp().getSqlTemplate() == null) continue;
            ImmutableProp prop = field.getProp();
            String alias = TableProxies.resolve(this.table, builder.getAstContext()).getAlias();
            if (this.embeddedPropExpression != null) {
                String path = ((PropExpressionImplementor)((Object)this.embeddedPropExpression)).getPath();
                this.renderEmbedded(embeddedRawReferenceProp, embeddedRawReferenceProp != null ? (EmbeddedColumns)embeddedRawReferenceProp.getTargetType().getIdProp().getStorage(strategy) : (EmbeddedColumns)((PropExpressionImplementor)((Object)this.embeddedPropExpression)).getProp().getStorage(strategy), field.getChildFetcher(), path != null ? path + '.' + field.getProp().getName() : field.getProp().getName(), builder);
                continue;
            }
            Storage storage = prop.getStorage(strategy);
            SqlTemplate template = prop.getSqlTemplate();
            if (storage instanceof EmbeddedColumns) {
                this.renderEmbedded(null, (EmbeddedColumns)storage, field.getChildFetcher(), "", builder);
                continue;
            }
            if (storage instanceof ColumnDefinition) {
                ((SqlBuilder)builder.separator()).definition(alias, (ColumnDefinition)storage);
                continue;
            }
            if (!(template instanceof FormulaTemplate)) continue;
            ((SqlBuilder)builder.separator()).sql(((FormulaTemplate)template).toSql(alias));
        }
    }

    private void renderEmbedded(ImmutableProp embeddedRawReferenceProp, EmbeddedColumns columns, Fetcher<?> childFetcher, String path, @NotNull SqlBuilder builder) {
        MultipleJoinColumns joinColumns;
        String alias;
        if (embeddedRawReferenceProp != null) {
            Table<?> parent;
            if (this.table instanceof TableProxy) {
                TableProxy tableProxy = (TableProxy)this.table;
                parent = tableProxy.__parent();
            } else {
                TableImplementor tableImplementor = (TableImplementor)this.table;
                parent = tableImplementor.getParent();
            }
            alias = TableProxies.resolve(parent, builder.getAstContext()).getAlias();
        } else {
            alias = TableProxies.resolve(this.table, builder.getAstContext()).getAlias();
        }
        MultipleJoinColumns multipleJoinColumns = joinColumns = embeddedRawReferenceProp != null ? (MultipleJoinColumns)embeddedRawReferenceProp.getStorage(builder.sqlClient().getMetadataStrategy()) : null;
        if (childFetcher == null) {
            for (String columnName : columns.partial(path)) {
                ((SqlBuilder)((SqlBuilder)builder.separator()).sql(alias)).sql(".");
                if (joinColumns != null) {
                    builder.sql(joinColumns.name(joinColumns.referencedIndex(columnName)));
                    continue;
                }
                builder.sql(columnName);
            }
        } else {
            for (Field field : childFetcher.getFieldMap().values()) {
                ImmutableProp prop = field.getProp();
                if (prop.isFormula() && prop.getSqlTemplate() == null) continue;
                String propName = field.getProp().getName();
                this.renderEmbedded(embeddedRawReferenceProp, columns, field.getChildFetcher(), path.isEmpty() ? propName : path + '.' + propName, builder);
            }
        }
    }

    private ImmutableProp getEmbeddedRawReferenceProp(JSqlClientImplementor sqlClient) {
        ImmutableProp joinProp;
        if (this.embeddedPropExpression == null) {
            return null;
        }
        PropExpressionImpl pei = (PropExpressionImpl)((Object)this.embeddedPropExpression);
        if (!pei.getProp().isId()) {
            return null;
        }
        if (this.table instanceof TableProxy) {
            TableProxy tableProxy = (TableProxy)this.table;
            joinProp = tableProxy.__prop();
            if (tableProxy.__isInverse()) {
                joinProp = joinProp.getMappedBy();
            }
        } else {
            TableImplementor tableImplementor = (TableImplementor)this.table;
            joinProp = tableImplementor.getJoinProp();
            if (tableImplementor.isInverse()) {
                joinProp = joinProp.getMappedBy();
            }
        }
        if (joinProp == null || !joinProp.isColumnDefinition()) {
            return null;
        }
        if (sqlClient.getFilters().getTargetFilter(joinProp) != null) {
            return null;
        }
        return joinProp;
    }

    @Override
    public boolean hasVirtualPredicate() {
        return false;
    }

    @Override
    public Ast resolveVirtualPredicate(AstContext ctx) {
        return this;
    }

    public String toString() {
        return "FetcherSelectionImpl{fetcher=" + this.fetcher + '}';
    }
}

