/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Arrays;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.TargetTransferMode;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class SimpleEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements SimpleEntitySaveCommand<E> {
    public SimpleEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, E entity) {
        super(SimpleEntitySaveCommandImpl.initialCfg(sqlClient, con, entity));
    }

    private SimpleEntitySaveCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    @Override
    public SimpleSaveResult<E> execute(Connection con) {
        SaveOptions options = (SaveOptions)this.options();
        return options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, this::executeImpl);
    }

    private SimpleSaveResult<E> executeImpl(Connection con) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        ImmutableSpi entity = (ImmutableSpi)options.getArument();
        Saver saver = new Saver(options, con, entity.__type());
        return saver.save(entity);
    }

    private static AbstractCommandImpl.Cfg initialCfg(JSqlClientImplementor sqlClient, Connection con, Object entity) {
        if (!(entity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("entity must be an immutable object");
        }
        if (!((ImmutableSpi)entity).__type().isEntity()) {
            throw new IllegalArgumentException("the object is not instance of entity class");
        }
        if (entity instanceof DraftSpi) {
            throw new IllegalArgumentException("entity cannot be a draft object");
        }
        AbstractCommandImpl.Cfg cfg = new AbstractCommandImpl.RootCfg(sqlClient, entity);
        if (con != null) {
            cfg = new AbstractCommandImpl.ConnectionCfg(cfg, con);
        }
        return cfg;
    }

    @Override
    public SimpleEntitySaveCommand<E> setMode(SaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAssociatedModeAll(AssociatedSaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAssociatedMode(ImmutableProp prop, AssociatedSaveMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, prop, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setKeyProps(ImmutableProp ... props) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyPropsCfg(this.cfg, Arrays.asList(props)));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAutoIdOnlyTargetCheckingAll() {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, true));
    }

    @Override
    public SimpleEntitySaveCommand<E> setAutoIdOnlyTargetChecking(ImmutableProp prop, boolean checking) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, prop, checking));
    }

    @Override
    public SimpleEntitySaveCommand<E> setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.DissociationActionCfg(this.cfg, prop, dissociateAction));
    }

    @Override
    public SimpleEntitySaveCommand<E> setTargetTransferMode(ImmutableProp prop, TargetTransferMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, prop, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setTargetTransferModeAll(TargetTransferMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> setLockMode(LockMode lockMode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.LockModeCfg(this.cfg, lockMode));
    }

    @Override
    public <T extends Table<E>> SimpleEntitySaveCommand<E> setOptimisticLock(Class<T> tableType, UserOptimisticLock<E, T> block) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, ImmutableType.get(tableType), block));
    }

    @Override
    public SimpleEntitySaveCommand<E> setEntityOptimisticLock(ImmutableType type, UserOptimisticLock<Object, Table<Object>> block) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, type, block));
    }

    @Override
    public SimpleEntitySaveCommand<E> setDeleteMode(DeleteMode mode) {
        return new SimpleEntitySaveCommandImpl<E>(new AbstractCommandImpl.DeleteModeCfg(this.cfg, mode));
    }

    @Override
    public SimpleEntitySaveCommand<E> addExceptionTranslator(ExceptionTranslator<?> translator) {
        if (translator == null) {
            return this;
        }
        return new SimpleEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ExceptionTranslatorCfg(this.cfg, translator));
    }
}

