/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.babyfish.jimmer.ImmutableObjects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.NoTargetEntityIdPairsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Operator;
import org.babyfish.jimmer.sql.ast.impl.mutation.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MiddleTable;

public class Saver {
    private final SaveContext ctx;

    public Saver(SaveOptions options, Connection con, ImmutableType type) {
        this(new SaveContext(options, con, type));
    }

    private Saver(SaveContext ctx) {
        this.ctx = ctx;
    }

    public <E> SimpleSaveResult<E> save(E entity) {
        ImmutableType immutableType = ImmutableType.get(entity.getClass());
        MutationTrigger trigger = this.ctx.trigger;
        Object newEntity = Internal.produce((ImmutableType)immutableType, entity, draft -> this.saveAllImpl(Collections.singletonList((DraftSpi)draft)), trigger == null ? null : trigger::prepareSubmit);
        if (trigger != null) {
            trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
        return new SimpleSaveResult<Object>(this.ctx.affectedRowCountMap, entity, newEntity);
    }

    public <E> BatchSaveResult<E> saveAll(Collection<E> entities) {
        if (entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyList());
        }
        ImmutableType immutableType = ImmutableType.get(entities.iterator().next().getClass());
        MutationTrigger trigger = this.ctx.trigger;
        List newEntities = Internal.produceList((ImmutableType)immutableType, entities, drafts -> this.saveAllImpl((List<DraftSpi>)drafts), trigger == null ? null : trigger::prepareSubmit);
        if (trigger != null) {
            trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
        Iterator<E> oldItr = entities.iterator();
        Iterator newItr = newEntities.iterator();
        ArrayList<SimpleSaveResult<SimpleSaveResult<E>>> results = new ArrayList<SimpleSaveResult<SimpleSaveResult<E>>>(entities.size());
        while (oldItr.hasNext() && newItr.hasNext()) {
            results.add(new SimpleSaveResult<E>(this.ctx.affectedRowCountMap, oldItr.next(), newItr.next()));
        }
        return new BatchSaveResult(results);
    }

    private void saveAllImpl(List<DraftSpi> drafts) {
        for (Object prop : this.ctx.path.getType().getProps().values()) {
            if (!prop.isReference(TargetLevel.ENTITY) || !prop.isColumnDefinition()) continue;
            this.savePreAssociation((ImmutableProp)prop, drafts);
        }
        PreHandler preHandler = PreHandler.of(this.ctx);
        for (DraftSpi draft : drafts) {
            preHandler.add(draft);
        }
        boolean detach = this.saveSelf(preHandler);
        for (Batch<DraftSpi> batch : preHandler.associationBatches()) {
            for (ImmutableProp prop : batch.shape().getGetterMap().keySet()) {
                if (!prop.isAssociation(TargetLevel.ENTITY)) continue;
                if (this.ctx.options.getAssociatedMode(prop) == AssociatedSaveMode.VIOLENTLY_REPLACE) {
                    this.clearAssociations(batch.entities(), prop);
                }
                this.setBackReference(prop, batch);
                this.savePostAssociation(prop, batch, detach);
            }
        }
    }

    private void setBackReference(ImmutableProp prop, Batch<DraftSpi> batch) {
        ImmutableProp backProp = prop.getMappedBy();
        if (backProp != null && backProp.isColumnDefinition()) {
            ImmutableType parentType = prop.getDeclaringType();
            PropId idPropId = batch.shape().getType().getIdProp().getId();
            PropId propId = prop.getId();
            PropId backPropId = backProp.getId();
            for (DraftSpi draft : batch.entities()) {
                if (!draft.__isLoaded(idPropId)) continue;
                Object idOnlyParent = ImmutableObjects.makeIdOnly((ImmutableType)parentType, (Object)draft.__get(idPropId));
                Object associated = draft.__get(propId);
                if (associated instanceof Collection) {
                    for (DraftSpi child : (List)associated) {
                        child.__set(backPropId, idOnlyParent);
                    }
                    continue;
                }
                if (!(associated instanceof DraftSpi)) continue;
                ((DraftSpi)associated).__set(backPropId, idOnlyParent);
            }
        }
    }

    private void savePreAssociation(ImmutableProp prop, List<DraftSpi> drafts) {
        Saver targetSaver = new Saver(this.ctx.prop(prop));
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(drafts.size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : drafts) {
            if (!draft.__isLoaded(targetPropId)) continue;
            DraftSpi target = (DraftSpi)draft.__get(targetPropId);
            if (target != null) {
                targets.add(target);
                continue;
            }
            if (prop.isNullable() && !prop.isInputNotNull()) continue;
            targetSaver.ctx.throwNullTarget();
        }
        if (!targets.isEmpty()) {
            targetSaver.saveAllImpl(targets);
        }
    }

    private void savePostAssociation(ImmutableProp prop, Batch<DraftSpi> batch, boolean detachOtherSiblings) {
        Saver targetSaver = new Saver(this.ctx.prop(prop));
        if (this.isReadOnlyMiddleTable(prop)) {
            targetSaver.ctx.throwReadonlyMiddleTable();
        }
        if (prop.isRemote() && prop.getMappedBy() != null) {
            targetSaver.ctx.throwReversedRemoteAssociation();
        }
        if (prop.getSqlTemplate() instanceof JoinTemplate) {
            targetSaver.ctx.throwUnstructuredAssociation();
        }
        ArrayList<DraftSpi> targets = new ArrayList<DraftSpi>(batch.entities().size());
        PropId targetPropId = prop.getId();
        for (DraftSpi draft : batch.entities()) {
            Object value = draft.__get(targetPropId);
            if (value instanceof List) {
                targets.addAll((List)value);
                continue;
            }
            if (value != null) {
                targets.add((DraftSpi)value);
                continue;
            }
            if (prop.isNullable() && !prop.isInputNotNull()) continue;
            targetSaver.ctx.throwNullTarget();
        }
        if (!targets.isEmpty()) {
            targetSaver.saveAllImpl(targets);
        }
        if (this.ctx.options.getAssociatedMode(prop) != AssociatedSaveMode.VIOLENTLY_REPLACE) {
            this.updateAssociations(batch, prop, detachOtherSiblings);
        }
    }

    private boolean saveSelf(PreHandler preHandler) {
        Operator operator = new Operator(this.ctx);
        boolean detach = false;
        block4: for (Batch<DraftSpi> batch : preHandler.batches()) {
            switch (batch.mode()) {
                case INSERT_ONLY: {
                    operator.insert(batch);
                    continue block4;
                }
                case UPDATE_ONLY: {
                    detach = true;
                    operator.update(preHandler.originalIdObjMap(), preHandler.originalkeyObjMap(), batch);
                    continue block4;
                }
            }
            detach = true;
            operator.upsert(batch);
        }
        return detach;
    }

    private void clearAssociations(Collection<? extends ImmutableSpi> rows, ImmutableProp prop) {
        ChildTableOperator subOperator = null;
        MiddleTableOperator middleTableOperator = null;
        if (prop.isMiddleTableDefinition()) {
            middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
        } else {
            ImmutableProp mappedBy = prop.getMappedBy();
            if (mappedBy != null) {
                if (mappedBy.isColumnDefinition()) {
                    subOperator = new ChildTableOperator(new DeleteContext(DeleteOptions.detach(this.ctx.options), this.ctx.con, this.ctx.trigger, this.ctx.affectedRowCountMap, this.ctx.path.to(prop)));
                } else if (mappedBy.isMiddleTableDefinition()) {
                    middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
                }
            }
        }
        if (subOperator == null && middleTableOperator == null) {
            return;
        }
        NoTargetEntityIdPairsImpl noTargetIdPairs = new NoTargetEntityIdPairsImpl(rows);
        if (subOperator != null) {
            subOperator.disconnectExcept(noTargetIdPairs);
        }
        if (middleTableOperator != null) {
            middleTableOperator.disconnectExcept(noTargetIdPairs);
        }
    }

    private void updateAssociations(Batch<DraftSpi> batch, ImmutableProp prop, boolean detach) {
        ChildTableOperator subOperator = null;
        MiddleTableOperator middleTableOperator = null;
        if (prop.isMiddleTableDefinition()) {
            middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
        } else {
            ImmutableProp mappedBy = prop.getMappedBy();
            if (mappedBy != null) {
                if (mappedBy.isColumnDefinition()) {
                    subOperator = new ChildTableOperator(new DeleteContext(DeleteOptions.detach(this.ctx.options), this.ctx.con, this.ctx.trigger, this.ctx.affectedRowCountMap, this.ctx.path.to(prop)));
                } else if (mappedBy.isMiddleTableDefinition()) {
                    middleTableOperator = new MiddleTableOperator(this.ctx.prop(prop), this.ctx.options.getDeleteMode() == DeleteMode.LOGICAL);
                }
            }
        }
        if (subOperator == null && middleTableOperator == null) {
            return;
        }
        IdPairs.Retain retainedIdPairs = IdPairs.retain(batch.entities(), prop);
        if (subOperator != null && detach && this.ctx.options.getAssociatedMode(prop) == AssociatedSaveMode.REPLACE) {
            subOperator.disconnectExcept(retainedIdPairs);
        }
        if (middleTableOperator != null) {
            if (detach) {
                switch (this.ctx.options.getAssociatedMode(prop)) {
                    case APPEND: 
                    case VIOLENTLY_REPLACE: {
                        middleTableOperator.append(retainedIdPairs);
                        break;
                    }
                    case UPDATE: 
                    case MERGE: {
                        middleTableOperator.merge(retainedIdPairs);
                        break;
                    }
                    case REPLACE: {
                        middleTableOperator.replace(retainedIdPairs);
                    }
                }
            } else {
                middleTableOperator.append(retainedIdPairs);
            }
        }
    }

    private boolean isReadOnlyMiddleTable(ImmutableProp prop) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            prop = mappedBy;
        }
        if (prop.isMiddleTableDefinition()) {
            MiddleTable middleTable = (MiddleTable)prop.getStorage(this.ctx.options.getSqlClient().getMetadataStrategy());
            return middleTable.isReadonly();
        }
        return false;
    }
}

