/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractAssociationOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.AffectedRows;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectingType;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectionArgs;
import org.babyfish.jimmer.sql.ast.impl.mutation.ExclusiveIdPairPredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.Investigators;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableInvestigator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Tuples;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.meta.JoinTableFilterInfo;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.Nullable;

class MiddleTableOperator
extends AbstractAssociationOperator {
    private static final int[] EMPTY_ROW_COUNTS = new int[0];
    private final MutationPath path;
    private final ExceptionTranslator<Exception> exceptionTranslator;
    private final MutationTrigger trigger;
    final Map<AffectedTable, Integer> affectedRowCount;
    final MiddleTable middleTable;
    private final List<ValueGetter> sourceGetters;
    private final List<ValueGetter> targetGetters;
    private final List<ValueGetter> getters;
    private final DisconnectingType disconnectingType;
    private final QueryReason queryReason;
    private final ChildTableOperator parent;
    private final String alias;

    MiddleTableOperator(SaveContext ctx, boolean isSourceLogicalDeleted) {
        this(ctx.options.getSqlClient(), ctx.con, ctx.path, ctx.options.getExceptionTranslator(), ctx.trigger, ctx.affectedRowCountMap, null, isSourceLogicalDeleted);
    }

    static MiddleTableOperator propOf(ChildTableOperator parent, ImmutableProp prop) {
        return new MiddleTableOperator(parent, parent.ctx.propOf(prop));
    }

    static MiddleTableOperator backPropOf(ChildTableOperator parent, ImmutableProp backProp) {
        return new MiddleTableOperator(parent, parent.ctx.backPropOf(backProp));
    }

    private MiddleTableOperator(ChildTableOperator parent, DeleteContext ctx) {
        this(ctx.options.getSqlClient(), ctx.con, ctx.path, ctx.options.getSqlClient().getExceptionTranslator(), ctx.trigger, ctx.affectedRowCountMap, parent, parent.disconnectingType == DisconnectingType.LOGICAL_DELETE);
    }

    MiddleTableOperator(JSqlClientImplementor sqlClient, Connection con, MutationPath path, ExceptionTranslator<Exception> exceptionTranslator, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap, ChildTableOperator parent, boolean isSourceLogicalDeleted) {
        super(sqlClient, con);
        AssociationType associationType;
        ImmutableProp associationProp = path.getProp();
        boolean inverse = false;
        if (associationProp != null) {
            if (associationProp.getMappedBy() != null) {
                associationProp = associationProp.getMappedBy();
                inverse = true;
            }
        } else {
            associationProp = path.getBackProp();
            if (associationProp.getMappedBy() != null) {
                associationProp = associationProp.getMappedBy();
            } else {
                inverse = true;
            }
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        this.path = path;
        this.exceptionTranslator = exceptionTranslator;
        this.trigger = trigger;
        this.affectedRowCount = affectedRowCountMap;
        if (inverse) {
            this.middleTable = ((MiddleTable)associationProp.getStorage(strategy)).getInverse();
            associationType = AssociationType.of(associationProp);
            this.sourceGetters = ValueGetter.valueGetters(sqlClient, associationType.getTargetProp());
            this.targetGetters = ValueGetter.valueGetters(sqlClient, associationType.getSourceProp());
        } else {
            this.middleTable = (MiddleTable)associationProp.getStorage(strategy);
            associationType = AssociationType.of(associationProp);
            this.sourceGetters = ValueGetter.valueGetters(sqlClient, associationType.getSourceProp());
            this.targetGetters = ValueGetter.valueGetters(sqlClient, associationType.getTargetProp());
        }
        DisconnectingType disconnectingType = !this.middleTable.isCascadeDeletedBySource() && !this.middleTable.getColumnDefinition().isForeignKey() ? DisconnectingType.NONE : (this.middleTable.getLogicalDeletedInfo() == null ? DisconnectingType.PHYSICAL_DELETE : (this.middleTable.isDeletedWhenEndpointIsLogicallyDeleted() ? DisconnectingType.PHYSICAL_DELETE : (parent != null && parent.disconnectingType == DisconnectingType.PHYSICAL_DELETE ? DisconnectingType.PHYSICAL_DELETE : (path.getParent().getType().getLogicalDeletedInfo() == null ? DisconnectingType.PHYSICAL_DELETE : (!isSourceLogicalDeleted ? DisconnectingType.PHYSICAL_DELETE : DisconnectingType.LOGICAL_DELETE)))));
        QueryReason queryReason = QueryReason.NONE;
        if (trigger != null) {
            queryReason = QueryReason.TRIGGER;
        } else if (parent != null && parent.mutationSubQueryDepth >= sqlClient.getMaxCommandJoinCount()) {
            queryReason = QueryReason.TOO_DEEP;
        } else if (!sqlClient.getDialect().isUpsertSupported()) {
            queryReason = QueryReason.UPSERT_NOT_SUPPORTED;
        } else if (disconnectingType.isDelete() && this.sourceGetters.size() > 1 && !sqlClient.getDialect().isTupleSupported()) {
            queryReason = QueryReason.TUPLE_IS_UNSUPPORTED;
        }
        this.disconnectingType = disconnectingType;
        this.queryReason = queryReason;
        this.getters = ValueGetter.tupleGetters(this.sourceGetters, this.targetGetters);
        this.parent = parent;
        this.alias = parent != null ? "tb_1_" : null;
    }

    public void append(IdPairs idPairs) {
        this.connect(idPairs);
        MutationTrigger trigger = this.trigger;
        if (trigger != null) {
            for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
                this.fireInsert(idTuple.get_1(), idTuple.get_2());
            }
        }
    }

    public final void merge(IdPairs idPairs) {
        if (this.queryReason == QueryReason.NONE) {
            int[] rowCounts = this.connectIfNecessary(idPairs);
            int index = 0;
            MutationTrigger trigger = this.trigger;
            for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
                if (rowCounts[index++] == 0 || trigger == null) continue;
                this.fireInsert(idTuple.get_1(), idTuple.get_2());
            }
            return;
        }
        Set<Tuple2<Object, Object>> existingIdTuples = this.findByTuples(idPairs.tuples(), this.queryReason);
        ArrayList<Tuple2<Object, Object>> insertingIdTuples = new ArrayList<Tuple2<Object, Object>>(idPairs.tuples().size() - existingIdTuples.size());
        for (Tuple2<Object, Object> idTuple : idPairs.tuples()) {
            if (existingIdTuples.contains(idTuple)) continue;
            insertingIdTuples.add(idTuple);
        }
        this.append(IdPairs.of(insertingIdTuples));
    }

    public final void delete(IdPairs idPairs) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            this.disconnect(idPairs);
            return;
        }
        Collection<Tuple2<Object, Object>> idTuples = idPairs.tuples();
        idTuples = this.findByTuples(idTuples, null);
        for (Tuple2<Object, Object> idTuple : idTuples) {
            this.fireDelete(idTuple.get_1(), idTuple.get_2());
        }
        this.disconnect(idPairs);
    }

    public final void replace(IdPairs.Retain idPairs) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null && this.isUpsertUsed()) {
            this.disconnectExcept(idPairs);
            this.connectIfNecessary(idPairs);
            return;
        }
        Collection<Tuple2<Object, Object>> idTuples = idPairs.tuples();
        if (!(idTuples instanceof Set)) {
            idTuples = new LinkedHashSet<Tuple2<Object, Object>>(idTuples);
        }
        LinkedHashSet<Object> sourceIds = new LinkedHashSet<Object>();
        for (Tuple2<Object, Collection<Object>> tuple : idPairs.entries()) {
            sourceIds.add(tuple.get_1());
        }
        Set<Tuple2<Object, Object>> existingIdTuples = this.find(sourceIds);
        ArrayList<Tuple2<Object, Object>> insertingIdTuples = new ArrayList<Tuple2<Object, Object>>();
        ArrayList<Tuple2<Object, Object>> deletingIdTuples = new ArrayList<Tuple2<Object, Object>>();
        for (Tuple2<Object, Object> idTuple : idTuples) {
            if (existingIdTuples.contains(idTuple)) continue;
            insertingIdTuples.add(idTuple);
        }
        for (Tuple2<Object, Object> existingIdTuple : existingIdTuples) {
            if (idTuples.contains(existingIdTuple)) continue;
            deletingIdTuples.add(existingIdTuple);
        }
        this.disconnect(IdPairs.of(deletingIdTuples));
        this.connect(IdPairs.of(insertingIdTuples));
        if (trigger != null) {
            for (Tuple2<Object, Object> idTuple : insertingIdTuples) {
                this.fireInsert(idTuple.get_1(), idTuple.get_2());
            }
            for (Tuple2<Object, Object> idTuple : deletingIdTuples) {
                this.fireDelete(idTuple.get_1(), idTuple.get_2());
            }
        }
    }

    final Set<Tuple2<Object, Object>> find(Collection<Object> ids) {
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
        if (ids.size() == 1) {
            for (ValueGetter getter : this.targetGetters) {
                ((SqlBuilder)builder.separator()).sql(getter);
            }
        } else {
            for (ValueGetter getter : this.getters) {
                ((SqlBuilder)builder.separator()).sql(getter);
            }
        }
        builder.leave();
        ((SqlBuilder)((SqlBuilder)builder.sql(" from ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.WHERE);
        ComparisonPredicates.renderIn(false, this.sourceGetters, ids, builder);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        return this.find(ids.size() == 1 ? ids.iterator().next() : null, builder, null);
    }

    final Set<Tuple2<Object, Object>> findByTuples(Collection<Tuple2<Object, Object>> idTuples, @Nullable QueryReason optionalQueryReason) {
        if (idTuples.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
        if (idTuples.size() == 1) {
            for (ValueGetter getter : this.targetGetters) {
                ((SqlBuilder)builder.separator()).sql(getter);
            }
        } else {
            for (ValueGetter getter : this.getters) {
                ((SqlBuilder)builder.separator()).sql(getter);
            }
        }
        builder.leave();
        ((SqlBuilder)((SqlBuilder)builder.sql(" from ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.WHERE);
        ArrayList<TupleImplementor> rows = new ArrayList<TupleImplementor>(idTuples.size());
        for (Tuple2<Object, Object> tuple : idTuples) {
            Object[] arr = new Object[this.getters.size()];
            int index = 0;
            Object a = tuple.get_1();
            Object b = tuple.get_2();
            if (a instanceof TupleImplementor) {
                index += ((TupleImplementor)a).copyTo(arr, 0);
            } else {
                arr[index++] = a;
            }
            if (b instanceof TupleImplementor) {
                ((TupleImplementor)b).copyTo(arr, 0);
            } else {
                arr[index] = b;
            }
            rows.add(Tuples.valueOf(arr));
        }
        ComparisonPredicates.renderIn(false, this.getters, rows, builder);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        return this.find(idTuples.size() == 1 ? idTuples.iterator().next().get_1() : null, builder, optionalQueryReason);
    }

    private Set<Tuple2<Object, Object>> find(DisconnectionArgs args) {
        if (args.deletedIds != null && args.caller == this.parent) {
            return this.find(args.deletedIds);
        }
        if (args.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(AbstractSqlBuilder.ScopeType.SELECT);
        for (ValueGetter getter : this.getters) {
            ((SqlBuilder)builder.separator()).sql(getter);
        }
        builder.leave();
        ((SqlBuilder)((SqlBuilder)builder.sql(" from ")).sql(this.middleTable.getTableName())).sql(" tb_1_");
        ((SqlBuilder)((SqlBuilder)builder.sql(" inner join ")).sql(this.parent.ctx.path.getType().getTableName(this.sqlClient.getMetadataStrategy()))).sql(" tb_2_ on ");
        builder.enter(AbstractSqlBuilder.ScopeType.AND);
        int size = this.sourceGetters.size();
        for (int i = 0; i < size; ++i) {
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.separator()).sql("tb_1_.")).sql(this.sourceGetters.get(i))).sql(" = tb_2_.")).sql(this.parent.targetGetters.get(i));
        }
        builder.leave();
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.parent.addPredicates(builder, args, 2);
        builder.leave();
        return this.find(null, builder, null);
    }

    private Set<Tuple2<Object, Object>> find(Object onlyOneSourceId, SqlBuilder builder, @Nullable QueryReason optionalQueryReason) {
        Reader<?> targetIdReader;
        Reader<?> sourceIdReader;
        Tuple3<String, List<Object>, List<Integer>> tuple = builder.build();
        if (this.path.getProp() != null) {
            sourceIdReader = onlyOneSourceId == null ? this.sqlClient.getReader(this.path.getProp().getDeclaringType().getIdProp()) : null;
            targetIdReader = this.sqlClient.getReader(this.path.getProp().getTargetType().getIdProp());
        } else {
            sourceIdReader = onlyOneSourceId == null ? this.sqlClient.getReader(this.path.getBackProp().getTargetType().getIdProp()) : null;
            targetIdReader = this.sqlClient.getReader(this.path.getBackProp().getDeclaringType().getIdProp());
        }
        return this.sqlClient.getExecutor().execute(new Executor.Args<Set>(this.sqlClient, this.con, tuple.get_1(), tuple.get_2(), tuple.get_3(), ExecutionPurpose.command(optionalQueryReason != null ? optionalQueryReason : this.queryReason), null, stmt -> {
            Reader.Context ctx = new Reader.Context(null, this.sqlClient);
            LinkedHashSet idTuples = new LinkedHashSet();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ctx.resetCol();
                    Object sourceId = sourceIdReader != null ? sourceIdReader.read(rs, ctx) : onlyOneSourceId;
                    Object targetId = targetIdReader.read(rs, ctx);
                    idTuples.add(new Tuple2(sourceId, targetId));
                }
            }
            return idTuples;
        }));
    }

    final void connect(IdPairs idPairs) {
        if (idPairs.tuples().isEmpty()) {
            return;
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("insert into ")).sql(this.middleTable.getTableName())).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.appendColumns(builder);
        builder.leave();
        ((BatchSqlBuilder)builder.sql(" values")).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        this.appendValues(builder);
        builder.leave();
        int rowCount = this.execute(builder, idPairs.tuples(), (ex, ctx) -> this.translateConnectException((SQLException)ex, (Executor.BatchContext)ctx, idPairs.tuples()));
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    final int[] connectIfNecessary(IdPairs idPairs) {
        if (idPairs.tuples().isEmpty()) {
            return EMPTY_ROW_COUNTS;
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.sqlClient.getDialect().upsert(new UpsertContextImpl(builder));
        int[] rowCounts = this.executeImpl(builder, idPairs.tuples(), (ex, ctx) -> this.translateConnectException((SQLException)ex, (Executor.BatchContext)ctx, idPairs.tuples()));
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), this.sumRowCount(rowCounts));
        return rowCounts;
    }

    final void disconnect(IdPairs idPairs) {
        if (idPairs.isEmpty()) {
            return;
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.addOperation(builder, true);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql(getter)).sql(" = ")).variable(getter);
        }
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        int rowCount = this.execute(builder, idPairs.tuples(), null);
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    final void disconnect(Collection<Object> ids) {
        this.disconnect(DisconnectionArgs.delete(ids, null).withTrigger(true));
    }

    final void disconnect(DisconnectionArgs args) {
        if (args.isEmpty() || this.disconnectingType == DisconnectingType.NONE) {
            return;
        }
        if (this.queryReason != QueryReason.TUPLE_IS_UNSUPPORTED && this.queryReason != QueryReason.NONE) {
            Set<Tuple2<Object, Object>> tuples = this.find(args);
            this.disconnect(IdPairs.of(tuples));
            if (args.fireEvents && this.trigger != null) {
                for (Tuple2<Object, Object> tuple : tuples) {
                    this.fireDelete(tuple.get_1(), tuple.get_2());
                }
            }
            return;
        }
        if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
            this.addOperation(builder, false);
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.addPredicate(builder, this.parent, args);
            this.addLogicalDeletedPredicate(builder);
            this.addFilterPredicate(builder);
            builder.leave();
            int rowCount = this.execute(builder, args.deletedIds != null ? args.deletedIds : args.retainedIdPairs.entries(), null);
            AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
            return;
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        this.addOperation(builder, false);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicate(builder, this.parent, args);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        int rowCount = this.execute(builder);
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    final void disconnectExcept(IdPairs.Retain idPairs) {
        Collection<Tuple2<Object, Collection<Object>>> entries = idPairs.entries();
        if (entries.isEmpty()) {
            return;
        }
        if (idPairs.entries().size() == 1) {
            Tuple2<Object, Collection<Object>> entry = entries.iterator().next();
            this.disconnectExceptBySimpleInPredicate(entry.get_1(), entry.get_2());
        } else if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            this.disconnectExceptByBatch(idPairs);
        } else {
            this.disconnectExceptByComplexInPredicate(idPairs);
        }
    }

    private void disconnectExceptByBatch(IdPairs idPairs) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.addOperation(builder, false);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        int rowCount = this.execute(builder, idPairs.entries(), null);
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    private void disconnectExceptBySimpleInPredicate(Object sourceId, Collection<Object> targetIds) {
        AstContext astContext = new AstContext(this.sqlClient);
        SqlBuilder builder = new SqlBuilder(astContext);
        this.addOperation(builder, false);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters, sourceId, targetIds);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        int rowCount = this.execute(builder);
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    private void disconnectExceptByComplexInPredicate(IdPairs idPairs) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        this.addOperation(builder, false);
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters, idPairs);
        this.addLogicalDeletedPredicate(builder);
        this.addFilterPredicate(builder);
        builder.leave();
        int rowCount = this.execute(builder);
        AffectedRows.add(this.affectedRowCount, this.path.getProp(), rowCount);
    }

    private void addOperation(AbstractSqlBuilder<?> builder, boolean ignoreAlias) {
        if (this.disconnectingType == DisconnectingType.LOGICAL_DELETE) {
            ((AbstractSqlBuilder)builder.sql("update ")).sql(this.middleTable.getTableName());
            if (!ignoreAlias && this.alias != null) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(this.alias);
            }
            builder.enter(AbstractSqlBuilder.ScopeType.SET);
            builder.logicalDeleteAssignment(this.middleTable.getLogicalDeletedInfo(), null, ignoreAlias ? null : this.alias);
            builder.leave();
        } else {
            ((AbstractSqlBuilder)builder.sql("delete from ")).sql(this.middleTable.getTableName());
            if (!ignoreAlias && this.alias != null) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(this.alias);
            }
        }
    }

    private void addPredicate(AbstractSqlBuilder<?> builder, ChildTableOperator parent, DisconnectionArgs args) {
        if (parent == null) {
            if (args.deletedIds != null) {
                if (builder instanceof BatchSqlBuilder) {
                    BatchSqlBuilder batchSqlBuilder = (BatchSqlBuilder)builder;
                    int size = this.sourceGetters.size();
                    builder.enter(size == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.AND);
                    for (ValueGetter sourceGetter : this.sourceGetters) {
                        ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)batchSqlBuilder.separator()).sql(sourceGetter)).sql(" = ")).variable(sourceGetter);
                    }
                    builder.leave();
                } else {
                    ComparisonPredicates.renderIn(false, this.sourceGetters, args.deletedIds, (SqlBuilder)builder);
                }
            } else {
                this.disconnect(args.retainedIdPairs);
            }
            return;
        }
        ((AbstractSqlBuilder)builder.sql("exists ")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
        ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql("select * from ")).sql(this.path.getParent().getType().getTableName(this.sqlClient.getMetadataStrategy()))).sql(" tb_2_");
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        int size = this.sourceGetters.size();
        builder.enter(size == 1 ? AbstractSqlBuilder.ScopeType.NULL : AbstractSqlBuilder.ScopeType.AND);
        for (int i = 0; i < size; ++i) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql("tb_1_.")).sql(this.sourceGetters.get(i))).sql(" = ")).sql("tb_2_.")).sql(parent.targetGetters.get(i));
        }
        builder.leave();
        parent.addPredicates(builder, args, 2);
        builder.leave();
        builder.leave();
    }

    private void addLogicalDeletedPredicate(AbstractSqlBuilder<?> builder) {
        if (this.disconnectingType != DisconnectingType.LOGICAL_DELETE) {
            return;
        }
        LogicalDeletedInfo logicalDeletedInfo = this.middleTable.getLogicalDeletedInfo();
        if (logicalDeletedInfo == null) {
            return;
        }
        builder.separator();
        LogicalDeletedInfo.Action action = logicalDeletedInfo.getAction();
        if (action instanceof LogicalDeletedInfo.Action.Eq) {
            LogicalDeletedInfo.Action.Eq eq = (LogicalDeletedInfo.Action.Eq)action;
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" = ")).rawVariable(eq.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.Ne) {
            LogicalDeletedInfo.Action.Ne ne = (LogicalDeletedInfo.Action.Ne)action;
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" <> ")).rawVariable(ne.getValue());
        } else if (action instanceof LogicalDeletedInfo.Action.IsNull) {
            ((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" is null");
        } else if (action instanceof LogicalDeletedInfo.Action.IsNotNull) {
            ((AbstractSqlBuilder)builder.sql(logicalDeletedInfo.getColumnName())).sql(" is not null");
        }
    }

    private void addFilterPredicate(AbstractSqlBuilder<?> builder) {
        JoinTableFilterInfo filterInfo = this.middleTable.getFilterInfo();
        if (filterInfo == null) {
            return;
        }
        ((AbstractSqlBuilder)builder.separator()).sql(filterInfo.getColumnName());
        if (filterInfo.getValues().size() == 1) {
            ((AbstractSqlBuilder)builder.sql(" = ")).rawVariable(filterInfo.getValues().get(0));
        } else {
            ((AbstractSqlBuilder)builder.sql(" in ")).enter(AbstractSqlBuilder.ScopeType.LIST);
            for (Object value : filterInfo.getValues()) {
                ((AbstractSqlBuilder)builder.separator()).rawVariable(value);
            }
            builder.leave();
        }
    }

    private void appendColumns(BatchSqlBuilder builder) {
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)builder.separator()).sql(getter);
        }
        if (this.middleTable.getLogicalDeletedInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).sql(this.middleTable.getLogicalDeletedInfo().getColumnName());
        }
        if (this.middleTable.getFilterInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).sql(this.middleTable.getFilterInfo().getColumnName());
        }
    }

    private void appendValues(BatchSqlBuilder builder) {
        for (ValueGetter getter : this.getters) {
            ((BatchSqlBuilder)builder.separator()).variable(getter);
        }
        if (this.middleTable.getLogicalDeletedInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).rawVariable(this.middleTable.getLogicalDeletedInfo().allocateInitializedValue());
        }
        if (this.middleTable.getFilterInfo() != null) {
            ((BatchSqlBuilder)builder.separator()).rawVariable(this.middleTable.getFilterInfo().getValues().get(0));
        }
    }

    private boolean isUpsertUsed() {
        Dialect dialect = this.sqlClient.getDialect();
        return dialect.isUpsertSupported() && this.trigger == null;
    }

    private void fireInsert(Object sourceId, Object targetId) {
        ImmutableProp prop = this.path.getProp();
        if (prop != null) {
            this.trigger.insertMiddleTable(prop, sourceId, targetId);
        } else {
            this.trigger.insertMiddleTable(this.path.getBackProp(), targetId, sourceId);
        }
    }

    private void fireDelete(Object sourceId, Object targetId) {
        ImmutableProp prop = this.path.getProp();
        if (prop != null) {
            this.trigger.deleteMiddleTable(prop, sourceId, targetId);
        } else {
            this.trigger.deleteMiddleTable(this.path.getBackProp(), targetId, sourceId);
        }
    }

    private Exception translateConnectException(SQLException ex, Executor.BatchContext ctx, Collection<Tuple2<Object, Object>> idTuples) {
        if (!ex.getSQLState().startsWith("23") || !(ex instanceof BatchUpdateException)) {
            return this.convertFinalException(ex, ctx);
        }
        BatchUpdateException bue = (BatchUpdateException)ex;
        MiddleTableInvestigator investigator = new MiddleTableInvestigator(bue, Investigators.toInvestigatorSqlClient(this.sqlClient, ctx), this.con, this.path, idTuples);
        Exception translated = investigator.investigate();
        return this.convertFinalException(translated, ctx);
    }

    private Exception convertFinalException(Exception ex, Executor.BatchContext ctx) {
        if (this.exceptionTranslator == null) {
            return ex;
        }
        return this.exceptionTranslator.translate(ex, ctx);
    }

    private class UpsertContextImpl
    implements Dialect.UpsertContext {
        private final BatchSqlBuilder builder;

        UpsertContextImpl(BatchSqlBuilder builder) {
            this.builder = builder;
        }

        @Override
        public boolean hasUpdatedColumns() {
            return false;
        }

        @Override
        public boolean hasOptimisticLock() {
            return false;
        }

        @Override
        public boolean hasGeneratedId() {
            return false;
        }

        @Override
        public List<ValueGetter> getConflictGetters() {
            return MiddleTableOperator.this.getters;
        }

        @Override
        public Dialect.UpsertContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpsertContext sql(ValueGetter getter) {
            this.builder.sql(getter);
            return this;
        }

        @Override
        public Dialect.UpsertContext enter(AbstractSqlBuilder.ScopeType type) {
            this.builder.enter(type);
            return this;
        }

        @Override
        public Dialect.UpsertContext separator() {
            this.builder.separator();
            return this;
        }

        @Override
        public Dialect.UpsertContext leave() {
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendTableName() {
            this.builder.sql(MiddleTableOperator.this.middleTable.getTableName());
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertedColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendColumns(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendConflictColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendColumns(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertingValues() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            MiddleTableOperator.this.appendValues(this.builder);
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendUpdatingAssignments(String prefix, String suffix) {
            return this;
        }

        @Override
        public Dialect.UpsertContext appendOptimisticLockCondition(String sourceTablePrefix) {
            return this;
        }

        @Override
        public Dialect.UpsertContext appendGeneratedId() {
            return this;
        }
    }
}

