/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;

class MiddleTableInvestigator {
    private final BatchUpdateException ex;
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final MutationPath path;
    private final ImmutableType targetType;
    private final Collection<Tuple2<Object, Object>> idTuples;
    private final Fetcher<ImmutableSpi> targetIdFetcher;

    MiddleTableInvestigator(BatchUpdateException ex, JSqlClientImplementor sqlClient, Connection con, MutationPath path, Collection<Tuple2<Object, Object>> idTuples) {
        this.ex = ex;
        this.sqlClient = sqlClient;
        this.con = con;
        this.path = path;
        this.targetType = path.getProp().getTargetType();
        this.idTuples = idTuples;
        this.targetIdFetcher = new FetcherImpl<ImmutableSpi>(this.targetType.getJavaClass());
    }

    public Exception investigate() {
        if (this.sqlClient.getDialect().isBatchUpdateExceptionUnreliable()) {
            Exception translated = this.translateAll();
            if (translated != null) {
                return translated;
            }
        } else {
            int[] rowCounts = this.ex.getUpdateCounts();
            int index = 0;
            for (Tuple2<Object, Object> idTuple : this.idTuples) {
                Exception translated;
                if (rowCounts[index++] >= 0 || (translated = this.translateOne(idTuple)) == null) continue;
                return translated;
            }
        }
        return this.ex;
    }

    private Exception translateOne(Tuple2<Object, Object> idTuple) {
        List<ImmutableSpi> targets = Rows.findRows(this.sqlClient, this.con, this.targetType, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.targetIdFetcher, (q, t) -> q.where(t.getId().eq(idTuple.get_2())));
        if (targets.isEmpty()) {
            return MutationContext.createIllegalTargetId(this.path, Collections.singleton(idTuple.get_2()));
        }
        return null;
    }

    private Exception translateAll() {
        Collection<Object> targetIds = Tuple2.projection2(this.idTuples);
        List<ImmutableSpi> existingTargets = Rows.findRows(this.sqlClient, this.con, this.targetType, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.targetIdFetcher, (q, t) -> q.where(t.getId().in(targetIds)));
        LinkedHashSet<Object> existingTargetIds = new LinkedHashSet<Object>((existingTargets.size() * 4 + 2) / 3);
        PropId targetIdPropId = this.targetType.getIdProp().getId();
        for (ImmutableSpi target : existingTargets) {
            existingTargetIds.add(target.__get(targetIdPropId));
        }
        for (Object targetId : targetIds) {
            if (existingTargetIds.contains(targetId)) continue;
            return MutationContext.createIllegalTargetId(this.path, Collections.singleton(targetId));
        }
        return null;
    }
}

