/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.CheckReturnValue;
import org.slf4j.spi.LoggingEventBuilder;

class InvestigatorLogger
implements Logger {
    private final Logger raw;
    private final List<Op> ops = new ArrayList<Op>();

    InvestigatorLogger(Logger raw) {
        this.raw = raw;
    }

    public void submit() {
        for (Op op : this.ops) {
            switch (op.level) {
                case INFO: {
                    if (op.throwable != null) {
                        this.raw.info(op.fmt, op.throwable);
                        break;
                    }
                    this.raw.info(op.fmt, op.arguments);
                    break;
                }
                case WARN: {
                    if (op.throwable != null) {
                        this.raw.warn(op.fmt, op.throwable);
                        break;
                    }
                    this.raw.warn(op.fmt, op.arguments);
                    break;
                }
                case ERROR: {
                    if (op.throwable != null) {
                        this.raw.error(op.fmt, op.throwable);
                        break;
                    }
                    this.raw.error(op.fmt, op.arguments);
                }
            }
        }
        this.ops.clear();
    }

    public String getName() {
        return this.raw.getName();
    }

    public LoggingEventBuilder makeLoggingEventBuilder(Level level) {
        return this.raw.makeLoggingEventBuilder(level);
    }

    @CheckReturnValue
    public LoggingEventBuilder atLevel(Level level) {
        return this.raw.atLevel(level);
    }

    public boolean isEnabledForLevel(Level level) {
        return this.raw.isEnabledForLevel(level);
    }

    public boolean isTraceEnabled() {
        return this.raw.isTraceEnabled();
    }

    public void trace(String msg) {
        this.raw.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.raw.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.raw.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.raw.trace(format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.raw.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.raw.isTraceEnabled(marker);
    }

    @CheckReturnValue
    public LoggingEventBuilder atTrace() {
        return this.raw.atTrace();
    }

    public void trace(Marker marker, String msg) {
        this.raw.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.raw.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.raw.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.raw.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.raw.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.raw.isDebugEnabled();
    }

    public void debug(String msg) {
        this.raw.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.raw.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.raw.debug(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.raw.debug(format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.raw.debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.raw.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.raw.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.raw.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.raw.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.raw.debug(marker, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.raw.debug(marker, msg, t);
    }

    @CheckReturnValue
    public LoggingEventBuilder atDebug() {
        return this.raw.atDebug();
    }

    public boolean isInfoEnabled() {
        return this.raw.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.raw.isInfoEnabled()) {
            this.ops.add(new Op(Level.INFO, msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.raw.isInfoEnabled()) {
            this.ops.add(new Op(Level.INFO, format, new Object[]{arg}));
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.raw.isInfoEnabled()) {
            this.ops.add(new Op(Level.INFO, format, new Object[]{arg1, arg2}));
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.raw.isInfoEnabled()) {
            this.ops.add(new Op(Level.INFO, format, arguments));
        }
    }

    public void info(String msg, Throwable t) {
        if (this.raw.isInfoEnabled()) {
            this.ops.add(new Op(Level.INFO, msg, t));
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.raw.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.raw.info(marker, msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.raw.info(marker, format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.raw.info(marker, format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.raw.info(marker, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.raw.info(marker, msg, t);
    }

    @CheckReturnValue
    public LoggingEventBuilder atInfo() {
        return this.raw.atInfo();
    }

    public boolean isWarnEnabled() {
        return this.raw.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.raw.isWarnEnabled()) {
            this.ops.add(new Op(Level.WARN, msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.raw.isWarnEnabled()) {
            this.ops.add(new Op(Level.WARN, format, new Object[]{arg}));
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.raw.isWarnEnabled()) {
            this.ops.add(new Op(Level.WARN, format, arguments));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.raw.isWarnEnabled()) {
            this.ops.add(new Op(Level.WARN, format, new Object[]{arg1, arg2}));
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.raw.isWarnEnabled()) {
            this.ops.add(new Op(Level.WARN, msg, t));
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.raw.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.raw.warn(marker, msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.raw.warn(marker, format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.raw.warn(marker, format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.raw.warn(marker, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.raw.warn(marker, msg, t);
    }

    @CheckReturnValue
    public LoggingEventBuilder atWarn() {
        return this.raw.atWarn();
    }

    public boolean isErrorEnabled() {
        return this.raw.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.raw.isErrorEnabled()) {
            this.ops.add(new Op(Level.ERROR, msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.raw.isErrorEnabled()) {
            this.ops.add(new Op(Level.ERROR, format, new Object[]{arg}));
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.raw.isErrorEnabled()) {
            this.ops.add(new Op(Level.ERROR, format, new Object[]{arg1, arg2}));
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.raw.isErrorEnabled()) {
            this.ops.add(new Op(Level.ERROR, format, arguments));
        }
    }

    public void error(String msg, Throwable t) {
        if (this.raw.isErrorEnabled()) {
            this.ops.add(new Op(Level.ERROR, msg, t));
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.raw.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.raw.error(marker, msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.raw.error(marker, format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.raw.error(marker, format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.raw.error(marker, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.raw.error(marker, msg, t);
    }

    @CheckReturnValue
    public LoggingEventBuilder atError() {
        return this.raw.atError();
    }

    private static class Op {
        private static final Object[] EMPTY_ARGS = new Object[0];
        final Level level;
        final String fmt;
        final Object[] arguments;
        final Throwable throwable;

        Op(Level level, String fmt) {
            this(level, fmt, EMPTY_ARGS);
        }

        Op(Level level, String fmt, Object[] arguments) {
            this.level = level;
            this.fmt = fmt;
            this.arguments = arguments;
            this.throwable = null;
        }

        Op(Level level, String fmt, Throwable throwable) {
            this.level = level;
            this.fmt = fmt;
            this.arguments = EMPTY_ARGS;
            this.throwable = throwable;
        }
    }
}

