/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.BatchUpdateException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;

class EntityInvestigator {
    private final BatchUpdateException ex;
    private final SaveContext ctx;
    private final Shape shape;
    private final Collection<? extends ImmutableSpi> entities;
    private final boolean updatable;
    private final ImmutableProp idProp;
    private final Set<ImmutableProp> keyProps;
    private final Map<ImmutableType, Fetcher<ImmutableSpi>> idFetcherMap = new HashMap<ImmutableType, Fetcher<ImmutableSpi>>();
    private Fetcher<ImmutableSpi> keyFetcher;

    EntityInvestigator(BatchUpdateException ex, SaveContext ctx, Shape shape, Collection<? extends ImmutableSpi> entities, boolean updatable) {
        this.ex = ex;
        this.ctx = ctx;
        this.shape = shape;
        this.entities = entities;
        this.updatable = updatable;
        this.idProp = ctx.path.getType().getIdProp();
        this.keyProps = ctx.options.getKeyProps(ctx.path.getType());
    }

    public Exception investigate() {
        if (this.ctx.options.getSqlClient().getDialect().isBatchUpdateExceptionUnreliable()) {
            Exception translated = this.translateAll();
            if (translated != null) {
                return translated;
            }
        } else {
            int[] rowCounts = this.ex.getUpdateCounts();
            int index = 0;
            for (ImmutableSpi immutableSpi : this.entities) {
                Exception translated;
                int rowCount;
                if ((rowCount = rowCounts[index++]) >= 0 || (translated = this.translateOne(immutableSpi)) == null) continue;
                return translated;
            }
        }
        return this.ex;
    }

    private Exception translateOne(ImmutableSpi entity) {
        List<ImmutableSpi> rows;
        PropId idPropId = this.idProp.getId();
        if (entity.__isLoaded(this.idProp.getId()) && !this.updatable && !(rows = Rows.findByIds(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null), Collections.singletonList(entity))).isEmpty()) {
            return this.ctx.createConflictId(this.idProp, entity.__get(idPropId));
        }
        if (!(this.keyProps.isEmpty() || !this.shape.getGetterMap().keySet().containsAll(this.keyProps) || this.updatable && !entity.__isLoaded(idPropId) || (rows = Rows.findByKeys(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null), Collections.singletonList(entity))).isEmpty())) {
            boolean isSameId = false;
            if (entity.__isLoaded(idPropId)) {
                isSameId = entity.__get(idPropId).equals(rows.iterator().next().__get(idPropId));
            }
            if (!isSameId) {
                return this.ctx.createConflictKey(this.keyProps, Keys.keyOf(entity, this.keyProps));
            }
        }
        for (ImmutableProp prop : entity.__type().getProps().values()) {
            Object associatedObject;
            PropId propId = prop.getId();
            if (!entity.__isLoaded(propId) || !prop.isColumnDefinition() || !prop.isTargetForeignKeyReal(this.ctx.options.getSqlClient().getMetadataStrategy()) || !prop.isReference(TargetLevel.PERSISTENT) || prop.isRemote() || this.ctx.options.isAutoCheckingProp(prop) || (associatedObject = entity.__get(propId)) == null) continue;
            Object associatedId = ((ImmutableSpi)associatedObject).__get(prop.getTargetType().getIdProp().getId());
            List<ImmutableSpi> rows2 = Rows.findRows(this.ctx.prop(prop), QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(prop.getTargetType()), (q, t) -> q.where(t.getId().eq(associatedId)));
            if (!rows2.isEmpty()) continue;
            return this.ctx.prop(prop).createIllegalTargetId(Collections.singleton(associatedId));
        }
        return null;
    }

    private Exception translateAll() {
        if (!this.updatable && !this.shape.getIdGetters().isEmpty()) {
            PropId idPropId = this.idProp.getId();
            Map<Object, ImmutableSpi> rowMap = Rows.findMapByIds(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(null), this.entities);
            for (ImmutableSpi immutableSpi : this.entities) {
                Object id = immutableSpi.__get(idPropId);
                if (rowMap.containsKey(id)) {
                    return this.ctx.createConflictId(this.idProp, id);
                }
                rowMap.put(id, immutableSpi);
            }
        }
        if (!this.keyProps.isEmpty() && this.shape.getGetterMap().keySet().containsAll(this.keyProps) && (!this.updatable || this.shape.getIdGetters().isEmpty())) {
            Map<Object, ImmutableSpi> rowMap = Rows.findMapByKeys(this.ctx, QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.keyFetcher(), this.entities);
            PropId idPropId = this.idProp.getId();
            for (ImmutableSpi immutableSpi : this.entities) {
                Object key = Keys.keyOf(immutableSpi, this.keyProps);
                ImmutableSpi row = rowMap.get(key);
                if (row != null) {
                    boolean isSameId = false;
                    if (immutableSpi.__isLoaded(idPropId)) {
                        isSameId = immutableSpi.__get(idPropId).equals(row.__get(idPropId));
                    }
                    if (!isSameId) {
                        return this.ctx.createConflictKey(this.keyProps, key);
                    }
                }
                rowMap.put(key, immutableSpi);
            }
        }
        LinkedHashMap<ImmutableProp, Set> targetIdMultiMap = new LinkedHashMap<ImmutableProp, Set>();
        for (ImmutableSpi immutableSpi : this.entities) {
            for (ImmutableProp prop : immutableSpi.__type().getProps().values()) {
                Object associatedObject;
                PropId propId = prop.getId();
                if (!immutableSpi.__isLoaded(propId) || !prop.isColumnDefinition() || !prop.isTargetForeignKeyReal(this.ctx.options.getSqlClient().getMetadataStrategy()) || !prop.isReference(TargetLevel.PERSISTENT) || prop.isRemote() || this.ctx.options.isAutoCheckingProp(prop) || (associatedObject = immutableSpi.__get(propId)) == null) continue;
                Object associatedId = ((ImmutableSpi)associatedObject).__get(prop.getTargetType().getIdProp().getId());
                targetIdMultiMap.computeIfAbsent(prop, it -> new LinkedHashSet()).add(associatedId);
            }
        }
        for (Map.Entry entry : targetIdMultiMap.entrySet()) {
            ImmutableProp immutableProp = (ImmutableProp)entry.getKey();
            Set associatedIds = (Set)entry.getValue();
            List<ImmutableSpi> rows = Rows.findRows(this.ctx.prop(immutableProp), QueryReason.INVESTIGATE_CONSTRAINT_VIOLATION_ERROR, this.idFetcher(immutableProp.getTargetType()), (q, t) -> q.where(t.getId().in(associatedIds)));
            PropId targetIdPropId = immutableProp.getTargetType().getIdProp().getId();
            HashSet<Object> existingTargetIds = new HashSet<Object>((rows.size() * 4 + 2) / 3);
            for (ImmutableSpi row : rows) {
                existingTargetIds.add(row.__get(targetIdPropId));
            }
            for (Object associatedId : associatedIds) {
                if (existingTargetIds.contains(associatedId)) continue;
                return this.ctx.prop(immutableProp).createIllegalTargetId(Collections.singleton(associatedId));
            }
        }
        return null;
    }

    private Fetcher<ImmutableSpi> idFetcher(ImmutableType type) {
        return this.idFetcherMap.computeIfAbsent(type, t -> {
            if (t == null) {
                t = this.ctx.path.getType();
            }
            return new FetcherImpl(t.getJavaClass());
        });
    }

    private Fetcher<ImmutableSpi> keyFetcher() {
        Fetcher<ImmutableSpi> keyFetcher = this.keyFetcher;
        if (keyFetcher == null) {
            keyFetcher = new FetcherImpl<ImmutableSpi>(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : this.keyProps) {
                keyFetcher = keyFetcher.add(keyProp.getName(), IdOnlyFetchType.RAW);
            }
            this.keyFetcher = keyFetcher;
        }
        return keyFetcher;
    }
}

