/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractAssociationOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.AffectedRows;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectingType;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.meta.LogicalDeletedValueGenerator;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.runtime.ExceptionTranslator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.Nullable;

public class Deleter {
    private final DeleteContext ctx;
    private Set<Object> ids;
    private Map<Object, ImmutableSpi> rowMap;

    public Deleter(ImmutableType type, DeleteOptions options, Connection con, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.ctx = new DeleteContext(options, con, trigger, affectedRowCountMap, MutationPath.root(type));
    }

    public void addIds(Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.rowMap != null && !this.rowMap.isEmpty()) {
            throw new IllegalStateException("addRows has been called");
        }
        Set<Object> set = this.ids;
        if (set == null) {
            this.ids = set = new LinkedHashSet<Object>((ids.size() * 4 + 2) / 3);
        }
        Class boxedIdType = Classes.boxTypeOf((Class)this.ctx.path.getType().getIdProp().getReturnClass());
        for (Object id : ids) {
            if (id == null) continue;
            if (!boxedIdType.isAssignableFrom(id.getClass())) {
                throw new IllegalArgumentException("Illegal id \"" + id + "\", the expected id type is \"" + boxedIdType.getName() + "\" but the actual id type is \"" + id.getClass().getName() + "\"");
            }
            set.add(id);
        }
    }

    public void addRows(Collection<ImmutableSpi> rows) {
        if (rows.isEmpty()) {
            return;
        }
        if (this.ids != null && !this.ids.isEmpty()) {
            throw new IllegalStateException("addIds has been called");
        }
        ImmutableType type = this.ctx.path.getType();
        PropId idPropId = type.getIdProp().getId();
        Map<Object, ImmutableSpi> rowMap = this.rowMap;
        if (rowMap == null) {
            this.rowMap = rowMap = new LinkedHashMap<Object, ImmutableSpi>((rows.size() * 4 + 2) / 3);
        }
        for (ImmutableSpi row : rows) {
            if (!type.isAssignableFrom(row.__type())) {
                throw new IllegalArgumentException("Illegal row \"" + row + "\", the expected id type is \"" + type + "\" but the actual id type is \"" + row.__type() + "\"");
            }
            rowMap.put(row.__get(idPropId), row);
        }
    }

    public DeleteResult execute() {
        Set<Object> ids = this.ids;
        Map<Object, ImmutableSpi> rowMap = this.rowMap;
        if (ids == null && rowMap == null) {
            return new DeleteResult(Collections.emptyMap());
        }
        this.ids = null;
        this.rowMap = null;
        if (ids == null) {
            ids = rowMap.keySet();
        }
        SaveContext saveCtx = new SaveContext(this.saveOptions(), this.ctx.con, this.ctx.path.getType(), this.ctx.trigger, this.ctx.affectedRowCountMap);
        List<MiddleTableOperator> middleOperators = AbstractAssociationOperator.createMiddleTableOperators(this.ctx.options.getSqlClient(), this.ctx.path, DisconnectingType.PHYSICAL_DELETE, prop -> new MiddleTableOperator(saveCtx.prop((ImmutableProp)prop), this.ctx.isLogicalDeleted()), backProp -> new MiddleTableOperator(saveCtx.backProp((ImmutableProp)backProp), this.ctx.isLogicalDeleted()));
        for (MiddleTableOperator middleTableOperator : middleOperators) {
            middleTableOperator.disconnect(ids);
        }
        List<ChildTableOperator> subOperators = AbstractAssociationOperator.createSubOperators(this.ctx.options.getSqlClient(), this.ctx.path, DisconnectingType.PHYSICAL_DELETE, backProp -> new ChildTableOperator(this.ctx.backPropOf((ImmutableProp)backProp)));
        for (ChildTableOperator subOperator : subOperators) {
            subOperator.disconnect(ids);
        }
        int n = this.executeImpl(ids, rowMap);
        if (this.ctx.trigger != null) {
            this.ctx.trigger.submit(this.ctx.options.getSqlClient(), this.ctx.con);
        }
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), n);
        return new DeleteResult(this.ctx.affectedRowCountMap);
    }

    private int executeImpl(Collection<Object> ids, Map<Object, ImmutableSpi> rowMap) {
        return Deleter.delete(this.ctx.options.getSqlClient(), this.ctx.con, this.ctx.path.getType(), ids, rowMap, this.ctx.trigger, this.ctx.isLogicalDeleted());
    }

    private static int delete(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, Collection<Object> ids, Map<Object, ImmutableSpi> rowMap, MutationTrigger trigger, boolean logicalDeleted) {
        LogicalDeletedInfo info = logicalDeleted ? type.getLogicalDeletedInfo() : null;
        LogicalDeletedValueGenerator generator = LogicalDeletedValueGenerators.of((LogicalDeletedInfo)info, (SqlContext)sqlClient);
        if (trigger != null) {
            return Deleter.deleteWithTrigger(sqlClient, con, type, ids, rowMap, trigger, info, generator != null ? generator.generate() : null);
        }
        return Deleter.deleteWithoutTrigger(sqlClient, con, type, ids != null ? ids : rowMap.keySet(), info, generator != null ? generator.generate() : null);
    }

    private static int deleteWithTrigger(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, Collection<Object> ids, Map<Object, ImmutableSpi> rowMap, MutationTrigger trigger, LogicalDeletedInfo info, Object generatedValue) {
        if (rowMap == null) {
            MutableRootQueryImpl q = new MutableRootQueryImpl(sqlClient, type, (ExecutionPurpose)ExecutionPurpose.command(QueryReason.TRIGGER), info != null ? FilterLevel.IGNORE_USER_FILTERS : FilterLevel.IGNORE_ALL);
            Object t = q.getTable();
            q.where(new Predicate[]{t.get(type.getIdProp().getName()).in(ids)});
            List rows = (List)q.select(t).execute(con);
            rowMap = new LinkedHashMap<Object, ImmutableSpi>((rows.size() * 4 + 2) / 3);
            PropId idPropId = type.getIdProp().getId();
            for (ImmutableSpi row : rows) {
                rowMap.put(row.__get(idPropId), row);
            }
        }
        if (rowMap.isEmpty()) {
            return 0;
        }
        for (ImmutableSpi row : rowMap.values()) {
            if (info != null) {
                Deleter.fireEvent(row, info.getProp(), generatedValue, trigger);
                continue;
            }
            Deleter.fireEvent(row, null, null, trigger);
        }
        return Deleter.deleteWithoutTrigger(sqlClient, con, type, rowMap.keySet(), info, generatedValue);
    }

    private static int deleteWithoutTrigger(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, Collection<Object> ids, LogicalDeletedInfo info, Object generatedDeletedValue) {
        SqlBuilder builder = new SqlBuilder(new AstContext(sqlClient));
        if (info != null) {
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.sql("update ")).sql(type.getTableName(sqlClient.getMetadataStrategy()))).sql(" set ")).sql(((SingleColumn)info.getProp().getStorage(sqlClient.getMetadataStrategy())).getName())).sql(" = ");
            if (generatedDeletedValue != null) {
                builder.variable(generatedDeletedValue);
            } else {
                builder.sql("null");
            }
        } else {
            ((SqlBuilder)builder.sql("delete from ")).sql(type.getTableName(sqlClient.getMetadataStrategy()));
        }
        builder.sql(" where ");
        ComparisonPredicates.renderIn(false, ValueGetter.valueGetters(sqlClient, type.getIdProp()), ids, builder);
        Tuple3<String, List<Object>, List<Integer>> tuple = builder.build();
        Executor.Args<Integer> args = new Executor.Args<Integer>(sqlClient, con, tuple.get_1(), tuple.get_2(), tuple.get_3(), ExecutionPurpose.command(QueryReason.NONE), null, PreparedStatement::executeUpdate);
        return sqlClient.getExecutor().execute(args);
    }

    static void fireEvent(ImmutableSpi row, ImmutableProp prop, Object value, MutationTrigger trigger) {
        if (prop != null) {
            ImmutableSpi newRow = (ImmutableSpi)Internal.produce((ImmutableType)row.__type(), (Object)row, draft -> ((DraftSpi)draft).__set(prop.getId(), value));
            trigger.modifyEntityTable(row, newRow);
        } else {
            trigger.modifyEntityTable(row, null);
        }
    }

    private SaveOptions saveOptions() {
        final DeleteOptions options = this.ctx.options;
        return new SaveOptions(){

            @Override
            public JSqlClientImplementor getSqlClient() {
                return options.getSqlClient();
            }

            @Override
            public Connection getConnection() {
                return options.getConnection();
            }

            @Override
            public SaveMode getMode() {
                return SaveMode.UPSERT;
            }

            @Override
            public AssociatedSaveMode getAssociatedMode(ImmutableProp prop) {
                return AssociatedSaveMode.REPLACE;
            }

            @Override
            public Triggers getTriggers() {
                return options.getTriggers();
            }

            @Override
            public Set<ImmutableProp> getKeyProps(ImmutableType type) {
                return Collections.emptySet();
            }

            @Override
            public boolean isTargetTransferable(ImmutableProp prop) {
                return false;
            }

            @Override
            public DeleteMode getDeleteMode() {
                return options.getMode();
            }

            @Override
            public DissociateAction getDissociateAction(ImmutableProp prop) {
                return options.getDissociateAction(prop);
            }

            @Override
            public LockMode getLockMode() {
                return LockMode.AUTO;
            }

            @Override
            public UserOptimisticLock<?, ?> getUserOptimisticLock(ImmutableType type) {
                return null;
            }

            @Override
            public boolean isAutoCheckingProp(ImmutableProp prop) {
                return false;
            }

            @Override
            @Nullable
            public ExceptionTranslator<Exception> getExceptionTranslator() {
                return null;
            }
        };
    }
}

