/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collection;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntitySet;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;

interface Batch<E> {
    public Shape shape();

    public Collection<E> entities();

    default public SaveMode mode() {
        return SaveMode.UPSERT;
    }

    public static <E> Batch<E> of(final Shape shape, final EntitySet<E> entities) {
        return new Batch<E>(){

            @Override
            public Shape shape() {
                return shape;
            }

            @Override
            public EntitySet<E> entities() {
                return entities;
            }
        };
    }

    public static <E> Batch<E> of(final Batch<E> base, final SaveMode mode) {
        if (base.mode() == mode) {
            return base;
        }
        return new Batch<E>(){

            @Override
            public Shape shape() {
                return base.shape();
            }

            @Override
            public Collection<E> entities() {
                return base.entities();
            }

            @Override
            public SaveMode mode() {
                return mode;
            }

            public String toString() {
                return base.toString();
            }
        };
    }
}

