/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectingType;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.SqlFunction;

abstract class AbstractAssociationOperator {
    final JSqlClientImplementor sqlClient;
    final Connection con;

    AbstractAssociationOperator(JSqlClientImplementor sqlClient, Connection con) {
        this.sqlClient = sqlClient;
        this.con = con;
    }

    final <R> R execute(SqlBuilder builder, SqlFunction<PreparedStatement, R> statementExecutor) {
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<R>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, statementExecutor));
    }

    final int execute(SqlBuilder builder) {
        return this.execute(builder, PreparedStatement::executeUpdate);
    }

    final int execute(BatchSqlBuilder builder, Collection<?> rows, BiFunction<SQLException, Executor.BatchContext, Exception> exceptionTranslator) {
        int[] rowCounts = this.executeImpl(builder, rows, exceptionTranslator);
        return this.sumRowCount(rowCounts);
    }

    final int sumRowCount(int[] rowCounts) {
        int sumRowCount = 0;
        if (this.isBatchStatementSimple()) {
            for (int rowCount : rowCounts) {
                if (rowCount == 0) continue;
                ++sumRowCount;
            }
        } else {
            for (int rowCount : rowCounts) {
                sumRowCount += rowCount;
            }
        }
        return sumRowCount;
    }

    int[] executeImpl(BatchSqlBuilder builder, Collection<?> rows, BiFunction<SQLException, Executor.BatchContext, Exception> exceptionTranslator) {
        Tuple2<String, BatchSqlBuilder.VariableMapper> sqlTuple = builder.build();
        try (Executor.BatchContext batchContext = this.sqlClient.getExecutor().executeBatch(this.con, sqlTuple.get_1(), null, ExecutionPurpose.command(QueryReason.NONE), this.sqlClient);){
            BatchSqlBuilder.VariableMapper mapper = sqlTuple.get_2();
            for (Object row : rows) {
                batchContext.add(mapper.variables(row));
            }
            Object object = batchContext.execute(exceptionTranslator);
            return object;
        }
    }

    boolean isBatchStatementSimple() {
        return false;
    }

    static List<ChildTableOperator> createSubOperators(JSqlClientImplementor sqlClient, MutationPath path, DisconnectingType disconnectingType, Function<ImmutableProp, ChildTableOperator> backPropCreator) {
        ArrayList<ChildTableOperator> subOperators = null;
        if (path.getParent() == null || disconnectingType.isDelete()) {
            for (ImmutableProp backProp : sqlClient.getEntityManager().getAllBackProps(path.getType())) {
                if (!backProp.isColumnDefinition() || disconnectingType == DisconnectingType.NONE) continue;
                if (subOperators == null) {
                    subOperators = new ArrayList<ChildTableOperator>();
                }
                ChildTableOperator subOperator = backPropCreator.apply(backProp);
                if (subOperator.disconnectingType == DisconnectingType.NONE) continue;
                subOperators.add(subOperator);
            }
        }
        if (subOperators == null) {
            return Collections.emptyList();
        }
        return subOperators;
    }

    static List<MiddleTableOperator> createMiddleTableOperators(JSqlClientImplementor sqlClient, MutationPath path, DisconnectingType disconnectingType, Function<ImmutableProp, MiddleTableOperator> propCreator, Function<ImmutableProp, MiddleTableOperator> backPropCreator) {
        MiddleTableOperator middleTableOperator;
        ArrayList<MiddleTableOperator> middleTableOperators = null;
        for (ImmutableProp prop : path.getType().getProps().values()) {
            if (!prop.isMiddleTableDefinition()) continue;
            if (middleTableOperators == null) {
                middleTableOperators = new ArrayList<MiddleTableOperator>();
            }
            middleTableOperator = propCreator.apply(prop);
            if (middleTableOperator.middleTable.isReadonly()) continue;
            middleTableOperators.add(middleTableOperator);
        }
        if (path.getParent() == null || disconnectingType.isDelete()) {
            for (ImmutableProp backProp : sqlClient.getEntityManager().getAllBackProps(path.getType())) {
                if (!backProp.isMiddleTableDefinition()) continue;
                if (middleTableOperators == null) {
                    middleTableOperators = new ArrayList();
                }
                middleTableOperator = backPropCreator.apply(backProp);
                if (middleTableOperator.middleTable.isReadonly()) continue;
                middleTableOperators.add(middleTableOperator);
            }
        }
        if (middleTableOperators == null) {
            return Collections.emptyList();
        }
        return middleTableOperators;
    }
}

