/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.jetbrains.annotations.NotNull;

public class SimpleCaseBuilder<C, T> {
    private Class<T> type;
    private Expression<?> expression;
    private List<Tuple2<Expression<?>, Expression<T>>> whens = new ArrayList();

    SimpleCaseBuilder(Class<T> type, Expression<?> expression) {
        this.type = type;
        this.expression = expression;
    }

    public SimpleCaseBuilder<C, T> when(C cond, T then) {
        return this.when(Literals.any(cond), Literals.any(then));
    }

    public SimpleCaseBuilder<C, T> when(Expression<C> cond, T then) {
        return this.when(cond, Literals.any(then));
    }

    public SimpleCaseBuilder<C, T> when(C cond, Expression<T> then) {
        return this.when(Literals.any(cond), then);
    }

    public SimpleCaseBuilder<C, T> when(Expression<C> cond, Expression<T> then) {
        this.whens.add(new Tuple2<Expression<C>, Expression<T>>(cond, then));
        return this;
    }

    public Expression<T> otherwise(T otherwise) {
        return this.otherwise(Literals.any(otherwise));
    }

    public Expression<T> otherwise(Expression<T> otherwise) {
        ArrayList whens = new ArrayList(this.whens);
        if (String.class.isAssignableFrom(this.type)) {
            return new StrExpr(this.expression, whens, otherwise);
        }
        if (this.type.isPrimitive() || Number.class.isAssignableFrom(this.type)) {
            return new NumExpr<String>((Class<String>)this.type, this.expression, whens, otherwise);
        }
        if (Comparable.class.isAssignableFrom(this.type)) {
            return new CmpExpr<String>(this.type, this.expression, whens, otherwise);
        }
        return new AnyExpr<String>(this.type, this.expression, whens, otherwise);
    }

    private static class StrExpr
    extends AnyExpr<String>
    implements StringExpressionImplementor {
        StrExpr(Expression<?> expression, List<Tuple2<Expression<?>, Expression<String>>> whens, Expression<String> otherwise) {
            super(String.class, expression, whens, otherwise);
        }
    }

    private static class NumExpr<N extends Number>
    extends AnyExpr<N>
    implements NumericExpressionImplementor<N> {
        NumExpr(Class<N> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<N>>> whens, Expression<N> otherwise) {
            super(type, expression, whens, otherwise);
        }
    }

    private static class CmpExpr<T extends Comparable<?>>
    extends AnyExpr<T>
    implements ComparableExpressionImplementor<T> {
        CmpExpr(Class<T> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<T>>> whens, Expression<T> otherwise) {
            super(type, expression, whens, otherwise);
        }
    }

    private static class AnyExpr<T>
    extends AbstractExpression<T> {
        private final Class<T> type;
        private Expression<?> expression;
        private List<Tuple2<Expression<?>, Expression<T>>> whens;
        private Expression<T> otherwise;

        AnyExpr(Class<T> type, Expression<?> expression, List<Tuple2<Expression<?>, Expression<T>>> whens, Expression<T> otherwise) {
            this.type = type;
            this.expression = expression;
            this.whens = whens;
            this.otherwise = otherwise;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public int precedence() {
            return 0;
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
            ((Ast)((Object)this.expression)).accept(visitor);
            for (Tuple2<Expression<?>, Expression<T>> when : this.whens) {
                ((Ast)((Object)when.get_1())).accept(visitor);
                ((Ast)((Object)when.get_2())).accept(visitor);
            }
            ((Ast)((Object)this.otherwise)).accept(visitor);
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            this.usingLowestPrecedence(() -> {
                builder.sql("case ");
                this.renderChild((Ast)((Object)this.expression), builder);
                for (Tuple2<Expression<?>, Expression<T>> when : this.whens) {
                    builder.sql(" when ");
                    this.renderChild((Ast)((Object)when.get_1()), builder);
                    builder.sql(" then ");
                    this.renderChild((Ast)((Object)when.get_2()), builder);
                }
                builder.sql(" else ");
                this.renderChild((Ast)((Object)this.otherwise), builder);
                builder.sql(" end");
            });
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return AnyExpr.hasVirtualPredicate(this.expression) || this.whens.stream().anyMatch(it -> AnyExpr.hasVirtualPredicate(it.get_1()) || AnyExpr.hasVirtualPredicate(it.get_2())) || AnyExpr.hasVirtualPredicate(this.otherwise);
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            this.expression = ctx.resolveVirtualPredicate(this.expression);
            this.whens = this.whens.stream().map(it -> new Tuple2<Expression, Expression>(ctx.resolveVirtualPredicate((Expression)it.get_1()), ctx.resolveVirtualPredicate((Expression)it.get_2()))).collect(Collectors.toList());
            this.otherwise = ctx.resolveVirtualPredicate(this.otherwise);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnyExpr anyExpr = (AnyExpr)o;
            return this.type.equals(anyExpr.type) && this.expression.equals(anyExpr.expression) && this.whens.equals(anyExpr.whens) && this.otherwise.equals(anyExpr.otherwise);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.expression, this.whens, this.otherwise);
        }
    }

    public static class Cmp<C, T extends Comparable<?>>
    extends SimpleCaseBuilder<C, T> {
        Cmp(Class<T> type, Expression<?> expression) {
            super(type, expression);
        }

        @Override
        public Cmp<C, T> when(C cond, T then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(Expression<C> cond, T then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(C cond, Expression<T> then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public Cmp<C, T> when(Expression<C> cond, Expression<T> then) {
            return (Cmp)super.when(cond, then);
        }

        @Override
        public ComparableExpression<T> otherwise(T otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }

        @Override
        public ComparableExpression<T> otherwise(Expression<T> otherwise) {
            return (ComparableExpression)super.otherwise(otherwise);
        }
    }

    public static class Num<C, N extends Number>
    extends SimpleCaseBuilder<C, N> {
        Num(Class<N> type, Expression<?> expression) {
            super(type, expression);
        }

        @Override
        public Num<C, N> when(C cond, N then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(Expression<C> cond, N then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(C cond, Expression<N> then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public Num<C, N> when(Expression<C> cond, Expression<N> then) {
            return (Num)super.when(cond, then);
        }

        @Override
        public NumericExpression<N> otherwise(N otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }

        @Override
        public NumericExpression<N> otherwise(Expression<N> otherwise) {
            return (NumericExpression)super.otherwise(otherwise);
        }
    }

    public static class Str<C>
    extends SimpleCaseBuilder<C, String> {
        Str(Expression<?> expression) {
            super(String.class, expression);
        }

        public Str<C> when(C cond, String then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(Expression<C> cond, String then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(C cond, Expression<String> then) {
            return (Str)super.when(cond, then);
        }

        public Str<C> when(Expression<C> cond, Expression<String> then) {
            return (Str)super.when(cond, then);
        }

        public StringExpression otherwise(String otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }

        public StringExpression otherwise(Expression<String> otherwise) {
            return (StringExpression)super.otherwise(otherwise);
        }
    }
}

