/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.OptimisticLockNewValueExpression;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;

public class OptimisticLockValueFactoryFactories<E>
implements UserOptimisticLock.ValueExpressionFactory<E> {
    private static final OptimisticLockValueFactoryFactories<Object> FACTORY = new OptimisticLockValueFactoryFactories();

    public static <E> UserOptimisticLock.ValueExpressionFactory<E> of() {
        return FACTORY;
    }

    @Override
    public <V> Expression<V> newValue(TypedProp.Scalar<E, V> prop) {
        Class returnType = prop.unwrap().getReturnClass();
        if (returnType == String.class) {
            return new OptimisticLockNewValueExpression.Str((TypedProp.Scalar<?, String>)prop);
        }
        if (Number.class.isAssignableFrom(returnType)) {
            return new OptimisticLockNewValueExpression.Num<V>(prop);
        }
        if (Comparable.class.isAssignableFrom(returnType)) {
            return new OptimisticLockNewValueExpression.Cmp<V>(prop);
        }
        return new OptimisticLockNewValueExpression<V>(prop);
    }

    @Override
    public StringExpression newString(TypedProp.Scalar<E, String> prop) {
        return new OptimisticLockNewValueExpression.Str(prop);
    }

    @Override
    public <N extends Number> NumericExpression<N> newNumber(TypedProp.Scalar<E, N> prop) {
        return new OptimisticLockNewValueExpression.Num<N>(prop);
    }

    @Override
    public <C extends Comparable<?>> ComparableExpression<C> newComparable(TypedProp.Scalar<E, C> prop) {
        return new OptimisticLockNewValueExpression.Cmp<C>(prop);
    }
}

