/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CompositePredicate;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.jetbrains.annotations.Nullable;

public class ExampleImpl<E>
implements Example<E> {
    private static final Predicate[] EMPTY_PREDICATES = new Predicate[0];
    private final ImmutableSpi spi;
    private final Example.MatchMode matchMode;
    private final LikeMode likeMode;
    private final boolean trim;
    private final Map<ImmutableProp, PropData> propDataMap;

    public ExampleImpl(E obj) {
        if (!(obj instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("example must be immutable instance");
        }
        this.spi = (ImmutableSpi)obj;
        this.matchMode = Example.MatchMode.NOT_EMPTY;
        this.likeMode = LikeMode.EXACT;
        this.trim = false;
        this.propDataMap = new HashMap<ImmutableProp, PropData>();
    }

    private ExampleImpl(ExampleImpl<E> base, PropData data) {
        HashMap<ImmutableProp, PropData> newPropDataMap = new HashMap<ImmutableProp, PropData>(base.propDataMap);
        newPropDataMap.put(data.prop, data);
        this.spi = base.spi;
        this.matchMode = base.matchMode;
        this.likeMode = base.likeMode;
        this.trim = base.trim;
        this.propDataMap = newPropDataMap;
    }

    private ExampleImpl(ExampleImpl<E> base, Example.MatchMode matchMode) {
        this.spi = base.spi;
        this.matchMode = matchMode;
        this.likeMode = base.likeMode;
        this.trim = base.trim;
        this.propDataMap = base.propDataMap;
    }

    private ExampleImpl(ExampleImpl<E> base, boolean trim) {
        this.spi = base.spi;
        this.matchMode = base.matchMode;
        this.likeMode = base.likeMode;
        this.trim = trim;
        this.propDataMap = base.propDataMap;
    }

    @Override
    public Example<E> match(Example.MatchMode mode) {
        if (this.matchMode == mode) {
            return this;
        }
        return new ExampleImpl<E>(this, mode);
    }

    @Override
    public Example<E> match(TypedProp<E, ?> prop, Example.MatchMode matchMode) {
        PropData data = this.propDataMap.get(prop.unwrap());
        if (data != null && data.matchMode == matchMode) {
            return this;
        }
        data = new PropData(prop.unwrap(), matchMode, data != null && data.trim, data != null && data.ignoreZero, data != null && data.likeInsensitive, data != null ? data.likeMode : LikeMode.EXACT);
        return new ExampleImpl<E>(this, data);
    }

    @Override
    public Example<E> trim() {
        if (this.trim) {
            return this;
        }
        return new ExampleImpl<E>(this, true);
    }

    @Override
    public Example<E> trim(TypedProp.Scalar<E, String> prop) {
        PropData data = this.propDataMap.get(prop.unwrap());
        if (data != null && data.trim) {
            return this;
        }
        data = new PropData(prop.unwrap(), data != null ? data.matchMode : null, true, data != null && data.ignoreZero, data != null && data.likeInsensitive, data != null ? data.likeMode : LikeMode.EXACT);
        return new ExampleImpl<E>(this, data);
    }

    @Override
    public Example<E> ignoreZero(TypedProp.Scalar<E, ? extends Number> prop) {
        PropData data = this.propDataMap.get(prop.unwrap());
        if (data != null && data.ignoreZero) {
            return this;
        }
        data = new PropData(prop.unwrap(), data != null ? data.matchMode : null, data != null && data.trim, true, data != null && data.likeInsensitive, data != null ? data.likeMode : LikeMode.EXACT);
        return new ExampleImpl<E>(this, data);
    }

    @Override
    public ExampleImpl<E> like(TypedProp.Scalar<E, String> prop, LikeMode likeMode) {
        PropData data = this.propDataMap.get(prop.unwrap());
        if (data != null && !data.likeInsensitive && data.likeMode == likeMode) {
            return this;
        }
        data = new PropData(prop.unwrap(), data != null ? data.matchMode : null, data != null && data.trim, data != null && data.ignoreZero, false, likeMode);
        return new ExampleImpl<E>(this, data);
    }

    @Override
    public ExampleImpl<E> ilike(TypedProp.Scalar<E, String> prop, LikeMode likeMode) {
        PropData data = this.propDataMap.get(prop.unwrap());
        if (data != null && data.likeInsensitive && data.likeMode == likeMode) {
            return this;
        }
        data = new PropData(prop.unwrap(), data != null ? data.matchMode : null, data != null && data.trim, data != null && data.ignoreZero, true, likeMode);
        return new ExampleImpl<E>(this, data);
    }

    ImmutableType type() {
        return this.spi.__type();
    }

    public Predicate toPredicate(Table<?> table) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (ImmutableProp prop : this.spi.__type().getProps().values()) {
            if (!this.spi.__isLoaded(prop.getId()) || !prop.isColumnDefinition()) continue;
            Object value = this.spi.__get(prop.getId());
            if (value != null && prop.isReference(TargetLevel.PERSISTENT)) {
                PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
                if (!((ImmutableSpi)value).__isLoaded(targetIdPropId)) continue;
                value = ((ImmutableSpi)value).__get(targetIdPropId);
            }
            Expression<Object> expr = ExampleImpl.expressionOf(table, prop, value == null ? JoinType.LEFT : JoinType.INNER);
            Predicate predicate = null;
            Example.MatchMode matchMode = this.getMatchMode(prop);
            if (value == null) {
                if (matchMode == Example.MatchMode.NULLABLE) {
                    predicate = expr.isNull();
                }
            } else if (value instanceof String) {
                String str = (String)value;
                if (this.isTrim(prop)) {
                    str = str.trim();
                }
                if (str.isEmpty() && matchMode == Example.MatchMode.NOT_EMPTY) continue;
                LikeMode likeMode = this.getLikeMode(prop);
                predicate = this.isInsensitive(prop) ? ((StringExpression)expr).ilike(str, likeMode) : (likeMode != LikeMode.EXACT ? ((StringExpression)expr).like(str, likeMode) : expr.eq(str));
            } else if (value instanceof Number) {
                if (this.isZeroIgnored(prop) && ((Number)value).intValue() == 0) continue;
                predicate = expr.eq(value);
            } else {
                predicate = expr.eq(value);
            }
            predicates.add(predicate);
        }
        return CompositePredicate.and(predicates.toArray(EMPTY_PREDICATES));
    }

    void applyTo(MutableRootQueryImpl<?> query) {
        query.where(new Predicate[]{this.toPredicate((Table<?>)query.getTable())});
    }

    private static Expression<Object> expressionOf(Table<?> table, ImmutableProp prop, JoinType joinType) {
        if (prop.isReference(TargetLevel.PERSISTENT)) {
            Table joinedExpr = table.join(prop.getName(), joinType);
            return joinedExpr.get(prop.getTargetType().getIdProp().getName());
        }
        return table.get(prop.getName());
    }

    private Example.MatchMode getMatchMode(ImmutableProp prop) {
        PropData data = this.propDataMap.get(prop);
        return data != null && data.matchMode != null ? data.matchMode : this.matchMode;
    }

    private boolean isTrim(ImmutableProp prop) {
        PropData data = this.propDataMap.get(prop);
        return data != null && data.trim || this.trim;
    }

    private boolean isZeroIgnored(ImmutableProp prop) {
        PropData data = this.propDataMap.get(prop);
        return data != null && data.ignoreZero;
    }

    private boolean isInsensitive(ImmutableProp prop) {
        PropData data = this.propDataMap.get(prop);
        return data != null && data.likeInsensitive;
    }

    private LikeMode getLikeMode(ImmutableProp prop) {
        PropData data = this.propDataMap.get(prop);
        return data != null ? data.likeMode : LikeMode.EXACT;
    }

    private static class PropData {
        final ImmutableProp prop;
        @Nullable
        final Example.MatchMode matchMode;
        final boolean trim;
        final boolean ignoreZero;
        final boolean likeInsensitive;
        final LikeMode likeMode;

        PropData(ImmutableProp prop, @Nullable Example.MatchMode matchMode, boolean trim, boolean ignoreZero, boolean likeInsensitive, LikeMode likeMode) {
            this.prop = prop;
            this.matchMode = matchMode;
            this.trim = trim;
            this.ignoreZero = ignoreZero;
            this.likeInsensitive = likeInsensitive;
            this.likeMode = likeMode;
        }
    }
}

