/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractPredicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicate;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class CompositePredicate
extends AbstractPredicate {
    private static final Predicate[] EMPTY_PREDICATE_ARR = new Predicate[0];
    private final Predicate[] predicates;

    CompositePredicate(Predicate[] predicates) {
        this.predicates = predicates;
    }

    public static Predicate and(Predicate ... predicates) {
        return CompositePredicate.composite(predicates, And::new);
    }

    public static Predicate or(Predicate ... predicates) {
        return CompositePredicate.composite(predicates, Or::new);
    }

    private static Predicate composite(Predicate[] predicates, BiFunction<Boolean, Predicate[], Predicate> creator) {
        boolean hasVirtualPredicate = false;
        Predicate[] arr = predicates;
        for (Predicate p : predicates) {
            if (p == null) {
                ArrayList<Predicate> list = new ArrayList<Predicate>(predicates.length - 1);
                for (Predicate p2 : predicates) {
                    if (p2 == null) continue;
                    if (((Ast)((Object)p2)).hasVirtualPredicate()) {
                        hasVirtualPredicate = true;
                    }
                    list.add(p2);
                }
                arr = list.toArray(EMPTY_PREDICATE_ARR);
                break;
            }
            if (!((Ast)((Object)p)).hasVirtualPredicate()) continue;
            hasVirtualPredicate = true;
        }
        if (arr.length == 0) {
            return null;
        }
        if (arr.length == 1) {
            return arr[0];
        }
        return creator.apply(hasVirtualPredicate, arr);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        for (Predicate predicate : this.predicates) {
            ((Ast)((Object)predicate)).accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        builder.enter(this.scopeType());
        for (Predicate predicate : this.predicates) {
            builder.separator();
            this.renderChild((Ast)((Object)predicate), builder);
        }
        builder.leave();
    }

    @Override
    protected boolean determineHasVirtualPredicate() {
        return CompositePredicate.hasVirtualPredicate(this.predicates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Ast onResolveVirtualPredicate(AstContext ctx, VirtualPredicate.Op op, BiFunction<Boolean, Predicate[], Ast> creator) {
        ctx.pushVirtualPredicateContext(op);
        try {
            Ast ast = creator.apply(false, ctx.resolveVirtualPredicates(this.predicates));
            return ast;
        }
        finally {
            ctx.popVirtualPredicateContext();
        }
    }

    protected abstract AbstractSqlBuilder.ScopeType scopeType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositePredicate that = (CompositePredicate)o;
        return Arrays.equals(this.predicates, that.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }

    static class Or
    extends CompositePredicate {
        Or(boolean hasVirtualPredicate, Predicate[] predicates) {
            super(predicates);
        }

        @Override
        protected AbstractSqlBuilder.ScopeType scopeType() {
            return AbstractSqlBuilder.ScopeType.OR;
        }

        @Override
        public int precedence() {
            return 7;
        }

        @Override
        public Ast onResolveVirtualPredicate(AstContext ctx) {
            return this.onResolveVirtualPredicate(ctx, VirtualPredicate.Op.OR, Or::new);
        }
    }

    static class And
    extends CompositePredicate {
        And(boolean hasVirtualPredicate, Predicate[] predicates) {
            super(predicates);
        }

        @Override
        protected AbstractSqlBuilder.ScopeType scopeType() {
            return AbstractSqlBuilder.ScopeType.AND;
        }

        @Override
        public int precedence() {
            return 6;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            return this.onResolveVirtualPredicate(ctx, VirtualPredicate.Op.AND, And::new);
        }
    }
}

