/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.View;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Entities {
    public Entities forUpdate();

    public Entities forConnection(Connection var1);

    @Nullable
    public <E> E findById(Class<E> var1, Object var2);

    @NotNull
    public <E> List<E> findByIds(Class<E> var1, Collection<?> var2);

    @NotNull
    public <ID, E> Map<ID, E> findMapByIds(Class<E> var1, Collection<ID> var2);

    @Nullable
    public <E> E findById(Fetcher<E> var1, Object var2);

    @NotNull
    public <E> List<E> findByIds(Fetcher<E> var1, Collection<?> var2);

    @NotNull
    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> var1, Collection<ID> var2);

    public <E> List<E> findAll(Class<E> var1);

    public <E> List<E> findAll(Class<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findAll(Fetcher<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findByExample(Example<E> var1, TypedProp.Scalar<?, ?> ... var2);

    public <E> List<E> findByExample(Example<E> var1, Fetcher<E> var2, TypedProp.Scalar<?, ?> ... var3);

    public <E, V extends View<E>> List<V> findExample(Class<V> var1, Example<E> var2, TypedProp.Scalar<?, ?> ... var3);

    default public <E> SimpleSaveResult<E> save(E entity) {
        return (SimpleSaveResult)this.saveCommand(entity).execute();
    }

    public <E> SimpleEntitySaveCommand<E> saveCommand(E var1);

    default public <E> BatchSaveResult<E> saveEntities(Collection<E> entities) {
        return (BatchSaveResult)this.saveEntitiesCommand(entities).execute();
    }

    default public <E> BatchSaveResult<E> batchSave(Collection<E> entities) {
        return this.saveEntities(entities);
    }

    default public <E> BatchSaveResult<E> saveAll(Collection<E> entities) {
        return this.saveEntities(entities);
    }

    default public <E> SimpleSaveResult<E> save(Input<E> input) {
        return this.save(input.toEntity());
    }

    default public <E> SimpleEntitySaveCommand<E> saveCommand(Input<E> input) {
        return this.saveCommand(input.toEntity());
    }

    public <E> BatchEntitySaveCommand<E> saveEntitiesCommand(Collection<E> var1);

    @Deprecated
    default public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> entities) {
        return this.saveEntitiesCommand(entities);
    }

    @Deprecated
    default public <E> BatchEntitySaveCommand<E> saveAllCommand(Collection<E> entities) {
        return this.saveEntitiesCommand(entities);
    }

    default public DeleteResult delete(Class<?> type, Object id) {
        return (DeleteResult)this.deleteCommand(type, id).execute();
    }

    default public DeleteResult delete(Class<?> type, Object id, DeleteMode mode) {
        return (DeleteResult)this.deleteCommand(type, id).setMode(mode).execute();
    }

    public DeleteCommand deleteCommand(Class<?> var1, Object var2);

    default public DeleteCommand deleteCommand(Class<?> type, Object id, DeleteMode mode) {
        return this.deleteCommand(type, id).setMode(mode);
    }

    default public DeleteResult deleteAll(Class<?> type, Collection<?> ids) {
        return (DeleteResult)this.deleteAllCommand(type, ids).execute();
    }

    default public DeleteResult deleteAll(Class<?> type, Collection<?> ids, DeleteMode mode) {
        return (DeleteResult)this.deleteAllCommand(type, ids).setMode(mode).execute();
    }

    @Deprecated
    default public DeleteResult batchDelete(Class<?> type, Collection<?> ids) {
        return (DeleteResult)this.batchDeleteCommand(type, ids).execute();
    }

    @Deprecated
    default public DeleteResult batchDelete(Class<?> type, Collection<?> ids, DeleteMode mode) {
        return (DeleteResult)this.batchDeleteCommand(type, ids).setMode(mode).execute();
    }

    public DeleteCommand deleteAllCommand(Class<?> var1, Collection<?> var2);

    @Deprecated
    default public DeleteCommand batchDeleteCommand(Class<?> type, Collection<?> ids) {
        return this.deleteAllCommand(type, ids);
    }
}

