/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.collection.TypedList;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ParameterIndex;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExecutor
implements Executor {
    public static final DefaultExecutor INSTANCE = new DefaultExecutor();

    DefaultExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R execute(@NotNull Executor.Args<R> args) {
        String sql = args.sql;
        List<Object> variables = args.variables;
        JSqlClientImplementor sqlClient = args.sqlClient;
        try (PreparedStatement stmt = args.statementFactory != null ? args.statementFactory.preparedStatement(args.con, sql) : args.con.prepareStatement(sql);){
            DefaultExecutor.setParameters(stmt, variables, sqlClient);
            Object r = args.block.apply(stmt);
            return r;
        }
        catch (Exception ex) {
            throw new ExecutionException("Cannot execute SQL statement: " + sql + ", variables: " + variables, ex);
        }
    }

    @Override
    public Executor.BatchContext executeBatch(@NotNull Connection con, @NotNull String sql, @Nullable ImmutableProp generatedIdProp, @NotNull ExecutionPurpose purpose, @NotNull JSqlClientImplementor sqlClient) {
        return new BatchContextImpl(con, sql, generatedIdProp, purpose, ExecutorContext.create(sqlClient), sqlClient);
    }

    private static void setParameters(PreparedStatement stmt, List<Object> variables, JSqlClientImplementor sqlClient) throws Exception {
        ParameterIndex parameterIndex = new ParameterIndex();
        for (Object variable : variables) {
            if (variable instanceof DbLiteral) {
                DbLiteral literal = (DbLiteral)variable;
                literal.setParameter(stmt, parameterIndex, sqlClient);
                continue;
            }
            if (variable instanceof TypedList) {
                TypedList typedList = (TypedList)variable;
                stmt.setArray(parameterIndex.get(), stmt.getConnection().createArrayOf(typedList.getSqlElementType(), typedList.toArray()));
                continue;
            }
            stmt.setObject(parameterIndex.get(), variable);
        }
    }

    private static class BatchContextImpl
    implements Executor.BatchContext {
        private static final Object[] EMPTY_GENERATED_IDS = new Object[0];
        private final String sql;
        private final PreparedStatement statement;
        @Nullable
        private final ImmutableProp generatedIdProp;
        private final ExecutionPurpose purpose;
        private final ExecutorContext executorContext;
        private final JSqlClientImplementor sqlClient;
        private int batchCount;

        BatchContextImpl(Connection con, String sql, @Nullable ImmutableProp generatedIdProp, ExecutionPurpose purpose, ExecutorContext executorContext, JSqlClientImplementor sqlClient) {
            PreparedStatement statement;
            this.purpose = purpose;
            this.executorContext = executorContext;
            try {
                IdGenerator idGenerator;
                statement = generatedIdProp != null ? ((idGenerator = sqlClient.getIdGenerator(generatedIdProp.getDeclaringType().getJavaClass())) instanceof SequenceIdGenerator ? con.prepareStatement(sql, new int[]{1}) : con.prepareStatement(sql, 1)) : con.prepareStatement(sql);
            }
            catch (SQLException ex) {
                throw new ExecutionException("Cannot create the batch SQL statement: " + sql, ex);
            }
            this.sql = sql;
            this.statement = statement;
            this.generatedIdProp = generatedIdProp;
            this.sqlClient = sqlClient;
        }

        @Override
        public JSqlClientImplementor sqlClient() {
            return this.sqlClient;
        }

        @Override
        public String sql() {
            return this.sql;
        }

        @Override
        public ExecutionPurpose purpose() {
            return this.purpose;
        }

        @Override
        public ExecutorContext executorContext() {
            return this.executorContext;
        }

        @Override
        public void add(List<Object> variables) {
            try {
                DefaultExecutor.setParameters(this.statement, variables, this.sqlClient);
                this.statement.addBatch();
                ++this.batchCount;
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot add batch into the batch SQL statement: " + this.sql + ", variables: " + variables, ex);
            }
        }

        @Override
        public int[] execute() {
            try {
                return this.statement.executeBatch();
            }
            catch (SQLException ex) {
                throw new ExecutionException("Cannot execute the batch SQL statement: " + this.sql, ex);
            }
        }

        @Override
        public Object[] generatedIds() {
            if (this.generatedIdProp == null) {
                return EMPTY_GENERATED_IDS;
            }
            Object[] ids = new Object[this.batchCount];
            int index = 0;
            ScalarProvider provider = this.sqlClient.getScalarProvider(this.generatedIdProp);
            Class sqlType = provider != null ? provider.getSqlType() : Classes.boxTypeOf((Class)this.generatedIdProp.getReturnClass());
            try (ResultSet rs = this.statement.getGeneratedKeys();){
                while (rs.next()) {
                    Object id = rs.getObject(1, sqlType);
                    if (id != null && provider != null) {
                        id = provider.toSql(id);
                    }
                    ids[index++] = id;
                }
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot get generated ids for batch SQL statement: " + this.sql, ex);
            }
            return ids;
        }

        @Override
        public void close() {
            try {
                this.statement.close();
            }
            catch (SQLException ex) {
                throw new ExecutionException("Cannot execute the batch SQL statement: " + this.sql, ex);
            }
        }
    }
}

