/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetchPath;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherTask;
import org.babyfish.jimmer.sql.fetcher.impl.FetchingCache;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

class FetcherContext {
    private static final ThreadLocal<FetcherContext> FETCHER_CONTEXT_LOCAL = new ThreadLocal();
    private JSqlClientImplementor sqlClient;
    private Connection con;
    private FetchingCache cache = new FetchingCache();
    private Map<FetchedField, FetcherTask> taskMap = new LinkedHashMap<FetchedField, FetcherTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void using(JSqlClientImplementor sqlClient, Connection con, BiConsumer<FetcherContext, Boolean> block) {
        FetcherContext ctx = FETCHER_CONTEXT_LOCAL.get();
        if (ctx != null) {
            block.accept(ctx, false);
        } else {
            ctx = new FetcherContext(sqlClient, con);
            FETCHER_CONTEXT_LOCAL.set(ctx);
            try {
                block.accept(ctx, true);
            }
            finally {
                FETCHER_CONTEXT_LOCAL.remove();
            }
        }
    }

    private FetcherContext(JSqlClientImplementor sqlClient, Connection con) {
        this.sqlClient = sqlClient;
        this.con = con;
    }

    private void add(FetchPath path, Fetcher<?> fetcher, DraftSpi draft) {
        FetcherImplementor fetcherImplementor = (FetcherImplementor)fetcher;
        FetcherContext.setVisibility(draft, (FetcherImplementor)fetcher);
        for (Field field : fetcherImplementor.__unresolvedFieldMap().values()) {
            if (field.isSimpleField() && (field.isRawId() || this.sqlClient.getFilters().getFilter(field.getProp().getTargetType()) == null)) continue;
            RecursionStrategy<?> recursionStrategy = field.getRecursionStrategy();
            if (recursionStrategy != null && !recursionStrategy.isRecursive(new RecursionStrategy.Args<DraftSpi>(draft, 0))) {
                return;
            }
            FetcherTask task = this.taskMap.computeIfAbsent(new FetchedField(path, field), it -> new FetcherTask(this.cache, this.sqlClient, this.con, path, field));
            task.add(draft);
        }
    }

    public void addAll(FetchPath path, Fetcher<?> fetcher, Collection<@Nullable DraftSpi> drafts) {
        for (DraftSpi draft : drafts) {
            if (draft == null) continue;
            this.add(path, fetcher, draft);
        }
    }

    public void execute() {
        while (!this.taskMap.isEmpty()) {
            Iterator<Map.Entry<FetchedField, FetcherTask>> itr = this.taskMap.entrySet().iterator();
            Map.Entry<FetchedField, FetcherTask> e = itr.next();
            if (!e.getValue().execute()) continue;
            this.taskMap.remove(e.getKey());
        }
    }

    static void setVisibility(DraftSpi draft, FetcherImplementor<?> fetcher) {
        for (PropId shownPropId : fetcher.__shownPropIds()) {
            draft.__show(shownPropId, true);
        }
        for (PropId hiddenPropId : fetcher.__hiddenPropIds()) {
            draft.__show(hiddenPropId, false);
        }
        for (Field field : fetcher.getFieldMap().values()) {
            DraftSpi childDraft;
            PropId propId;
            FetcherImplementor childFetcher = (FetcherImplementor)field.getChildFetcher();
            ImmutableProp prop = field.getProp();
            if (childFetcher == null || !prop.isEmbedded(EmbeddedLevel.SCALAR) || !draft.__isLoaded(propId = prop.getId()) || (childDraft = (DraftSpi)draft.__get(propId)) == null) continue;
            FetcherContext.setVisibility(childDraft, childFetcher);
        }
    }

    private static class FetchedField {
        final FetchPath path;
        final Field field;

        private FetchedField(FetchPath path, Field field) {
            this.path = path;
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FetchedField that = (FetchedField)o;
            if (!Objects.equals(this.path, that.path)) {
                return false;
            }
            return this.field.equals(that.field);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + this.field.hashCode();
            return result;
        }

        public String toString() {
            return "Key{path='" + this.path + '\'' + ", field=" + this.field + '}';
        }
    }
}

