/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;

public class SqlServerDialect
extends DefaultDialect {
    @Override
    public boolean isTupleSupported() {
        return false;
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float";
        }
        if (elementType == Double.TYPE) {
            return "real";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "time";
        }
        if (elementType == OffsetTime.class) {
            return "datetime";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "datetime";
        }
        if (elementType == LocalDateTime.class) {
            return "datetime";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "datetime";
        }
        return null;
    }

    @Override
    public void paginate(PaginationContext ctx) {
        ctx.origin().sql(" offset ").variable(ctx.getOffset()).sql(" rows fetch next ").variable(ctx.getLimit()).sql(" rows only");
    }
}

