/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;

public class MySqlDialect
extends DefaultDialect {
    @Override
    public void paginate(PaginationContext ctx) {
        ctx.origin().space().sql("limit ").variable(ctx.getOffset()).sql(", ").variable(ctx.getLimit());
    }

    @Override
    public UpdateJoin getUpdateJoin() {
        return new UpdateJoin(true, UpdateJoin.From.UNNECESSARY);
    }

    @Override
    public boolean isDeletedAliasRequired() {
        return true;
    }

    @Override
    public String sqlType(Class<?> elementType) {
        if (elementType == String.class) {
            return "varchar";
        }
        if (elementType == UUID.class) {
            return "char(36)";
        }
        if (elementType == Boolean.TYPE) {
            return "boolean";
        }
        if (elementType == Byte.TYPE) {
            return "tinyint";
        }
        if (elementType == Short.TYPE) {
            return "smallint";
        }
        if (elementType == Integer.TYPE) {
            return "int";
        }
        if (elementType == Long.TYPE) {
            return "bigint";
        }
        if (elementType == Float.TYPE) {
            return "float";
        }
        if (elementType == Double.TYPE) {
            return "double";
        }
        if (elementType == BigDecimal.class) {
            return "decimal";
        }
        if (elementType == Date.class || elementType == LocalDate.class) {
            return "date";
        }
        if (elementType == Time.class || elementType == LocalTime.class) {
            return "datetime";
        }
        if (elementType == OffsetTime.class) {
            return "datetime";
        }
        if (elementType == java.util.Date.class || elementType == Timestamp.class) {
            return "timestamp";
        }
        if (elementType == LocalDateTime.class) {
            return "timestamp";
        }
        if (elementType == OffsetDateTime.class || elementType == ZonedDateTime.class) {
            return "timestamp";
        }
        return null;
    }

    @Override
    public boolean isUpsertWithMultipleUniqueConstraintSupported() {
        return false;
    }

    @Override
    public boolean isIdFetchableByKeyUpdate() {
        return true;
    }

    @Override
    public boolean isUpsertSupported() {
        return true;
    }

    @Override
    public void update(Dialect.UpdateContext ctx) {
        if (!ctx.isUpdatedByKey()) {
            super.update(ctx);
            return;
        }
        ctx.sql("update ").appendTableName().enter(AbstractSqlBuilder.ScopeType.SET).separator().appendId().sql(" = last_insert_id(").appendId().sql(")").appendAssignments().leave().enter(AbstractSqlBuilder.ScopeType.WHERE).appendPredicates().leave();
    }

    @Override
    public void upsert(Dialect.UpsertContext ctx) {
        if (!ctx.hasUpdatedColumns() && !ctx.hasGeneratedId()) {
            ctx.sql("insert ignore into ").appendTableName().enter(AbstractSqlBuilder.ScopeType.LIST).appendInsertedColumns().leave().enter(AbstractSqlBuilder.ScopeType.VALUES).enter(AbstractSqlBuilder.ScopeType.LIST).appendInsertingValues().leave().leave();
        } else {
            ctx.sql("insert into ").appendTableName().sql("(").appendInsertedColumns().sql(")").enter(AbstractSqlBuilder.ScopeType.VALUES).enter(AbstractSqlBuilder.ScopeType.LIST).appendInsertingValues().leave().leave().sql(" on duplicate key update ").enter(AbstractSqlBuilder.ScopeType.COMMA);
            if (ctx.hasGeneratedId()) {
                ctx.separator().sql("/* fake update to return all ids */").sql(" ").appendGeneratedId().sql(" = ").sql("last_insert_id(").appendGeneratedId().sql(")");
            }
            if (ctx.hasUpdatedColumns()) {
                ctx.separator().appendUpdatingAssignments("values(", ")");
            }
            ctx.leave();
        }
    }

    @Override
    public String transCacheOperatorTableDDL() {
        return "create table JIMMER_TRANS_CACHE_OPERATOR(\n\tID bigint unsigned not null auto_increment primary key,\n\tIMMUTABLE_TYPE varchar(128),\n\tIMMUTABLE_PROP varchar(128),\n\tCACHE_KEY varchar(64) not null,\n\tREASON varchar(32)\n) engine=innodb";
    }
}

