/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redis.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.redis.spring.RedisCaches;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractRemoteValueBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.SessionCallback;

public class RedisValueBinder<K, V>
extends AbstractRemoteValueBinder<K, V> {
    private final RedisOperations<String, byte[]> operations;

    protected RedisValueBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker, @Nullable ObjectMapper objectMapper, @NotNull Duration duration, int randomPercent, @NotNull RedisOperations<String, byte[]> operations) {
        super(type, prop, tracker, objectMapper, duration, randomPercent);
        this.operations = operations;
    }

    @Override
    protected List<byte[]> read(Collection<String> keys) {
        return this.operations.opsForValue().multiGet(keys);
    }

    @Override
    protected void write(final Map<String, byte[]> map) {
        this.operations.executePipelined((SessionCallback)new SessionCallback<Void>(){

            public <XK, XV> Void execute(RedisOperations<XK, XV> pops) throws DataAccessException {
                RedisOperations<XK, XV> pipelinedOps = pops;
                pipelinedOps.opsForValue().multiSet(map);
                for (String key : map.keySet()) {
                    pipelinedOps.expire((Object)key, RedisValueBinder.this.nextExpireMillis(), TimeUnit.MILLISECONDS);
                }
                return null;
            }
        });
    }

    @Override
    protected void deleteAllSerializedKeys(List<String> serializedKeys) {
        this.operations.delete(serializedKeys);
    }

    @Override
    protected boolean matched(@Nullable Object reason) {
        return "redis".equals(reason);
    }

    @NotNull
    public static <K, V> Builder<K, V> forObject(ImmutableType type) {
        return new Builder(type, null);
    }

    @NotNull
    public static <K, V> Builder<K, V> forProp(ImmutableProp prop) {
        return new Builder(null, prop);
    }

    public static class Builder<K, V>
    extends AbstractRemoteBinder.AbstractBuilder<K, V, Builder<K, V>> {
        private RedisOperations<String, byte[]> operations;

        protected Builder(ImmutableType type, ImmutableProp prop) {
            super(type, prop);
        }

        public Builder<K, V> redis(RedisOperations<String, byte[]> operations) {
            this.operations = operations;
            return this;
        }

        public Builder<K, V> redis(RedisConnectionFactory connectionFactory) {
            this.operations = RedisCaches.cacheRedisTemplate(connectionFactory);
            return this;
        }

        public RedisValueBinder<K, V> build() {
            if (this.operations == null) {
                throw new IllegalStateException("Redis operations or redis connection factory has not been specified");
            }
            return new RedisValueBinder(this.type, this.prop, this.tracker, this.objectMapper, this.duration, this.randomPercent, this.operations);
        }
    }
}

