/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redis.quarkus;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.quarkus.redis.datasource.RedisDataSource;
import java.util.Objects;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheCreator;
import org.babyfish.jimmer.sql.cache.caffeine.CaffeineHashBinder;
import org.babyfish.jimmer.sql.cache.caffeine.CaffeineValueBinder;
import org.babyfish.jimmer.sql.cache.chain.ChainCacheBuilder;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.babyfish.jimmer.sql.cache.redis.quarkus.RedisHashBinder;
import org.babyfish.jimmer.sql.cache.redis.quarkus.RedisValueBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractCacheCreator;

public class RedisCacheCreator
extends AbstractCacheCreator {
    public RedisCacheCreator(RedisDataSource redisDataSource) {
        this(redisDataSource, null);
    }

    public RedisCacheCreator(RedisDataSource redisDataSource, ObjectMapper objectMapper) {
        super(new Root(redisDataSource, objectMapper));
    }

    protected RedisCacheCreator(AbstractCacheCreator.Cfg cfg) {
        super(cfg);
    }

    @Override
    public <K, V> Cache<K, V> createForObject(ImmutableType type) {
        return new ChainCacheBuilder<K, V>().add(this.caffeineValueBinder(type)).add(this.redisValueBinder(type)).build();
    }

    @Override
    public <K, V> Cache<K, V> createForProp(ImmutableProp prop, boolean multiView) {
        if (multiView) {
            return new ChainCacheBuilder<K, V>().add(this.caffeineHashBinder(prop)).add(this.redisHashBinder(prop)).build();
        }
        return new ChainCacheBuilder<K, V>().add(this.caffeineValueBinder(prop)).add(this.redisValueBinder(prop)).build();
    }

    @Override
    protected Args newArgs(AbstractCacheCreator.Cfg cfg) {
        return new Args(cfg);
    }

    @Override
    protected CacheCreator newCacheCreator(AbstractCacheCreator.Cfg cfg) {
        return new RedisCacheCreator(cfg);
    }

    private <K, V> LoadingBinder<K, V> caffeineValueBinder(ImmutableType type) {
        Args args = (Args)this.args();
        if (!args.useLocalCache) {
            return null;
        }
        return CaffeineValueBinder.forObject(type).subscribe(args.tracker).maximumSize(args.localCacheMaximumSize).duration(args.localCacheDuration).build();
    }

    private <K, V> LoadingBinder<K, V> caffeineValueBinder(ImmutableProp prop) {
        Args args = (Args)this.args();
        if (!args.useLocalCache) {
            return null;
        }
        return CaffeineValueBinder.forProp(prop).subscribe(args.tracker).maximumSize(args.localCacheMaximumSize).duration(args.localCacheDuration).build();
    }

    private <K, V> SimpleBinder<K, V> caffeineHashBinder(ImmutableProp prop) {
        Args args = (Args)this.args();
        if (!args.useMultiViewLocalCache) {
            return null;
        }
        return CaffeineHashBinder.forProp(prop).subscribe(args.tracker).maximumSize(args.multiViewLocalCacheMaximumSize).duration(args.multiViewLocalCacheDuration).build();
    }

    private <K, V> SimpleBinder<K, V> redisValueBinder(ImmutableType type) {
        Args args = (Args)this.args();
        return ((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)RedisValueBinder.forObject(type).publish(args.tracker)).duration(args.duration)).objectMapper(args.objectMapper)).duration(args.duration)).randomPercent(args.randomDurationPercent)).redis(args.redisDataSource).build().lock(args.locker, args.lockWaitDuration, args.lockLeaseDuration);
    }

    private <K, V> SimpleBinder<K, V> redisValueBinder(ImmutableProp prop) {
        Args args = (Args)this.args();
        return ((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)((RedisValueBinder.Builder)RedisValueBinder.forProp(prop).publish(args.tracker)).duration(args.duration)).objectMapper(args.objectMapper)).duration(args.duration)).randomPercent(args.randomDurationPercent)).redis(args.redisDataSource).build().lock(args.locker, args.lockWaitDuration, args.lockLeaseDuration);
    }

    private <K, V> SimpleBinder.Parameterized<K, V> redisHashBinder(ImmutableProp prop) {
        Args args = (Args)this.args();
        return ((RedisHashBinder.Builder)((RedisHashBinder.Builder)((RedisHashBinder.Builder)((RedisHashBinder.Builder)((RedisHashBinder.Builder)RedisHashBinder.forProp(prop).publish(args.tracker)).duration(args.duration)).objectMapper(args.objectMapper)).duration(args.multiVewDuration)).randomPercent(args.randomDurationPercent)).redis(args.redisDataSource).build().lock(args.locker, args.lockWaitDuration, args.lockLeaseDuration);
    }

    private static class Root
    extends AbstractCacheCreator.Cfg {
        final RedisDataSource redisDataSource;
        final ObjectMapper objectMapper;

        private Root(RedisDataSource redisDataSource, ObjectMapper objectMapper) {
            super(null);
            this.redisDataSource = Objects.requireNonNull(redisDataSource, "redisDataSource cannot be null");
            this.objectMapper = objectMapper;
        }
    }

    static class Args
    extends AbstractCacheCreator.Args {
        final RedisDataSource redisDataSource;
        final ObjectMapper objectMapper;

        Args(AbstractCacheCreator.Cfg cfg) {
            super(cfg);
            Root root = cfg.as(Root.class);
            this.redisDataSource = root.redisDataSource;
            ObjectMapper mapper = root.objectMapper;
            ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper();
            clonedMapper.registerModule((Module)new JavaTimeModule());
            clonedMapper.registerModule((Module)new ImmutableModule());
            this.objectMapper = clonedMapper;
        }
    }
}

