/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.babyfish.jimmer.sql.cache.spi.AbstractTrackingConsumerBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaffeineHashBinder<K, V>
extends AbstractTrackingConsumerBinder<K>
implements SimpleBinder.Parameterized<K, V> {
    private final Cache<K, Map<SortedMap<String, Object>, V>> cache;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();

    public CaffeineHashBinder(@Nullable ImmutableType type, @Nullable ImmutableProp prop, @Nullable CacheTracker tracker, int maximumSize, @NotNull Duration duration) {
        super(type, prop, tracker);
        this.cache = Caffeine.newBuilder().maximumSize((long)maximumSize).expireAfterWrite(duration).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> getAll(Collection<K> keys, SortedMap<String, Object> parameterMap) {
        Lock lock = this.rwl.readLock();
        lock.lock();
        try {
            LinkedHashMap resutMap = new LinkedHashMap((keys.size() * 4 + 2) / 3);
            Map subMapMap = this.cache.getAllPresent(keys);
            for (Map.Entry e : subMapMap.entrySet()) {
                Object value;
                Map subMap = (Map)e.getValue();
                if (subMap == null || (value = subMap.get(parameterMap)) == null && subMap.containsKey(parameterMap)) continue;
                resutMap.put(e.getKey(), value);
            }
            LinkedHashMap linkedHashMap = resutMap;
            return linkedHashMap;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAll(Map<K, V> map, SortedMap<String, Object> parameterMap) {
        Lock lock = this.rwl.writeLock();
        lock.lock();
        try {
            Map subMapMap = this.cache.getAllPresent(map.keySet());
            HashMap newSubMapMap = new HashMap((map.size() * 4 + 2) / 3);
            for (Map.Entry<K, V> e : map.entrySet()) {
                HashMap<SortedMap<String, Object>, V> subMap = (HashMap<SortedMap<String, Object>, V>)subMapMap.get(e.getKey());
                subMap = subMap == null ? new HashMap<SortedMap<String, Object>, V>() : new HashMap(subMap);
                subMap.put(parameterMap, e.getValue());
                newSubMapMap.put(e.getKey(), subMap);
            }
            this.cache.putAll(newSubMapMap);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void deleteAllImpl(@NotNull Collection<K> keys) {
        Lock lock = this.rwl.writeLock();
        lock.lock();
        try {
            this.cache.invalidateAll(keys);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    protected boolean matched(@Nullable Object reason) {
        return "caffeine".equals(reason);
    }

    @NotNull
    public static <K, V> Builder<K, V> forProp(ImmutableProp prop) {
        return new Builder(null, prop);
    }

    public static class Builder<K, V> {
        private final ImmutableType type;
        private final ImmutableProp prop;
        private CacheTracker tracker;
        private int maximumSize = 100;
        private Duration duration = Duration.ofMinutes(1L);

        public Builder(ImmutableType type, ImmutableProp prop) {
            this.type = type;
            this.prop = prop;
        }

        public Builder<K, V> subscribe(CacheTracker tracker) {
            this.tracker = tracker;
            return this;
        }

        public Builder<K, V> maximumSize(int maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder<K, V> duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public CaffeineHashBinder<K, V> build() {
            return new CaffeineHashBinder(this.type, this.prop, this.tracker, this.maximumSize, this.duration);
        }
    }
}

