/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.babyfish.jimmer.Draft;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.ParameterizedUsedCacheImpl;
import org.babyfish.jimmer.sql.cache.UsedCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UsedCacheImpl<K, V>
implements UsedCache<K, V> {
    private static final ThreadLocal<Set<UsedCache<?, ?>>> LOADING_CACHES_LOCAL = new ThreadLocal();
    protected final Cache<K, V> raw;
    private final CacheOperator operator;

    UsedCacheImpl(Cache<K, V> raw, CacheOperator operator) {
        this.raw = Objects.requireNonNull(raw, "raw cannot be null");
        this.operator = operator;
    }

    static <K, V> UsedCache<K, V> wrap(Cache<K, V> cache, CacheOperator operator) {
        if (cache == null) {
            return null;
        }
        if (cache instanceof UsedCache) {
            UsedCacheImpl wrapper = (UsedCacheImpl)cache;
            if (wrapper.operator == operator) {
                return wrapper;
            }
            cache = wrapper.raw;
        }
        if (cache instanceof Cache.Parameterized) {
            return new ParameterizedUsedCacheImpl((Cache.Parameterized)cache, operator);
        }
        return new UsedCacheImpl<K, V>(cache, operator);
    }

    public static <K, V> UsedCache<K, V> export(UsedCache<K, V> cache) {
        Set<UsedCache<?, ?>> disabledCaches;
        if (cache != null && (disabledCaches = LOADING_CACHES_LOCAL.get()) != null && disabledCaches.contains(cache)) {
            return null;
        }
        return cache;
    }

    public static <K, V> Cache<K, V> unwrap(Cache<K, V> cache) {
        if (cache instanceof UsedCache) {
            UsedCacheImpl wrapper = (UsedCacheImpl)cache;
            return wrapper.raw;
        }
        return cache;
    }

    @Override
    @NotNull
    public ImmutableType type() {
        return this.raw.type();
    }

    @Override
    @Nullable
    public ImmutableProp prop() {
        return this.raw.prop();
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull CacheEnvironment<K, V> env) {
        return this.loading(() -> {
            Map<K, V> valueMap = this.raw.getAll(keys, env);
            for (V value : valueMap.values()) {
                this.validateResult(value);
            }
            return valueMap;
        });
    }

    @Override
    public void delete(@NotNull K key) {
        if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.delete(key);
        } else {
            this.operator.delete(this, key, null);
        }
    }

    @Override
    public void delete(@NotNull K key, Object reason) {
        if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.delete(key, reason);
        } else {
            this.operator.delete(this, key, reason);
        }
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys) {
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            this.delete(keys.iterator().next());
        } else if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.deleteAll(keys);
        } else {
            this.operator.deleteAll(this, keys, null);
        }
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys, @Nullable Object reason) {
        if (keys.isEmpty()) {
            return;
        }
        if (keys.size() == 1) {
            this.delete(keys.iterator().next(), reason);
        } else if (this.operator == null || CacheOperator.isSuspending()) {
            this.raw.deleteAll(keys, reason);
        } else {
            this.operator.deleteAll(this, keys, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R loading(Supplier<R> block) {
        Set<UsedCache<?, ?>> disabledCaches = LOADING_CACHES_LOCAL.get();
        if (disabledCaches == null) {
            disabledCaches = new HashSet();
            LOADING_CACHES_LOCAL.set(disabledCaches);
        }
        disabledCaches.add(this);
        try {
            R r = block.get();
            return r;
        }
        finally {
            disabledCaches.remove(this);
            if (disabledCaches.isEmpty()) {
                LOADING_CACHES_LOCAL.remove();
            }
        }
    }

    protected void validateResult(Object result) {
        ImmutableType type = this.raw.type();
        ImmutableProp prop = this.raw.prop();
        if (result == null) {
            if (prop != null && !prop.isReferenceList(TargetLevel.OBJECT) && !prop.isNullable()) {
                throw new IllegalArgumentException("Property cache for \"" + prop + "\" must return non-null value");
            }
        } else if (prop == null) {
            if (!(result instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("Object cache for \"" + type + "\" must return object");
            }
            if (result instanceof Draft) {
                throw new IllegalArgumentException("Object cache for \"" + type + "\" cannot return draft");
            }
        } else if (prop.isReferenceList(TargetLevel.OBJECT)) {
            if (!(result instanceof List)) {
                throw new IllegalArgumentException("Association id list cache for \"" + prop + "\" must return list");
            }
            List rows = (List)result;
            for (Object row : rows) {
                if (!(row instanceof ImmutableSpi) && !(row instanceof List)) continue;
                throw new IllegalArgumentException("Association id list cache for \"" + prop + "\" returns a list but some elements are not simple id values");
            }
        } else if (result instanceof ImmutableSpi || result instanceof List) {
            throw new IllegalArgumentException("Property cache for \"" + prop + "\" must return simple value");
        }
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsedCacheImpl that = (UsedCacheImpl)o;
        return this.raw.equals(that.raw);
    }

    public String toString() {
        return "CacheWrapper{raw=" + this.raw + '}';
    }
}

