/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.value;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.AbstractPropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.GetterMetadata;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.jetbrains.annotations.Nullable;

class ReferencePropertyGetter
extends AbstractPropertyGetter
implements GetterMetadata {
    private final ImmutableProp targetIdProp;

    ReferencePropertyGetter(@Nullable String alias, ImmutableProp prop, ValueGetter valueGetter) {
        super(alias, prop, valueGetter);
        this.targetIdProp = prop.getTargetType().getIdProp();
    }

    @Override
    public Object get(Object value) {
        ImmutableSpi spi = (ImmutableSpi)value;
        ImmutableSpi reference = (ImmutableSpi)spi.__get(this.prop.getId());
        if (reference == null) {
            return null;
        }
        return this.valueGetter.get(reference.__get(this.targetIdProp.getId()));
    }

    @Override
    public GetterMetadata metadata() {
        return this;
    }

    @Override
    String toStringPrefix() {
        return this.prop.getName() + '.' + this.targetIdProp.getName();
    }

    @Override
    public ImmutableProp getValueProp() {
        return this.targetIdProp;
    }

    @Override
    public Class<?> getSqlType() {
        return this.targetIdProp.getReturnClass();
    }

    @Override
    @Nullable
    public String getColumnName() {
        return this.valueGetter.metadata().getColumnName();
    }

    @Override
    public boolean isNullable() {
        return this.valueGetter.metadata().isNullable();
    }

    @Override
    public boolean isJson() {
        return false;
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public String getSqlTypeName() {
        return this.valueGetter.metadata().getSqlTypeName();
    }

    @Override
    public void renderTo(AbstractSqlBuilder<?> builder) {
        this.valueGetter.metadata().renderTo(builder);
    }

    static List<PropertyGetter> getters(@Nullable String alias, ImmutableProp prop, List<ValueGetter> valueGetters) {
        ArrayList<PropertyGetter> propertyGetters = new ArrayList<PropertyGetter>(valueGetters.size());
        for (ValueGetter valueGetter : valueGetters) {
            propertyGetters.add(new ReferencePropertyGetter(alias, prop, valueGetter));
        }
        return propertyGetters;
    }
}

