/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractPreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;

class UpsertPreHandler
extends AbstractPreHandler {
    private ShapedEntityMap<DraftSpi> insertedMap;
    private ShapedEntityMap<DraftSpi> updatedMap;
    private ShapedEntityMap<DraftSpi> mergedMap;

    UpsertPreHandler(SaveContext ctx) {
        super(ctx);
    }

    @Override
    public ShapedEntityMap<DraftSpi> insertedMap() {
        this.resolve();
        return this.insertedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> updatedMap() {
        this.resolve();
        return this.updatedMap;
    }

    @Override
    public ShapedEntityMap<DraftSpi> mergedMap() {
        this.resolve();
        return this.mergedMap;
    }

    @Override
    void onResolve() {
        DraftSpi draft;
        Iterator itr;
        QueryReason queryReason;
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        ArrayList<Object> insertedList = null;
        ArrayList<DraftSpi> updatedList = null;
        ArrayList<DraftSpi> updatedWithoutKeyList = null;
        if (!this.draftsWithId.isEmpty() && (queryReason = this.queryReason(true, this.draftsWithId)) != QueryReason.NONE) {
            insertedList = new ArrayList<DraftSpi>();
            updatedList = new ArrayList<DraftSpi>();
            Map<Object, ImmutableSpi> idMap = this.findOldMapByIds(queryReason);
            itr = this.draftsWithId.iterator();
            while (itr.hasNext()) {
                draft = (DraftSpi)itr.next();
                ImmutableSpi original = idMap.get(draft.__get(idPropId));
                if (original != null) {
                    updatedList.add(draft);
                } else {
                    insertedList.add(draft);
                    itr.remove();
                }
                this.callInterceptor(draft, original);
            }
        }
        if (!this.draftsWithKey.isEmpty() && (queryReason = this.queryReason(false, this.draftsWithKey)) != QueryReason.NONE) {
            if (insertedList == null) {
                insertedList = new ArrayList();
            }
            updatedWithoutKeyList = new ArrayList<DraftSpi>();
            Map<Object, ImmutableSpi> keyMap = this.findOldMapByKeys(queryReason);
            itr = this.draftsWithKey.iterator();
            while (itr.hasNext()) {
                draft = (DraftSpi)itr.next();
                Object key = Keys.keyOf((ImmutableSpi)draft, this.keyProps);
                ImmutableSpi original = keyMap.get(key);
                if (original != null) {
                    updatedWithoutKeyList.add(draft);
                    draft.__set(idPropId, original.__get(idPropId));
                } else {
                    insertedList.add(draft);
                    itr.remove();
                }
                this.callInterceptor(draft, original);
            }
        }
        if (insertedList == null) {
            this.insertedMap = ShapedEntityMap.empty();
            this.updatedMap = ShapedEntityMap.empty();
            this.mergedMap = this.createEntityMap(null, this.draftsWithId, this.draftsWithKey, SaveMode.UPSERT);
        } else {
            this.insertedMap = this.createEntityMap(null, insertedList, null, SaveMode.INSERT_ONLY);
            this.updatedMap = this.createEntityMap(null, updatedList, null, SaveMode.UPDATE_ONLY);
            if (updatedWithoutKeyList != null && !updatedWithoutKeyList.isEmpty()) {
                ShapedEntityMap<DraftSpi> updatedMap = this.updatedMap;
                for (DraftSpi draft2 : updatedWithoutKeyList) {
                    updatedMap.add(draft2, true);
                }
            }
            this.mergedMap = ShapedEntityMap.empty();
        }
    }
}

