/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;

class TupleIdPairsImpl
implements IdPairs {
    private final Collection<Tuple2<Object, Object>> tuples;
    private Collection<Tuple2<Object, Collection<Object>>> entries;

    TupleIdPairsImpl(Collection<Tuple2<Object, Object>> tuples) {
        this.tuples = Collections.unmodifiableCollection(tuples);
    }

    @Override
    public Collection<Tuple2<Object, Object>> tuples() {
        return this.tuples;
    }

    @Override
    public Collection<Tuple2<Object, Collection<Object>>> entries() {
        Collection<Tuple2<Object, Collection<Object>>> entries = this.entries;
        if (entries == null) {
            LinkedHashMap<Object, List> multiMap = new LinkedHashMap<Object, List>();
            for (Tuple2<Object, Object> tuple2 : this.tuples) {
                multiMap.computeIfAbsent(tuple2.get_1(), it -> new ArrayList()).add(tuple2.get_2());
            }
            entries = new ArrayList<Tuple2<Object, Collection<Object>>>(multiMap.size());
            for (Map.Entry entry : multiMap.entrySet()) {
                entries.add(new Tuple2(entry.getKey(), Collections.unmodifiableList((List)entry.getValue())));
            }
            this.entries = entries = Collections.unmodifiableCollection(entries);
        }
        return entries;
    }

    @Override
    public boolean isEmpty() {
        return this.tuples.isEmpty();
    }

    public String toString() {
        return "TupleIdPairs" + this.tuples();
    }
}

