/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.Tuples;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.query.MutableQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SaveException;

class Rows {
    private Rows() {
    }

    static Map<Object, ImmutableSpi> findMapByIds(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows) {
        PropId idPropId = ctx.path.getType().getIdProp().getId();
        LinkedHashSet<Object> ids = new LinkedHashSet<Object>((rows.size() * 4 + 2) / 3);
        for (ImmutableSpi immutableSpi : rows) {
            ids.add(immutableSpi.__get(idPropId));
        }
        if (ids.isEmpty()) {
            return new HashMap<Object, ImmutableSpi>();
        }
        List<ImmutableSpi> entities = Rows.findRows(ctx, queryReason, fetcher, (q, t) -> q.where(t.getId().in(ids)));
        if (entities.isEmpty()) {
            return new HashMap<Object, ImmutableSpi>();
        }
        LinkedHashMap<Object, ImmutableSpi> linkedHashMap = new LinkedHashMap<Object, ImmutableSpi>((entities.size() * 4 + 2) / 3);
        for (ImmutableSpi entity : entities) {
            linkedHashMap.put(entity.__get(idPropId), entity);
        }
        return linkedHashMap;
    }

    static Map<Object, ImmutableSpi> findMapByKeys(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, Collection<? extends ImmutableSpi> rows) {
        Set<ImmutableProp> keyProps = ctx.options.getKeyProps(ctx.path.getType());
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>((rows.size() * 4 + 2) / 3);
        for (ImmutableSpi immutableSpi : rows) {
            keys.add(Keys.keyOf(immutableSpi, keyProps));
        }
        if (keys.isEmpty()) {
            return new HashMap<Object, ImmutableSpi>();
        }
        List<ImmutableSpi> entities = Rows.findRows(ctx, queryReason, fetcher, (q, t) -> {
            Expression<Object> keyExpr;
            if (keyProps.size() == 1) {
                ImmutableProp prop = (ImmutableProp)keyProps.iterator().next();
                keyExpr = prop.isReference(TargetLevel.PERSISTENT) ? t.getAssociatedId(prop) : t.get(prop);
            } else {
                Expression[] arr = new Expression[keyProps.size()];
                int index = 0;
                for (ImmutableProp keyProp : keyProps) {
                    PropExpression expr = keyProp.isReference(TargetLevel.PERSISTENT) ? t.getAssociatedId(keyProp) : t.get(keyProp);
                    arr[index++] = expr;
                }
                keyExpr = Tuples.expressionOf(arr);
            }
            q.where(keyExpr.nullableIn(keys));
        });
        if (entities.isEmpty()) {
            return new HashMap<Object, ImmutableSpi>();
        }
        LinkedHashMap<Object, ImmutableSpi> linkedHashMap = new LinkedHashMap<Object, ImmutableSpi>((entities.size() * 4 + 2) / 3);
        for (ImmutableSpi entity : entities) {
            ImmutableSpi conflictEntity = linkedHashMap.put(Keys.keyOf(entity, keyProps), entity);
            if (conflictEntity == null) continue;
            throw new SaveException.KeyNotUnique(ctx.path, "Key properties " + keyProps + " cannot guarantee uniqueness under that path, do you forget to add unique constraint for that key?");
        }
        return linkedHashMap;
    }

    private static List<ImmutableSpi> findRows(SaveContext ctx, QueryReason queryReason, Fetcher<ImmutableSpi> fetcher, BiConsumer<MutableQuery, Table<?>> block) {
        ImmutableType type = ctx.path.getType();
        SaveOptions options = ctx.options;
        return (List)Internal.requiresNewDraftContext(draftContext -> {
            List list = (List)Queries.createQuery(options.getSqlClient(), type, ExecutionPurpose.command(queryReason), FilterLevel.IGNORE_USER_FILTERS, (q, table) -> {
                block.accept((MutableQuery)q, (Table<?>)table);
                if (ctx.trigger != null) {
                    return q.select(table);
                }
                return q.select(table.fetch(fetcher));
            }).forUpdate(options.getLockMode() == LockMode.PESSIMISTIC).execute(ctx.con);
            return draftContext.resolveList(list);
        });
    }
}

