/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.OptimisticLockValueFactoryFactories;
import org.babyfish.jimmer.sql.ast.impl.mutation.AffectedRows;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.Keys;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.table.spi.UntypedJoinDisabledTableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.impl.SequenceIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SaveException;

class Operator {
    private static final String GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON = "Joining is disabled in general optimistic lock";
    private static final int[] EMPTY_ROW_COUNTS = new int[0];
    final SaveContext ctx;

    Operator(SaveContext ctx) {
        this.ctx = ctx;
    }

    public void insert(Batch<DraftSpi> batch) {
        if (batch.entities().isEmpty() || batch.shape().isIdOnly()) {
            return;
        }
        this.validate(batch.shape(), true);
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass()).getGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        SequenceIdGenerator sequenceIdGenerator = null;
        UserIdGenerator userIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (idGenerator instanceof UserIdGenerator) {
                userIdGenerator = (UserIdGenerator)idGenerator;
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException.IllegalIdGenerator(this.ctx.path, "In order to insert object without id, the id generator must be identity or sequence");
            }
        }
        if (userIdGenerator != null) {
            Class javaType = this.ctx.path.getType().getJavaClass();
            PropId idPropId = this.ctx.path.getType().getIdProp().getId();
            for (DraftSpi draftSpi : batch.entities()) {
                draftSpi.__set(idPropId, userIdGenerator.generate(javaType));
            }
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient);
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("insert into ")).sql(this.ctx.path.getType().getTableName(strategy))).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)builder.separator()).sql(((SingleColumn)this.ctx.path.getType().getIdProp().getStorage(strategy)).getName());
        }
        for (PropertyGetter propertyGetter : batch.shape().getGetters()) {
            ((BatchSqlBuilder)builder.separator()).sql(propertyGetter);
        }
        for (PropertyGetter propertyGetter : defaultGetters) {
            ((BatchSqlBuilder)builder.separator()).sql(propertyGetter);
        }
        ((BatchSqlBuilder)((BatchSqlBuilder)builder.leave()).sql(" values")).enter(AbstractSqlBuilder.ScopeType.TUPLE);
        if (sequenceIdGenerator != null) {
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.separator()).sql("(")).sql(sqlClient.getDialect().getSelectIdFromSequenceSql(sequenceIdGenerator.getSequenceName()))).sql(")");
        } else if (userIdGenerator != null) {
            Iterator fullShape = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass());
            builder.separator();
            for (PropertyGetter getter : ((Shape)((Object)fullShape)).getIdGetters()) {
                ((BatchSqlBuilder)builder.separator()).sql(getter);
            }
        }
        for (PropertyGetter propertyGetter : batch.shape().getGetters()) {
            ((BatchSqlBuilder)builder.separator()).variable(propertyGetter);
        }
        for (PropertyGetter propertyGetter : defaultGetters) {
            ((BatchSqlBuilder)builder.separator()).defaultVariable(propertyGetter);
        }
        builder.leave();
        MutationTrigger trigger = this.ctx.trigger;
        if (trigger != null) {
            for (DraftSpi draft : batch.entities()) {
                trigger.modifyEntityTable(null, draft);
            }
        }
        int n = this.execute(builder, batch, false);
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), n);
    }

    public void update(Map<Object, ImmutableSpi> originalIdObjMap, Map<Object, ImmutableSpi> originalKeyObjMap, Batch<DraftSpi> batch) {
        ArrayList<DraftSpi> entities;
        boolean updateVersion;
        this.validate(batch.shape(), false);
        Set<ImmutableProp> keyProps = batch.shape().getIdGetters().isEmpty() ? this.ctx.options.getKeyProps(batch.shape().getType()) : null;
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        List<PropertyGetter> idGetters = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass()).getIdGetters();
        if (keyProps != null && idGetters.size() > 1) {
            throw new IllegalArgumentException("Cannot update batch whose shape does not have id when id property is embeddable");
        }
        Predicate userOptimisticLockPredicate = this.userLockOptimisticPredicate();
        PropertyGetter versionGetter = batch.shape().getVersionGetter();
        boolean bl = updateVersion = userOptimisticLockPredicate == null && versionGetter != null;
        if (updateVersion && keyProps != null) {
            throw new IllegalArgumentException("Cannot update batch whose shape does not have id when optimistic lock is required");
        }
        if (batch.entities().isEmpty() || batch.shape().isIdOnly()) {
            return;
        }
        LinkedHashSet<ImmutableProp> changedProps = originalIdObjMap != null || originalKeyObjMap != null ? new LinkedHashSet<ImmutableProp>() : null;
        ArrayList<PropertyGetter> updatedGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : batch.shape().getGetters()) {
            ImmutableProp prop = getter.prop();
            if (prop.isId() || prop.isVersion() && userOptimisticLockPredicate == null || !prop.isColumnDefinition() || keyProps != null && keyProps.contains(prop)) continue;
            if (changedProps != null) {
                changedProps.add(prop);
            }
            updatedGetters.add(getter);
        }
        if (updatedGetters.isEmpty() && !updateVersion) {
            this.fillIds(QueryReason.GET_ID_WHEN_UPDATE_NOTHING, originalKeyObjMap, batch);
            return;
        }
        if (keyProps != null && !sqlClient.getDialect().isIdFetchableByKeyUpdate()) {
            this.fillIds(QueryReason.GET_ID_FOR_KEY_BASE_UPDATE, originalKeyObjMap, batch);
            if (batch.entities().isEmpty()) {
                return;
            }
        }
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient);
        UpdateContextImpl updateContext = new UpdateContextImpl(builder, batch.shape(), Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass()).getIdGetters().get(0), keyProps, updatedGetters, updateVersion, userOptimisticLockPredicate, versionGetter);
        sqlClient.getDialect().update(updateContext);
        MutationTrigger trigger = this.ctx.trigger;
        Collection<Object> collection = entities = changedProps != null ? new ArrayList(batch.entities().size()) : null;
        if (entities != null || trigger != null) {
            if (keyProps != null) {
                Iterator<DraftSpi> iterator = batch.entities().iterator();
                while (iterator.hasNext()) {
                    Object draft;
                    ImmutableSpi oldRow = originalKeyObjMap != null ? originalKeyObjMap.get(Keys.keyOf((ImmutableSpi)draft, keyProps)) : null;
                    if (!this.isChanged(changedProps, oldRow, (ImmutableSpi)(draft = iterator.next()))) continue;
                    if (trigger != null) {
                        trigger.modifyEntityTable(oldRow, draft);
                    }
                    if (entities == null) continue;
                    entities.add((DraftSpi)draft);
                }
            } else {
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                for (DraftSpi draft : batch.entities()) {
                    ImmutableSpi oldRow;
                    ImmutableSpi immutableSpi = oldRow = originalIdObjMap != null ? originalIdObjMap.get(draft.__get(idPropId)) : null;
                    if (!this.isChanged(changedProps, oldRow, (ImmutableSpi)draft) && !updateVersion) continue;
                    if (trigger != null) {
                        trigger.modifyEntityTable(oldRow, draft);
                    }
                    if (entities == null) continue;
                    entities.add(draft);
                }
            }
        }
        if (entities == null) {
            entities = batch.entities();
        }
        int[] rowCounts = this.executeAndGetRowCounts(builder, batch.shape(), entities, true);
        if (versionGetter != null || userOptimisticLockPredicate != null) {
            int index = 0;
            for (DraftSpi row : entities) {
                if (rowCounts[index++] != 0) continue;
                this.ctx.throwOptimisticLockError((ImmutableSpi)row);
            }
        }
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), Operator.rowCount(rowCounts));
    }

    private void fillIds(QueryReason queryReason, Map<Object, ImmutableSpi> originalKeyObjMap, Batch<DraftSpi> batch) {
        Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
        Map<Object, ImmutableSpi> keyMap = originalKeyObjMap;
        if (keyMap == null) {
            Fetcher<Object> fetcher = new FetcherImpl<ImmutableSpi>(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : keyProps) {
                if (keyProp.isReference(TargetLevel.ENTITY)) {
                    fetcher = fetcher.add(keyProp.getName(), IdOnlyFetchType.RAW);
                    continue;
                }
                fetcher = fetcher.add(keyProp.getName());
            }
            keyMap = Rows.findMapByKeys(this.ctx, queryReason, fetcher, batch.entities());
        }
        PropId idPropId = this.ctx.path.getType().getIdProp().getId();
        Iterator<DraftSpi> itr = batch.entities().iterator();
        while (itr.hasNext()) {
            DraftSpi draft = itr.next();
            ImmutableSpi row = keyMap.get(Keys.keyOf((ImmutableSpi)draft, keyProps));
            if (row != null) {
                draft.__set(idPropId, row.__get(idPropId));
                continue;
            }
            itr.remove();
        }
    }

    public void upsert(Batch<DraftSpi> batch) {
        this.validate(batch.shape(), false);
        if (batch.entities().isEmpty() || batch.shape().isIdOnly()) {
            return;
        }
        if (this.ctx.trigger != null) {
            throw new AssertionError((Object)"Internal bug: Upsert cannot be called if the trigger is not null");
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        Shape fullShape = Shape.fullOf(sqlClient, batch.shape().getType().getJavaClass());
        ArrayList<PropertyGetter> defaultGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : fullShape.getColumnDefinitionGetters()) {
            if (!getter.metadata().hasDefaultValue() || batch.shape().contains(getter)) continue;
            defaultGetters.add(getter);
        }
        SequenceIdGenerator sequenceIdGenerator = null;
        if (batch.shape().getIdGetters().isEmpty()) {
            IdGenerator idGenerator = sqlClient.getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator instanceof SequenceIdGenerator) {
                sequenceIdGenerator = (SequenceIdGenerator)idGenerator;
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException.IllegalIdGenerator(this.ctx.path, "In order to upsert object without id, the id generator must be IdentityGenerator or Sequence");
            }
        }
        ArrayList<PropertyGetter> insertedGetters = new ArrayList<PropertyGetter>();
        insertedGetters.addAll(batch.shape().getColumnDefinitionGetters());
        insertedGetters.addAll(defaultGetters);
        ArrayList<PropertyGetter> conflictGetters = new ArrayList<PropertyGetter>();
        if (!batch.shape().getIdGetters().isEmpty()) {
            conflictGetters.addAll(batch.shape().getIdGetters());
        } else {
            Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
            for (PropertyGetter getter : fullShape.getGetters()) {
                if (keyProps.contains(getter.prop())) {
                    conflictGetters.add(getter);
                    continue;
                }
                if (!getter.prop().isLogicalDeleted()) continue;
                conflictGetters.add(getter);
            }
        }
        ArrayList<PropertyGetter> updatedGetters = new ArrayList<PropertyGetter>();
        for (PropertyGetter getter : batch.shape().getGetters()) {
            if (conflictGetters.contains(getter)) continue;
            updatedGetters.add(getter);
        }
        for (PropertyGetter defaultGetter : defaultGetters) {
            if (conflictGetters.contains(defaultGetter)) continue;
            updatedGetters.add(defaultGetter);
        }
        Predicate userOptimisticLockPredicate = this.userLockOptimisticPredicate();
        PropertyGetter versionGetter = batch.shape().getVersionGetter();
        BatchSqlBuilder builder = new BatchSqlBuilder(sqlClient);
        UpsertContextImpl upsertContext = new UpsertContextImpl(builder, batch.shape().getIdGetters().isEmpty() ? batch.shape().getType().getIdProp() : null, sequenceIdGenerator, insertedGetters, conflictGetters, updatedGetters, userOptimisticLockPredicate, versionGetter);
        sqlClient.getDialect().upsert(upsertContext);
        int rowCount = this.execute(builder, batch, true);
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), rowCount);
    }

    private void validate(Shape shape, boolean insertOnly) {
        Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(shape.getType());
        if (!insertOnly && shape.isWild(keyProps)) {
            this.ctx.throwNeitherIdNorKey(shape.getType(), keyProps);
        }
        MetadataStrategy strategy = this.ctx.options.getSqlClient().getMetadataStrategy();
        if (!shape.getIdGetters().isEmpty()) {
            ImmutableProp idProp = shape.getType().getIdProp();
            ColumnDefinition definition = (ColumnDefinition)shape.getType().getIdProp().getStorage(strategy);
            if (shape.getIdGetters().size() < definition.size()) {
                this.ctx.throwIncompleteProperty(idProp, "id");
            }
        }
        Map<ImmutableProp, List<PropertyGetter>> getterMap = shape.getGetterMap();
        for (Map.Entry<ImmutableProp, List<PropertyGetter>> e : getterMap.entrySet()) {
            ColumnDefinition definition;
            ImmutableProp prop = e.getKey();
            List<PropertyGetter> getter = e.getValue();
            if (prop.isReference(TargetLevel.ENTITY)) {
                definition = (ColumnDefinition)prop.getStorage(strategy);
                if (getter.size() >= definition.size()) continue;
                this.ctx.throwIncompleteProperty(prop, "associated id");
                continue;
            }
            if (!keyProps.contains(prop)) continue;
            definition = (ColumnDefinition)prop.getStorage(strategy);
            if (getter.size() >= definition.size()) continue;
            this.ctx.throwIncompleteProperty(prop, "key");
        }
    }

    private Predicate userLockOptimisticPredicate() {
        UserOptimisticLock<?, ?> userOptimisticLock = this.ctx.options.getUserOptimisticLock(this.ctx.path.getType());
        if (userOptimisticLock == null) {
            return null;
        }
        MutableRootQueryImpl fakeQuery = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.DEFAULT);
        Object table = fakeQuery.getTable();
        table = table instanceof TableImplementor ? new UntypedJoinDisabledTableProxy((TableImplementor)table, GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON) : ((TableProxy)table).__disableJoin(GENERAL_OPTIMISTIC_DISABLED_JOIN_REASON);
        return userOptimisticLock.predicate(table, OptimisticLockValueFactoryFactories.of());
    }

    private boolean isChanged(Set<ImmutableProp> props, ImmutableSpi oldRow, ImmutableSpi newRow) {
        if (oldRow == null) {
            return true;
        }
        for (ImmutableProp prop : props) {
            PropId propId = prop.getId();
            if (!oldRow.__isLoaded(propId)) {
                return true;
            }
            Object oldValue = oldRow.__get(propId);
            Object newValue = newRow.__get(propId);
            if (oldRow.__isLoaded(propId) && Objects.equals(oldValue, newValue)) continue;
            if (this.ctx.backReferenceFrozen && prop == this.ctx.backReferenceProp && oldValue != null && newValue != null) {
                this.ctx.throwTargetIsNotTransferable(newRow);
            }
            return true;
        }
        return false;
    }

    private int[] executeAndGetRowCounts(BatchSqlBuilder builder, Shape shape, Collection<DraftSpi> entities, boolean updatable) {
        if (entities.isEmpty()) {
            return EMPTY_ROW_COUNTS;
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        PropertyGetter versionGetter = shape.getVersionGetter();
        Tuple2<String, BatchSqlBuilder.VariableMapper> tuple = builder.build();
        try (Executor.BatchContext batchContext = sqlClient.getExecutor().executeBatch(this.ctx.con, tuple.get_1(), shape.getIdGetters().isEmpty() ? this.ctx.path.getType().getIdProp() : null, ExecutionPurpose.command(QueryReason.NONE), sqlClient);){
            BatchSqlBuilder.VariableMapper mapper = tuple.get_2();
            for (DraftSpi draft : entities) {
                batchContext.add(mapper.variables(draft));
            }
            int[] rowCounts = batchContext.execute();
            if (shape.getIdGetters().isEmpty()) {
                Object[] generatedIds = batchContext.generatedIds();
                if (generatedIds.length != entities.size()) {
                    throw new IllegalStateException("The inserted row count is " + entities.size() + ", but the count of generated ids is " + generatedIds.length);
                }
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                int index = 0;
                int generatedIndex = 0;
                for (DraftSpi draft : entities) {
                    Object id;
                    if (rowCounts[index++] == 0 || (id = generatedIds[generatedIndex++]) == null) continue;
                    draft.__set(idPropId, id);
                }
            }
            if (updatable && versionGetter != null) {
                PropId versionPropId = versionGetter.prop().getId();
                Iterator<DraftSpi> itr = entities.iterator();
                for (int rowCount : rowCounts) {
                    DraftSpi draft = itr.next();
                    if (rowCount == 0) {
                        this.ctx.throwOptimisticLockError((ImmutableSpi)draft);
                    }
                    Integer version = (Integer)draft.__get(versionPropId);
                    draft.__set(versionPropId, (Object)(version + 1));
                }
            }
            int[] nArray = rowCounts;
            return nArray;
        }
    }

    private int execute(BatchSqlBuilder builder, Batch<DraftSpi> batch, boolean updatable) {
        int[] rowCounts = this.executeAndGetRowCounts(builder, batch.shape(), batch.entities(), updatable);
        return Operator.rowCount(rowCounts);
    }

    private static int rowCount(int[] rowCounts) {
        int sumRowCount = 0;
        for (int rowCount : rowCounts) {
            if (rowCount == 0) continue;
            ++sumRowCount;
        }
        return sumRowCount;
    }

    private class UpdateContextImpl
    implements Dialect.UpdateContext {
        private final BatchSqlBuilder builder;
        private final Shape shape;
        private final PropertyGetter idGetter;
        private final Set<ImmutableProp> keyProps;
        private final List<PropertyGetter> updatedGetters;
        private final boolean updateVersion;
        private final Predicate userOptimisticLockPredicate;
        private final PropertyGetter versionGetter;

        private UpdateContextImpl(BatchSqlBuilder builder, Shape shape, PropertyGetter idGetter, Set<ImmutableProp> keyProps, List<PropertyGetter> updatedGetters, boolean updateVersion, Predicate userOptimisticLockPredicate, PropertyGetter versionGetter) {
            this.builder = builder;
            this.shape = shape;
            this.idGetter = idGetter;
            this.keyProps = keyProps;
            this.updatedGetters = updatedGetters;
            this.updateVersion = updateVersion;
            this.userOptimisticLockPredicate = userOptimisticLockPredicate;
            this.versionGetter = versionGetter;
        }

        @Override
        public boolean isUpdatedByKey() {
            return this.shape.getIdGetters().isEmpty();
        }

        @Override
        public Dialect.UpdateContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpdateContext sql(ValueGetter getter) {
            this.builder.sql(getter);
            return this;
        }

        @Override
        public Dialect.UpdateContext enter(AbstractSqlBuilder.ScopeType type) {
            this.builder.enter(type);
            return this;
        }

        @Override
        public Dialect.UpdateContext separator() {
            this.builder.separator();
            return this;
        }

        @Override
        public Dialect.UpdateContext leave() {
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpdateContext appendTableName() {
            MetadataStrategy strategy = Operator.this.ctx.options.getSqlClient().getMetadataStrategy();
            this.builder.sql(Operator.this.ctx.path.getType().getTableName(strategy));
            return this;
        }

        @Override
        public Dialect.UpdateContext appendAssignments() {
            for (PropertyGetter getter : this.updatedGetters) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
            }
            if (this.updateVersion) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(this.versionGetter)).sql(" = ")).sql(this.versionGetter)).sql(" + 1");
            }
            return this;
        }

        @Override
        public Dialect.UpdateContext appendPredicates() {
            if (this.keyProps != null) {
                Map<ImmutableProp, List<PropertyGetter>> getterMap = this.shape.getGetterMap();
                for (ImmutableProp keyProp : this.keyProps) {
                    List<PropertyGetter> getters = getterMap.get(keyProp);
                    for (PropertyGetter getter : getters) {
                        ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
                    }
                }
            } else {
                for (PropertyGetter getter : this.shape.getIdGetters()) {
                    ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ")).variable(getter);
                }
            }
            if (this.userOptimisticLockPredicate != null) {
                this.builder.separator();
                ((Ast)((Object)this.userOptimisticLockPredicate)).renderTo(this.builder);
            } else if (this.versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(this.versionGetter)).sql(" = ")).variable(this.versionGetter);
            }
            return this;
        }

        @Override
        public Dialect.UpdateContext appendId() {
            this.builder.sql(this.idGetter);
            return this;
        }
    }

    private class UpsertContextImpl
    implements Dialect.UpsertContext {
        private final BatchSqlBuilder builder;
        private final SequenceIdGenerator sequenceIdGenerator;
        private final PropertyGetter generatedIdGetter;
        private final List<PropertyGetter> insertedGetters;
        private final List<PropertyGetter> conflictGetters;
        private final List<PropertyGetter> updatedGetters;
        private final Predicate userOptimisticLockPredicate;
        private final PropertyGetter versionGetter;

        private UpsertContextImpl(BatchSqlBuilder builder, ImmutableProp generatedIdProp, SequenceIdGenerator sequenceIdGenerator, List<PropertyGetter> insertedGetters, List<PropertyGetter> conflictGetters, List<PropertyGetter> updatedGetters, Predicate userOptimisticLockPredicate, PropertyGetter versionGetter) {
            if (generatedIdProp != null && generatedIdProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                throw new IllegalArgumentException("Generated id prop cannot be embeddable");
            }
            if (generatedIdProp != null && (userOptimisticLockPredicate != null || versionGetter != null)) {
                throw new IllegalArgumentException("Optimistic lock is not support by upsert statement which can generate id");
            }
            this.builder = builder;
            this.sequenceIdGenerator = sequenceIdGenerator;
            this.generatedIdGetter = generatedIdProp != null ? Shape.fullOf(builder.sqlClient(), generatedIdProp.getDeclaringType().getJavaClass()).getIdGetters().get(0) : null;
            this.insertedGetters = insertedGetters;
            this.conflictGetters = conflictGetters;
            this.updatedGetters = updatedGetters;
            this.userOptimisticLockPredicate = userOptimisticLockPredicate;
            this.versionGetter = versionGetter;
        }

        @Override
        public boolean hasUpdatedColumns() {
            return !this.updatedGetters.isEmpty();
        }

        @Override
        public boolean hasOptimisticLock() {
            return this.userOptimisticLockPredicate != null || this.versionGetter != null;
        }

        @Override
        public boolean hasGeneratedId() {
            return this.generatedIdGetter != null;
        }

        @Override
        public List<ValueGetter> getConflictGetters() {
            return Collections.unmodifiableList(this.conflictGetters);
        }

        @Override
        public Dialect.UpsertContext sql(String sql) {
            this.builder.sql(sql);
            return this;
        }

        @Override
        public Dialect.UpsertContext sql(ValueGetter getter) {
            this.builder.sql(getter);
            return this;
        }

        @Override
        public Dialect.UpsertContext enter(AbstractSqlBuilder.ScopeType type) {
            this.builder.enter(type);
            return this;
        }

        @Override
        public Dialect.UpsertContext separator() {
            this.builder.separator();
            return this;
        }

        @Override
        public Dialect.UpsertContext leave() {
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendTableName() {
            this.builder.sql(Operator.this.ctx.path.getType().getTableName(Operator.this.ctx.options.getSqlClient().getMetadataStrategy()));
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertedColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            if (this.sequenceIdGenerator != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql("(")).sql(this.builder.sqlClient().getDialect().getSelectIdFromSequenceSql(this.sequenceIdGenerator.getSequenceName()))).sql(")");
            }
            for (PropertyGetter getter : this.insertedGetters) {
                if (getter.prop().isId() && this.sequenceIdGenerator != null) continue;
                ((BatchSqlBuilder)this.builder.separator()).sql(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendConflictColumns() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.conflictGetters) {
                ((BatchSqlBuilder)this.builder.separator()).sql(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendInsertingValues() {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.insertedGetters) {
                ((BatchSqlBuilder)this.builder.separator()).variable(getter);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendUpdatingAssignments(String prefix, String suffix) {
            this.builder.enter(AbstractSqlBuilder.ScopeType.COMMA);
            for (PropertyGetter getter : this.updatedGetters) {
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.separator()).sql(getter)).sql(" = ");
                if (getter.metadata().getValueProp().isVersion() && Operator.this.ctx.options.getUserOptimisticLock(Operator.this.ctx.path.getType()) == null) {
                    ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(" + 1");
                    continue;
                }
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(prefix)).sql(getter)).sql(suffix);
            }
            this.builder.leave();
            return this;
        }

        @Override
        public Dialect.UpsertContext appendOptimisticLockCondition() {
            if (this.userOptimisticLockPredicate != null) {
                ((Ast)((Object)this.userOptimisticLockPredicate)).renderTo(this.builder);
            }
            if (this.versionGetter != null) {
                ((BatchSqlBuilder)((BatchSqlBuilder)this.builder.sql(this.versionGetter)).sql(" = ")).variable(this.versionGetter);
            }
            return this;
        }

        @Override
        public Dialect.UpsertContext appendGeneratedId() {
            if (this.generatedIdGetter != null) {
                this.builder.sql(this.generatedIdGetter);
            }
            return this;
        }
    }
}

