/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteOptions;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class DeleteCommandImpl
extends AbstractCommandImpl
implements DeleteCommand {
    public DeleteCommandImpl(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, Collection<?> ids) {
        super(DeleteCommandImpl.initialCfg(sqlClient, con, type, ids));
    }

    private DeleteCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    @Override
    public DeleteResult execute(Connection con) {
        OptionsImpl options = (OptionsImpl)this.options();
        return options.getSqlClient().getConnectionManager().execute(con == null ? options.con : con, this::executeImpl);
    }

    private DeleteResult executeImpl(Connection con) {
        OptionsImpl options = (OptionsImpl)this.options();
        boolean binLogOnly = options.getSqlClient().getTriggerType() == TriggerType.BINLOG_ONLY;
        Deleter deleter = new Deleter(((OptionsImpl)options).argument.type, options, con, binLogOnly ? null : new MutationTrigger(), new HashMap<AffectedTable, Integer>());
        deleter.addIds(((OptionsImpl)options).argument.ids);
        return deleter.execute();
    }

    private static AbstractCommandImpl.Cfg initialCfg(JSqlClientImplementor sqlClient, Connection con, ImmutableType type, Collection<?> ids) {
        AbstractCommandImpl.Cfg cfg = new AbstractCommandImpl.RootCfg(sqlClient, new Argument(type, ids));
        if (con != null) {
            cfg = new AbstractCommandImpl.ConnectionCfg(cfg, con);
        }
        return cfg;
    }

    @Override
    OptionsImpl createOptions() {
        return new OptionsImpl(this.cfg);
    }

    @Override
    public DeleteCommand setMode(DeleteMode mode) {
        return new DeleteCommandImpl(new AbstractCommandImpl.DeleteModeCfg(this.cfg, mode));
    }

    @Override
    public DeleteCommand setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
        return new DeleteCommandImpl(new AbstractCommandImpl.DissociationActionCfg(this.cfg, prop, dissociateAction));
    }

    static class OptionsImpl
    implements DeleteOptions {
        private final JSqlClientImplementor sqlClient;
        private final Connection con;
        private final DeleteMode mode;
        private final Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private final Argument argument;

        OptionsImpl(AbstractCommandImpl.Cfg cfg) {
            AbstractCommandImpl.RootCfg rootCfg = cfg.as(AbstractCommandImpl.RootCfg.class);
            AbstractCommandImpl.ConnectionCfg connectionCfg = cfg.as(AbstractCommandImpl.ConnectionCfg.class);
            AbstractCommandImpl.DeleteModeCfg deleteModeCfg = cfg.as(AbstractCommandImpl.DeleteModeCfg.class);
            AbstractCommandImpl.DissociationActionCfg dissociationActionCfg = cfg.as(AbstractCommandImpl.DissociationActionCfg.class);
            assert (rootCfg != null);
            this.sqlClient = rootCfg.sqlClient;
            this.con = connectionCfg != null ? connectionCfg.con : null;
            this.mode = deleteModeCfg != null ? deleteModeCfg.mode : DeleteMode.AUTO;
            this.dissociateActionMap = AbstractCommandImpl.MapNode.toMap(dissociationActionCfg, it -> it.mapNode);
            this.argument = (Argument)rootCfg.argument;
        }

        public OptionsImpl(JSqlClientImplementor sqlClient, Connection con) {
            this.sqlClient = sqlClient;
            this.con = con;
            this.mode = DeleteMode.PHYSICAL;
            this.dissociateActionMap = Collections.emptyMap();
            this.argument = null;
        }

        @Override
        public JSqlClientImplementor getSqlClient() {
            return this.sqlClient;
        }

        public Argument getArgument() {
            return this.argument;
        }

        @Override
        public Connection getConnection() {
            return this.con;
        }

        @Override
        public DeleteMode getMode() {
            return this.mode;
        }

        @Override
        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            if (action == null) {
                action = prop.getDissociateAction();
            }
            if (action == DissociateAction.NONE) {
                action = this.sqlClient.isDefaultDissociationActionCheckable() ? DissociateAction.CHECK : DissociateAction.LAX;
            }
            return action;
        }

        @Override
        public Triggers getTriggers() {
            return this.sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : this.sqlClient.getTriggers(true);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlClient, this.mode, this.dissociateActionMap});
        }

        public String toString() {
            return "Data{sqlClient=" + this.sqlClient + ", mode=" + (Object)((Object)this.mode) + ", dissociateActionMap=" + this.dissociateActionMap + '}';
        }
    }

    private static class Argument {
        final ImmutableType type;
        final Collection<?> ids;

        private Argument(ImmutableType type, Collection<?> ids) {
            if (!type.isEntity()) {
                throw new IllegalArgumentException("Cannot delete object whose type is \"" + type + "\" because that type is not entity");
            }
            Class idClass = type.getIdProp().getElementClass();
            for (Object id : ids) {
                if (Converters.tryConvert(id, idClass) != null) continue;
                throw new IllegalArgumentException("The type of \"" + type.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
            }
            this.type = type;
            this.ids = ids;
        }
    }
}

