/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.AffectedRows;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectingType;
import org.babyfish.jimmer.sql.ast.impl.mutation.DisconnectionArgs;
import org.babyfish.jimmer.sql.ast.impl.mutation.ExclusiveIdPairPredicates;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.BatchSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.render.ComparisonPredicates;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.SqlContext;
import org.babyfish.jimmer.sql.meta.impl.LogicalDeletedValueGenerators;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class ChildTableOperator
extends AbstractOperator {
    final DeleteContext ctx;
    private final ChildTableOperator parent;
    final int mutationSubQueryDepth;
    private final QueryReason queryReason;
    final DisconnectingType disconnectingType;
    private final String tableName;
    private final List<ValueGetter> sourceGetters;
    final List<ValueGetter> targetGetters;

    ChildTableOperator(DeleteContext ctx) {
        this(null, ctx);
    }

    private ChildTableOperator(ChildTableOperator parent, ImmutableProp backReferenceProp) {
        this(parent, parent.ctx.backPropOf(backReferenceProp));
    }

    private ChildTableOperator(ChildTableOperator parent, DeleteContext ctx) {
        super(ctx.options.getSqlClient(), ctx.con);
        int mutationSubQueryDepth;
        DisconnectingType disconnectingType;
        if (ctx.backProp == null) {
            throw new IllegalArgumentException("The delete context for child table operator must have back prop");
        }
        if (!ctx.backProp.isColumnDefinition()) {
            throw new IllegalArgumentException("The delete context for child table operator is \"" + ctx.backProp + "\" which is not based on columns");
        }
        DissociateAction dissociateAction = ctx.options.getDissociateAction(ctx.path.getBackProp());
        switch (dissociateAction) {
            case CHECK: {
                disconnectingType = DisconnectingType.CHECKING;
                break;
            }
            case SET_NULL: {
                disconnectingType = DisconnectingType.SET_NULL;
                break;
            }
            case DELETE: {
                if (ctx.isLogicalDeleted() && !ctx.backProp.isTargetForeignKeyReal(ctx.options.getSqlClient().getMetadataStrategy())) {
                    disconnectingType = DisconnectingType.LOGICAL_DELETE;
                    break;
                }
                disconnectingType = DisconnectingType.PHYSICAL_DELETE;
                break;
            }
            default: {
                disconnectingType = DisconnectingType.NONE;
            }
        }
        QueryReason queryReason = QueryReason.NONE;
        if (disconnectingType == DisconnectingType.CHECKING) {
            queryReason = QueryReason.CHECKING;
        } else if (ctx.trigger != null) {
            queryReason = QueryReason.TRIGGER;
        }
        int n = mutationSubQueryDepth = parent != null ? parent.mutationSubQueryDepth + 1 : 1;
        if (mutationSubQueryDepth > ctx.options.getSqlClient().getMaxCommandJoinCount()) {
            mutationSubQueryDepth = 0;
            queryReason = QueryReason.TOO_DEEP;
        }
        this.ctx = ctx;
        this.parent = parent;
        this.mutationSubQueryDepth = mutationSubQueryDepth;
        this.queryReason = queryReason;
        this.disconnectingType = disconnectingType;
        this.tableName = ctx.path.getType().getTableName(this.sqlClient.getMetadataStrategy());
        this.sourceGetters = ValueGetter.valueGetters(this.sqlClient, ctx.backProp);
        this.targetGetters = ValueGetter.valueGetters(this.sqlClient, ctx.path.getType().getIdProp());
    }

    final void disconnect(Collection<Object> ids) {
        this.disconnect(DisconnectionArgs.delete(ids, null).withTrigger(true));
    }

    final void disconnectExcept(IdPairs.Retain idPairs) {
        this.disconnect(DisconnectionArgs.retain(idPairs, this).withTrigger(true));
    }

    private void disconnect(DisconnectionArgs args) {
        List<Object> preExecutedIds;
        List<Object> ids;
        if (this.disconnectingType == DisconnectingType.NONE || args.isEmpty()) {
            return;
        }
        if (this.disconnectingType == DisconnectingType.CHECKING && !(ids = this.findDisconnectingIds(args, 1)).isEmpty()) {
            this.ctx.throwCannotDissociateTarget();
        }
        if (this.ctx.trigger != null) {
            List<ImmutableSpi> rows = this.findDisconnectingObjects(args);
            if (rows.isEmpty()) {
                return;
            }
            if (args.deletedIds == null || args.caller != this) {
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                args = DisconnectionArgs.delete(rows.stream().map(row -> row.__get(idPropId)).collect(Collectors.toList()), this).withTrigger(args.fireEvents);
            }
            if (this.disconnectingType == DisconnectingType.LOGICAL_DELETE) {
                Object generatedValue = LogicalDeletedValueGenerators.of((LogicalDeletedInfo)this.ctx.path.getType().getLogicalDeletedInfo(), (SqlContext)this.sqlClient).generate();
                args = args.withLogicalDeletedValue(generatedValue);
            }
            for (ImmutableSpi row2 : rows) {
                Object value;
                ImmutableProp prop;
                switch (this.disconnectingType) {
                    case LOGICAL_DELETE: {
                        prop = this.ctx.path.getType().getLogicalDeletedInfo().getProp();
                        value = args.logicalDeletedValueRef.getValue();
                        break;
                    }
                    case SET_NULL: {
                        prop = this.ctx.backProp;
                        value = null;
                        break;
                    }
                    default: {
                        prop = null;
                        value = null;
                    }
                }
                Deleter.fireEvent(row2, prop, value, this.ctx.trigger);
            }
        }
        if ((args.deletedIds == null || this != args.caller) && (preExecutedIds = this.preDisconnect(args)) != null) {
            DisconnectionArgs subArgs = DisconnectionArgs.delete(preExecutedIds, this);
            this.disconnect(subArgs);
            return;
        }
        for (ChildTableOperator subOperator : this.subOperators()) {
            subOperator.disconnect(args);
        }
        if (this.disconnectingType.isDelete()) {
            for (MiddleTableOperator middleTableOperator : this.middleTableOperators()) {
                middleTableOperator.disconnect(args);
            }
        }
        this.disconnectImpl(args);
    }

    private List<Object> preDisconnect(DisconnectionArgs args) {
        if (this.queryReason == QueryReason.NONE) {
            return null;
        }
        if (this.queryReason == QueryReason.TUPLE_IS_UNSUPPORTED && (args.retainedIdPairs == null || args.retainedIdPairs.tuples().size() <= 1)) {
            return null;
        }
        return this.findDisconnectingIds(args, 0);
    }

    private void disconnectImpl(DisconnectionArgs args) {
        if (args.deletedIds != null) {
            SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
            this.addOperationHead(builder, args, this.currentDepth(args));
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.addPredicates(builder, args, this.currentDepth(args));
            builder.leave();
            int rowCount = this.execute(builder);
            AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), rowCount);
        } else if (this.targetGetters.size() == 1 && this.sqlClient.getDialect().isAnyEqualityOfArraySupported()) {
            this.disconnectExceptByBatch(args);
        } else {
            this.disconnectExceptByInPredicate(args);
        }
    }

    private void disconnectExceptByBatch(DisconnectionArgs args) {
        BatchSqlBuilder builder = new BatchSqlBuilder(this.sqlClient);
        this.addOperationHead(builder, args, this.currentDepth(args));
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, args, this.currentDepth(args));
        builder.leave();
        int rowCount = this.execute(builder, args.retainedIdPairs.entries());
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), rowCount);
    }

    private void disconnectExceptByInPredicate(DisconnectionArgs args) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        this.addOperationHead(builder, args, this.currentDepth(args));
        builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
        this.addPredicates(builder, args, this.currentDepth(args));
        builder.leave();
        int rowCount = this.execute(builder);
        AffectedRows.add(this.ctx.affectedRowCountMap, this.ctx.path.getType(), rowCount);
    }

    private void addOperationHead(AbstractSqlBuilder<?> builder, DisconnectionArgs args, int depth) {
        if (this.disconnectingType == DisconnectingType.PHYSICAL_DELETE) {
            ((AbstractSqlBuilder)builder.sql("delete from ")).sql(this.tableName);
            if (depth != 0) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(ChildTableOperator.alias(depth));
            }
        } else if (this.disconnectingType == DisconnectingType.LOGICAL_DELETE) {
            LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
            assert (logicalDeletedInfo != null);
            ((AbstractSqlBuilder)builder.sql("update ")).sql(this.tableName);
            if (depth != 0) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(ChildTableOperator.alias(depth));
            }
            ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.enter(AbstractSqlBuilder.ScopeType.SET)).logicalDeleteAssignment(logicalDeletedInfo, args.logicalDeletedValueRef, null)).leave();
        } else {
            ((AbstractSqlBuilder)builder.sql("update ")).sql(this.tableName);
            if (depth != 0) {
                ((AbstractSqlBuilder)builder.sql(" ")).sql(ChildTableOperator.alias(depth));
            }
            builder.enter(AbstractSqlBuilder.ScopeType.SET);
            for (ValueGetter sourceGetter : this.sourceGetters) {
                ((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(sourceGetter)).sql(" = null");
            }
            builder.leave();
        }
    }

    final void addPredicates(AbstractSqlBuilder<?> builder, DisconnectionArgs args, int depth) {
        LogicalDeletedInfo logicalDeletedInfo;
        if (builder instanceof BatchSqlBuilder) {
            this.addPredicatesImpl((BatchSqlBuilder)builder, args.deletedIds, args.caller, depth);
        } else {
            this.addPredicatesImpl((SqlBuilder)builder, args, depth);
        }
        if (this.disconnectingType != DisconnectingType.PHYSICAL_DELETE && (logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo()) != null) {
            ((AbstractSqlBuilder)builder.sql(" and ")).logicalDeleteFilter(logicalDeletedInfo, ChildTableOperator.alias(depth));
        }
    }

    private void addPredicatesImpl(BatchSqlBuilder builder, Collection<Object> deletedIds, ChildTableOperator caller, int depth) {
        if (this.isJoinAllowed(deletedIds, caller)) {
            ((BatchSqlBuilder)builder.sql("exists")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            ChildTableOperator deeper = this.parent;
            int childDepth = depth + 1;
            ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.sql("select * from ")).sql(deeper.tableName)).sql(" ")).sql(ChildTableOperator.alias(childDepth));
            while (deeper.isJoinAllowed(deletedIds, caller)) {
                ((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)((BatchSqlBuilder)builder.sql(" inner join ")).sql(deeper.parent.tableName)).sql(" ")).sql(ChildTableOperator.alias(++childDepth))).sql(" on ");
                deeper.addJoinPredicates(builder, childDepth);
                deeper = deeper.parent;
            }
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.addJoinPredicates(builder, depth + 1);
            deeper.addPredicatesImpl(builder, deletedIds, caller, childDepth);
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        if (deletedIds != null) {
            for (ValueGetter targetGetter : this.targetGetters) {
                builder.separator();
                ((BatchSqlBuilder)((BatchSqlBuilder)builder.sql(targetGetter)).sql(" = ")).variable(targetGetter);
            }
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, this.sourceGetters, this.targetGetters);
    }

    private void addPredicatesImpl(SqlBuilder builder, DisconnectionArgs args, int depth) {
        if (this.isJoinAllowed(args.deletedIds, args.caller)) {
            ((SqlBuilder)builder.sql("exists")).enter(AbstractSqlBuilder.ScopeType.SUB_QUERY);
            ChildTableOperator deeper = this.parent;
            int childDepth = depth + 1;
            ((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.sql("select * from ")).sql(deeper.tableName)).sql(" ")).sql(ChildTableOperator.alias(childDepth));
            while (deeper.isJoinAllowed(args.deletedIds, args.caller)) {
                ((SqlBuilder)((SqlBuilder)((SqlBuilder)((SqlBuilder)builder.sql(" inner join ")).sql(deeper.parent.tableName)).sql(" ")).sql(ChildTableOperator.alias(++childDepth))).sql(" on ");
                deeper.addJoinPredicates(builder, childDepth);
                deeper = deeper.parent;
            }
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            this.addJoinPredicates(builder, depth + 1);
            deeper.addPredicatesImpl(builder, args, childDepth);
            builder.leave();
            builder.leave();
            return;
        }
        builder.separator();
        String alias = ChildTableOperator.alias(depth);
        Collection<Object> deletedIds = args.deletedIds;
        if (deletedIds != null) {
            ComparisonPredicates.renderIn(false, ValueGetter.alias(alias, this == args.caller ? this.targetGetters : this.sourceGetters), deletedIds, builder);
            return;
        }
        IdPairs retainedIdPairs = args.retainedIdPairs;
        if (retainedIdPairs.entries().size() == 1) {
            Tuple2<Object, Collection<Object>> tuple = retainedIdPairs.entries().iterator().next();
            ComparisonPredicates.renderCmp("=", ValueGetter.alias(alias, this.sourceGetters), tuple.get_1(), builder);
            if (!tuple.get_2().isEmpty()) {
                builder.separator();
                ComparisonPredicates.renderIn(true, ValueGetter.alias(alias, this.targetGetters), tuple.get_2(), builder);
            }
            return;
        }
        ExclusiveIdPairPredicates.addPredicates(builder, ValueGetter.alias(alias, this.sourceGetters), ValueGetter.alias(alias, this.targetGetters), retainedIdPairs);
    }

    private boolean isJoinAllowed(Collection<Object> deletedIds, ChildTableOperator caller) {
        if (this.parent == null || this == caller) {
            return false;
        }
        if (deletedIds != null) {
            return this.parent != caller;
        }
        return true;
    }

    private void addJoinPredicates(AbstractSqlBuilder<?> builder, int depth) {
        List<ValueGetter> sourceGetters = this.sourceGetters;
        List<ValueGetter> parentGetters = ValueGetter.valueGetters(builder.sqlClient(), this.parent.ctx.path.getType().getIdProp());
        int size = sourceGetters.size();
        for (int i = 0; i < size; ++i) {
            ((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)((AbstractSqlBuilder)builder.separator()).sql(ChildTableOperator.alias(depth - 1))).sql(".")).sql(sourceGetters.get(i))).sql(" = ")).sql(ChildTableOperator.alias(depth))).sql(".")).sql(parentGetters.get(i));
        }
    }

    private List<Object> findDisconnectingIds(DisconnectionArgs args, int limit) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.ctx.path.getType(), (ExecutionPurpose)ExecutionPurpose.command(this.queryReason), this.disconnectingType.isDelete() && !this.ctx.isLogicalDeleted() ? FilterLevel.IGNORE_ALL : FilterLevel.IGNORE_USER_FILTERS);
        this.addDisconnectingConditions(query, (Table<?>)query.getTable(), args);
        ConfigurableRootQuery typedQuery = query.select(query.getTableImplementor().getId());
        if (limit > 0) {
            typedQuery = typedQuery.limit(limit);
        }
        return (List)typedQuery.execute(this.con);
    }

    private List<ImmutableSpi> findDisconnectingObjects(DisconnectionArgs args) {
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, this.ctx.path.getType(), (ExecutionPurpose)ExecutionPurpose.command(this.queryReason), this.disconnectingType.isDelete() && !this.ctx.isLogicalDeleted() ? FilterLevel.IGNORE_ALL : FilterLevel.IGNORE_USER_FILTERS);
        this.addDisconnectingConditions(query, (Table<?>)query.getTable(), args);
        return (List)query.select(query.getTable()).execute(this.con);
    }

    private void addDisconnectingConditions(AbstractMutableQueryImpl query, Table<?> table, DisconnectionArgs args) {
        if (this != args.caller && this.parent != null) {
            Table parentTable = table.join(this.ctx.backProp);
            this.parent.addDisconnectingConditions(query, parentTable, args);
            return;
        }
        Collection<Object> deletedIds = args.deletedIds;
        if (deletedIds != null) {
            if (!deletedIds.isEmpty()) {
                if (this == args.caller) {
                    query.where(table.getId().in(deletedIds));
                } else {
                    query.where(table.getAssociatedId(this.ctx.backProp).in(deletedIds));
                }
            }
            return;
        }
        IdPairs retainedIdPairs = args.retainedIdPairs;
        if (retainedIdPairs.entries().size() == 1) {
            query.where(table.getAssociatedId(this.ctx.backProp).in(Tuple2.projection1(retainedIdPairs.entries())));
            if (!retainedIdPairs.tuples().isEmpty()) {
                query.where(table.getId().notIn(Tuple2.projection2(retainedIdPairs.tuples())));
            }
            return;
        }
        query.where(table.getAssociatedId(this.ctx.backProp).in(Tuple2.projection1(retainedIdPairs.entries())));
        if (!retainedIdPairs.tuples().isEmpty()) {
            query.where(Expression.tuple(table.getAssociatedId(this.ctx.backProp), table.getId()).notIn(retainedIdPairs.tuples()));
        }
    }

    private List<ChildTableOperator> subOperators() {
        return ChildTableOperator.createSubOperators(this.ctx.options.getSqlClient(), this.ctx.path, this.disconnectingType, backProp -> new ChildTableOperator(this, (ImmutableProp)backProp));
    }

    private List<MiddleTableOperator> middleTableOperators() {
        return ChildTableOperator.createMiddleTableOperators(this.ctx.options.getSqlClient(), this.ctx.path, this.disconnectingType, prop -> MiddleTableOperator.propOf(this, prop), backProp -> MiddleTableOperator.backPropOf(this, backProp));
    }

    private int currentDepth(DisconnectionArgs args) {
        return this.isJoinAllowed(args.deletedIds, args.caller) ? 1 : 0;
    }

    private static String alias(int depth) {
        if (depth == 0) {
            return null;
        }
        return "tb_" + depth + '_';
    }

    public String toString() {
        return "ChildTableOperator(" + this.ctx.path + ")";
    }
}

