/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.TargetTransferMode;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.UserOptimisticLock;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class BatchEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements BatchEntitySaveCommand<E> {
    public BatchEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, Collection<E> entities) {
        super(BatchEntitySaveCommandImpl.initialCfg(sqlClient, con, entities));
    }

    private BatchEntitySaveCommandImpl(AbstractCommandImpl.Cfg cfg) {
        super(cfg);
    }

    @Override
    public BatchSaveResult<E> execute(Connection con) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        List entities = (List)options.getArument();
        if (entities.isEmpty()) {
            return new BatchSaveResult(Collections.emptyList());
        }
        return options.getSqlClient().getConnectionManager().execute(con == null ? options.getConnection() : con, this::executeImpl);
    }

    private BatchSaveResult<E> executeImpl(Connection con) {
        AbstractEntitySaveCommandImpl.OptionsImpl options = (AbstractEntitySaveCommandImpl.OptionsImpl)this.options();
        List entities = (List)options.getArument();
        ImmutableType type = ImmutableType.get(entities.iterator().next().getClass());
        Saver saver = new Saver(options, con, type);
        return saver.saveAll(entities);
    }

    private static AbstractCommandImpl.Cfg initialCfg(JSqlClientImplementor sqlClient, Connection con, Collection<?> entities) {
        ImmutableType type = null;
        for (Object entity : entities) {
            if (!(entity instanceof ImmutableSpi)) {
                throw new IllegalArgumentException("All the elements of entities must be immutable object");
            }
            if (!((ImmutableSpi)entity).__type().isEntity()) {
                throw new IllegalArgumentException("All the elements must be entity object");
            }
            if (entity instanceof DraftSpi) {
                throw new IllegalArgumentException("Each element of entity cannot be draft object");
            }
            ImmutableType entityType = ((ImmutableSpi)entity).__type();
            if (type != null && entityType != type) {
                throw new IllegalArgumentException("All the elements of entities must belong to same immutable type");
            }
            type = entityType;
        }
        AbstractCommandImpl.Cfg cfg = new AbstractCommandImpl.RootCfg(sqlClient, entities);
        if (con != null) {
            cfg = new AbstractCommandImpl.ConnectionCfg(cfg, con);
        }
        return cfg;
    }

    @Override
    public BatchEntitySaveCommand<E> setMode(SaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.ModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setAssociatedModeAll(AssociatedSaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setAssociatedMode(ImmutableProp prop, AssociatedSaveMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.AssociatedModeCfg(this.cfg, prop, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setKeyProps(ImmutableProp ... props) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.KeyPropsCfg(this.cfg, Arrays.asList(props)));
    }

    @Override
    public BatchEntitySaveCommand<E> setAutoIdOnlyTargetCheckingAll() {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, true));
    }

    @Override
    public BatchEntitySaveCommand<E> setAutoIdOnlyTargetChecking(ImmutableProp prop, boolean checking) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.IdOnlyAutoCheckingCfg(this.cfg, prop, checking));
    }

    @Override
    public BatchEntitySaveCommand<E> setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.DissociationActionCfg(this.cfg, prop, dissociateAction));
    }

    @Override
    public BatchEntitySaveCommand<E> setTargetTransferMode(ImmutableProp prop, TargetTransferMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, prop, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setTargetTransferModeAll(TargetTransferMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.TargetTransferModeCfg(this.cfg, mode));
    }

    @Override
    public BatchEntitySaveCommand<E> setLockMode(LockMode lockMode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.LockModeCfg(this.cfg, lockMode));
    }

    @Override
    public <T extends Table<E>> BatchEntitySaveCommand<E> setOptimisticLock(Class<T> tableType, UserOptimisticLock<E, T> block) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, ImmutableType.get(tableType), block));
    }

    @Override
    public BatchEntitySaveCommand<E> setEntityOptimisticLock(ImmutableType type, UserOptimisticLock<Object, Table<Object>> block) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractEntitySaveCommandImpl.OptimisticLockLambdaCfg(this.cfg, type, block));
    }

    @Override
    public BatchEntitySaveCommand<E> setDeleteMode(DeleteMode mode) {
        return new BatchEntitySaveCommandImpl<E>(new AbstractCommandImpl.DeleteModeCfg(this.cfg, mode));
    }
}

