/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdPairs;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MutationPath;
import org.jetbrains.annotations.Nullable;

class AssociationExecutable
implements Executable<Integer> {
    final JSqlClientImplementor sqlClient;
    final Connection con;
    private final AssociationType associationType;
    private final boolean reversed;
    private final boolean forDelete;
    private final boolean defaultCheckExistence;
    private final Boolean nullOrCheckedExistence;
    private final Set<Tuple2<?, ?>> idTuples;

    public AssociationExecutable(JSqlClientImplementor sqlClient, Connection con, AssociationType associationType, boolean reversed, boolean forDelete, boolean defaultCheckExistence, Collection<Tuple2<?, ?>> idTuples) {
        this(sqlClient, con, associationType, reversed, forDelete, defaultCheckExistence, null, idTuples);
    }

    private AssociationExecutable(JSqlClientImplementor sqlClient, Connection con, AssociationType associationType, boolean reversed, boolean forDelete, boolean defaultCheckExistence, Boolean nullOrCheckedExistence, Collection<Tuple2<?, ?>> idTuples) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.associationType = associationType;
        this.reversed = reversed;
        this.forDelete = forDelete;
        this.defaultCheckExistence = defaultCheckExistence;
        this.nullOrCheckedExistence = nullOrCheckedExistence;
        this.idTuples = idTuples instanceof Set ? (Set<Object>)idTuples : new LinkedHashSet(idTuples);
    }

    public AssociationExecutable setCheckExistence(@Nullable Boolean checkExistence) {
        if (this.nullOrCheckedExistence == checkExistence) {
            return this;
        }
        return new AssociationExecutable(this.sqlClient, this.con, this.associationType, this.reversed, this.forDelete, this.defaultCheckExistence, checkExistence, this.idTuples);
    }

    @Override
    public Integer execute(Connection con) {
        return this.sqlClient.getConnectionManager().execute(con == null ? this.con : con, this::executeImpl);
    }

    private Integer executeImpl(Connection con) {
        if (this.idTuples.isEmpty()) {
            return 0;
        }
        MutationPath path = this.reversed ? MutationPath.root(this.associationType.getBaseProp().getTargetType()).backFrom(this.associationType.getBaseProp()) : MutationPath.root(this.associationType.getBaseProp().getDeclaringType()).to(this.associationType.getBaseProp());
        MutationTrigger trigger = null;
        if (this.sqlClient.getTriggerType() != TriggerType.BINLOG_ONLY) {
            trigger = new MutationTrigger();
        }
        HashMap<AffectedTable, Integer> affectedRowCountMap = new HashMap<AffectedTable, Integer>();
        MiddleTableOperator operator = new MiddleTableOperator(this.sqlClient, con, path, trigger, affectedRowCountMap, null, false);
        boolean checkExistence = this.nullOrCheckedExistence != null ? this.nullOrCheckedExistence : this.defaultCheckExistence;
        IdPairs idPairs = IdPairs.of(this.idTuples);
        if (this.forDelete) {
            operator.delete(idPairs);
        } else if (checkExistence) {
            operator.merge(idPairs);
        } else {
            operator.append(idPairs);
        }
        if (trigger != null) {
            trigger.submit(this.sqlClient, con);
        }
        int affectedRowCount = 0;
        for (Integer rowCount : affectedRowCountMap.values()) {
            affectedRowCount += rowCount.intValue();
        }
        return affectedRowCount;
    }
}

