/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.lang.Lazy;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.KeyUniqueConstraint;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.Batch;
import org.babyfish.jimmer.sql.ast.impl.mutation.PreHandler;
import org.babyfish.jimmer.sql.ast.impl.mutation.QueryReason;
import org.babyfish.jimmer.sql.ast.impl.mutation.Rows;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaveContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.Shape;
import org.babyfish.jimmer.sql.ast.impl.mutation.ShapedEntityMap;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.IdOnlyFetchType;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.impl.IdentityIdGenerator;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SaveException;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPreHandler
implements PreHandler {
    final SaveContext ctx;
    private final DraftPreProcessor<DraftSpi> processor;
    private final DraftInterceptor<Object, DraftSpi> interceptor;
    private final ImmutableProp idProp;
    final Set<ImmutableProp> keyProps;
    private final ImmutableProp versionProp;
    final Set<Object> validatedIds;
    final List<DraftSpi> draftsWithNothing;
    final List<DraftSpi> draftsWithId = new ArrayList<DraftSpi>();
    final List<DraftSpi> draftsWithKey = new ArrayList<DraftSpi>();
    private Map<Object, ImmutableSpi> idObjMap;
    private Map<Object, ImmutableSpi> keyObjMap;
    private Fetcher<ImmutableSpi> originalFetcher;
    private ShapedEntityMap<DraftSpi> associationMap;
    private boolean resolved;

    AbstractPreHandler(SaveContext ctx) {
        this.ctx = ctx;
        this.processor = ctx.options.getSqlClient().getDraftPreProcessor(ctx.path.getType());
        this.interceptor = ctx.options.getSqlClient().getDraftInterceptor(ctx.path.getType());
        this.idProp = ctx.path.getType().getIdProp();
        this.keyProps = ctx.options.getKeyProps(ctx.path.getType());
        this.versionProp = ctx.path.getType().getVersionProp();
        this.validatedIds = ctx.path.getProp() != null && ctx.options.isAutoCheckingProp(ctx.path.getProp()) ? new HashSet<Object>() : null;
        this.draftsWithNothing = this.isWildObjectAcceptable() ? new ArrayList<DraftSpi>() : null;
    }

    @Override
    public Iterable<Batch<DraftSpi>> associationBatches() {
        ShapedEntityMap<DraftSpi> am = this.associationMap;
        if (am == null) {
            ArrayList<DraftSpi> drafts = new ArrayList<DraftSpi>();
            for (Batch<DraftSpi> batch : this.batches()) {
                drafts.addAll(batch.entities());
            }
            this.associationMap = am = this.createEntityMap(drafts, null, null, prop -> prop.isId() || prop.isAssociation(TargetLevel.ENTITY) && !prop.isColumnDefinition(), SaveMode.UPSERT);
        }
        return am;
    }

    @Override
    public void add(DraftSpi draft) {
        Lazy hasNonIdValues = new Lazy(() -> {
            for (ImmutableProp prop : draft.__type().getProps().values()) {
                if (prop.isId() || !draft.__isLoaded(prop.getId())) continue;
                return true;
            }
            return false;
        });
        if (this.ctx.path.getProp() != null && this.ctx.path.getProp().isRemote() && ((Boolean)hasNonIdValues.get()).booleanValue()) {
            this.ctx.throwLongRemoteAssociation();
        }
        if (draft.__isLoaded(draft.__type().getIdProp().getId()) && !((Boolean)hasNonIdValues.get()).booleanValue()) {
            if (this.validatedIds != null) {
                this.validatedIds.add(draft.__get(draft.__type().getIdProp().getId()));
            }
            return;
        }
        if (this.processor != null) {
            this.processor.beforeSave(draft);
        }
        if (draft.__isLoaded(this.idProp.getId())) {
            this.draftsWithId.add(draft);
        } else if (this.keyProps.isEmpty()) {
            if (this.draftsWithNothing == null) {
                this.ctx.throwNeitherIdNorKey(draft.__type(), this.keyProps);
            }
            this.draftsWithNothing.add(draft);
        } else {
            ImmutableProp[] loadedKeyProps = new ImmutableProp[this.keyProps.size()];
            int loadedCount = 0;
            for (ImmutableProp keyProp : this.keyProps) {
                if (!draft.__isLoaded(keyProp.getId())) continue;
                loadedKeyProps[loadedCount++] = keyProp;
            }
            if (loadedCount == 0) {
                if (this.draftsWithNothing == null) {
                    this.ctx.throwNeitherIdNorKey(draft.__type(), this.keyProps);
                }
                this.draftsWithNothing.add(draft);
            } else if (loadedCount < this.keyProps.size()) {
                ArrayList<ImmutableProp> unloadedKeyProps = new ArrayList<ImmutableProp>(this.keyProps);
                for (int i = loadedCount - 1; i >= 0; --i) {
                    unloadedKeyProps.remove(loadedKeyProps[i]);
                }
                this.ctx.throwNoKey((ImmutableSpi)draft, (ImmutableProp)unloadedKeyProps.get(0));
            }
            for (ImmutableProp keyProp : this.keyProps) {
                if (draft.__isLoaded(keyProp.getId())) continue;
                throw new SaveException.NoKeyProp(this.ctx.path, "Cannot save \"" + this.ctx.path.getType() + "\" with the unloaded key property \"" + keyProp + "\"");
            }
            this.draftsWithKey.add(draft);
        }
    }

    @Override
    @Nullable
    public Map<Object, ImmutableSpi> originalIdObjMap() {
        return this.idObjMap;
    }

    @Override
    @Nullable
    public Map<Object, ImmutableSpi> originalkeyObjMap() {
        return this.keyObjMap;
    }

    final Map<Object, ImmutableSpi> findOldMapByIds(QueryReason queryReason) {
        Map<Object, ImmutableSpi> idObjMap = this.idObjMap;
        if (idObjMap == null) {
            this.idObjMap = idObjMap = Rows.findMapByIds(this.ctx, queryReason, this.originalFetcher(), this.draftsWithId);
        }
        return idObjMap;
    }

    final Map<Object, ImmutableSpi> findOldMapByKeys(QueryReason queryReason) {
        Map<Object, ImmutableSpi> keyObjMap = this.keyObjMap;
        if (keyObjMap == null) {
            this.keyObjMap = keyObjMap = Rows.findMapByKeys(this.ctx, queryReason, this.originalFetcher(), this.draftsWithKey);
            if (!keyObjMap.isEmpty()) {
                Map<Object, ImmutableSpi> idObjMap = this.idObjMap;
                if (idObjMap == null) {
                    this.idObjMap = idObjMap = new HashMap<Object, ImmutableSpi>();
                }
                PropId idPropId = this.ctx.path.getType().getIdProp().getId();
                for (ImmutableSpi row : keyObjMap.values()) {
                    if (!row.__isLoaded(idPropId)) continue;
                    idObjMap.put(row.__get(idPropId), row);
                }
            }
        }
        return keyObjMap;
    }

    boolean isWildObjectAcceptable() {
        return false;
    }

    private Fetcher<ImmutableSpi> originalFetcher() {
        Fetcher<ImmutableSpi> oldFetcher = this.originalFetcher;
        if (oldFetcher == null) {
            Collection<TypedProp<?, ?>> typedProps;
            ImmutableType type = this.ctx.path.getType();
            Fetcher fetcherImplementor = new FetcherImpl(this.ctx.path.getType().getJavaClass());
            for (ImmutableProp keyProp : this.keyProps) {
                fetcherImplementor = fetcherImplementor.add(keyProp.getName(), IdOnlyFetchType.RAW);
            }
            DraftInterceptor<?, ?> interceptor = this.ctx.options.getSqlClient().getDraftInterceptor(type);
            if (interceptor != null && (typedProps = interceptor.dependencies()) != null) {
                for (TypedProp<?, ?> typedProp : typedProps) {
                    fetcherImplementor = fetcherImplementor.add(typedProp.unwrap().getName(), IdOnlyFetchType.RAW);
                }
            }
            if (this.ctx.backReferenceFrozen) {
                fetcherImplementor = fetcherImplementor.add(this.ctx.backReferenceProp.getName(), IdOnlyFetchType.RAW);
            }
            this.originalFetcher = oldFetcher = fetcherImplementor;
        }
        return oldFetcher;
    }

    final QueryReason queryReason(boolean hasId, Collection<DraftSpi> drafts) {
        if (this.ctx.trigger != null) {
            return QueryReason.TRIGGER;
        }
        if (this.ctx.backReferenceFrozen) {
            return QueryReason.TARGET_NOT_TRANSFERABLE;
        }
        if (this.interceptor != null) {
            return QueryReason.INTERCEPTOR;
        }
        JSqlClientImplementor sqlClient = this.ctx.options.getSqlClient();
        if (!hasId) {
            IdGenerator idGenerator = this.ctx.options.getSqlClient().getIdGenerator(this.ctx.path.getType().getJavaClass());
            if (idGenerator == null) {
                this.ctx.throwNoIdGenerator();
            }
            if (!(idGenerator instanceof IdentityIdGenerator) && this.ctx.options.getMode() != SaveMode.UPDATE_ONLY) {
                return QueryReason.IDENTITY_GENERATOR_REQUIRED;
            }
        }
        if (this.ctx.options.getMode() == SaveMode.UPSERT) {
            if (!sqlClient.getDialect().isUpsertSupported()) {
                return QueryReason.UPSERT_NOT_SUPPORTED;
            }
            if (!sqlClient.getDialect().isUpsertWithOptimisticLockSupported()) {
                boolean useOptimisticLock;
                boolean bl = useOptimisticLock = this.ctx.options.getUserOptimisticLock(this.ctx.path.getType()) != null || this.ctx.path.getType().getVersionProp() != null;
                if (useOptimisticLock) {
                    return QueryReason.OPTIMISTIC_LOCK;
                }
            }
            if (!hasId) {
                KeyUniqueConstraint constraint = this.ctx.path.getType().getJavaClass().getAnnotation(KeyUniqueConstraint.class);
                if (constraint == null) {
                    return QueryReason.KEY_UNIQUE_CONSTRAINT_REQUIRED;
                }
                if (!constraint.noMoreUniqueConstraints() && !sqlClient.getDialect().isUpsertWithMultipleUniqueConstraintSupported()) {
                    return QueryReason.NO_MORE_UNIQUE_CONSTRAINTS_REQUIRED;
                }
                if (!constraint.isNullNotDistinct()) {
                    Set<ImmutableProp> keyProps = this.ctx.options.getKeyProps(this.ctx.path.getType());
                    ArrayList<PropertyGetter> nullableGetters = new ArrayList<PropertyGetter>();
                    for (PropertyGetter getter : Shape.fullOf(sqlClient, this.ctx.path.getType().getJavaClass()).getGetters()) {
                        if (!getter.metadata().isNullable() || !keyProps.contains(getter.prop())) continue;
                        nullableGetters.add(getter);
                    }
                    if (!nullableGetters.isEmpty()) {
                        for (DraftSpi draft : drafts) {
                            for (PropertyGetter nullableGetter : nullableGetters) {
                                if (nullableGetter.get(draft) != null) continue;
                                return QueryReason.NULL_NOT_DISTINCT_REQUIRED;
                            }
                        }
                    }
                }
            }
        }
        return QueryReason.NONE;
    }

    final void callInterceptor(DraftSpi draft, ImmutableSpi original) {
        if (original == null && this.ctx.options.getMode() != SaveMode.UPDATE_ONLY) {
            this.assignId(draft);
            this.assignVersion(draft);
            this.assignLocalDeletedInfo(draft);
            this.assignDefaultValues(draft);
        }
        if (this.interceptor != null) {
            this.interceptor.beforeSave(draft, original);
        }
    }

    private void assignId(DraftSpi draft) {
        PropId idPropId = this.idProp.getId();
        if (draft.__isLoaded(idPropId)) {
            return;
        }
        Object id = this.ctx.allocateId();
        if (id != null) {
            draft.__set(idPropId, id);
        }
    }

    private void assignVersion(DraftSpi draft) {
        ImmutableProp versionProp = this.versionProp;
        if (versionProp == null) {
            return;
        }
        PropId versionPropId = versionProp.getId();
        if (!draft.__isLoaded(versionPropId)) {
            draft.__set(versionPropId, (Object)0);
        }
    }

    private void assignLocalDeletedInfo(DraftSpi draft) {
        LogicalDeletedInfo logicalDeletedInfo = this.ctx.path.getType().getLogicalDeletedInfo();
        if (logicalDeletedInfo == null) {
            return;
        }
        Object value = logicalDeletedInfo.allocateInitializedValue();
        draft.__set(logicalDeletedInfo.getProp().getId(), value);
    }

    void assignDefaultValues(DraftSpi draft) {
    }

    final void resolve() {
        if (!this.resolved) {
            this.validateAloneIds();
            this.onResolve();
            this.resolved = true;
        }
    }

    abstract void onResolve();

    final ShapedEntityMap<DraftSpi> createEntityMap(Iterable<DraftSpi> i1, Iterable<DraftSpi> i2, Iterable<DraftSpi> i3, SaveMode mode) {
        return this.createEntityMap(i1, i2, i3, ImmutableProp::isColumnDefinition, mode);
    }

    final ShapedEntityMap<DraftSpi> createEntityMap(Iterable<DraftSpi> i1, Iterable<DraftSpi> i2, Iterable<DraftSpi> i3, java.util.function.Predicate<ImmutableProp> propFilter, SaveMode mode) {
        ShapedEntityMap<DraftSpi> entityMap = new ShapedEntityMap<DraftSpi>(this.ctx.options.getSqlClient(), this.keyProps, propFilter, mode);
        if (i1 != null) {
            for (DraftSpi draft : i1) {
                entityMap.add(draft);
            }
        }
        if (i2 != null) {
            for (DraftSpi draft : i2) {
                entityMap.add(draft);
            }
        }
        if (i3 != null) {
            for (DraftSpi draft : i3) {
                entityMap.add(draft);
            }
        }
        return entityMap;
    }

    private void validateAloneIds() {
        Set<Object> ids = this.validatedIds;
        if (ids == null || ids.isEmpty()) {
            return;
        }
        ImmutableProp prop = this.ctx.path.getProp();
        if (prop.isRemote()) {
            List<ImmutableSpi> targets;
            PropId targetIdPropId = prop.getTargetType().getIdProp().getId();
            try {
                targets = this.ctx.options.getSqlClient().getMicroServiceExchange().findByIds(prop.getTargetType().getMicroServiceName(), ids, new FetcherImpl(prop.getTargetType().getJavaClass()));
            }
            catch (Exception ex) {
                this.ctx.throwFailedRemoteValidation();
                return;
            }
            if (targets.size() < ids.size()) {
                for (ImmutableSpi target : targets) {
                    ids.remove(target.__get(targetIdPropId));
                }
                this.ctx.throwIllegalTargetIds(ids);
            }
        } else {
            MutableRootQueryImpl q = new MutableRootQueryImpl(this.ctx.options.getSqlClient(), this.ctx.path.getType(), ExecutionPurpose.MUTATE, FilterLevel.IGNORE_ALL);
            TableImplementor<?> table = q.getTableImplementor();
            q.where(new Predicate[]{table.getId().in(ids)});
            List actualTargetIds = (List)q.select(table.getId()).execute(this.ctx.con);
            if (actualTargetIds.size() < ids.size()) {
                actualTargetIds.forEach(ids::remove);
                this.ctx.throwIllegalTargetIds(ids);
            }
        }
    }
}

