/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Objects;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.NumericExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.jetbrains.annotations.NotNull;

public class Constants {
    public static <N extends Number> NumericExpression<N> number(N value) {
        return new Num<N>(value);
    }

    public static StringExpression string(String value) {
        return new Str(value);
    }

    private static class Num<N extends Number>
    extends AbstractExpression<N>
    implements NumericExpressionImplementor<N> {
        private N value;

        public Num(N value) {
            this.value = (Number)Objects.requireNonNull(value, "`value` cannot be null");
        }

        @Override
        public Class<N> getType() {
            return this.value.getClass();
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            builder.sql(this.value.toString());
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return false;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            return this;
        }

        @Override
        public int precedence() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Num num = (Num)o;
            return this.value.equals(num.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class Str
    extends AbstractExpression<String>
    implements StringExpressionImplementor {
        private final String value;

        private Str(String value) {
            this.value = '\'' + value.replace("'", "''") + '\'';
        }

        @Override
        public void accept(@NotNull AstVisitor visitor) {
        }

        @Override
        public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
            builder.sql(this.value);
        }

        @Override
        protected boolean determineHasVirtualPredicate() {
            return false;
        }

        @Override
        protected Ast onResolveVirtualPredicate(AstContext ctx) {
            return this;
        }

        @Override
        public int precedence() {
            return 0;
        }
    }
}

