/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.associated.VirtualPredicateMergedResult;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.FilterLevel;
import org.babyfish.jimmer.sql.ast.impl.query.FilterableImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.MutableStatementImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableUtils;
import org.babyfish.jimmer.sql.ast.impl.util.ConcattedIterator;
import org.babyfish.jimmer.sql.ast.impl.util.FlaternIterator;
import org.babyfish.jimmer.sql.ast.impl.util.IdentityMap;
import org.babyfish.jimmer.sql.ast.impl.util.IdentityPairSet;
import org.babyfish.jimmer.sql.ast.query.Filterable;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.impl.FilterArgsImpl;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMutableStatementImpl
implements FilterableImplementor,
MutableStatementImplementor {
    private static final Predicate[] EMPTY_PREDICATES = new Predicate[0];
    private final JSqlClientImplementor sqlClient;
    private final ImmutableType type;
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private Table<?> table;
    private TableImplementor<?> tableImplementor;
    private boolean frozen;
    private int modCount;
    private final IdentityMap<TableImplementor<?>, List<Predicate>> filterPredicates = new IdentityMap();

    public AbstractMutableStatementImpl(JSqlClientImplementor sqlClient, ImmutableType type) {
        if (!type.isEntity()) {
            throw new IllegalArgumentException("\"" + type + "\" is not entity");
        }
        if (sqlClient != null && !sqlClient.getMicroServiceName().equals(type.getMicroServiceName())) {
            throw new IllegalArgumentException("The sql client and entity type \"" + type + "\" do not belong to the same micro service: {sqlClient: \"" + sqlClient.getMicroServiceName() + "\", entity: \"" + type.getMicroServiceName() + "\"}");
        }
        this.sqlClient = sqlClient;
        this.type = type;
    }

    public AbstractMutableStatementImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        if (table.__unwrap() != null) {
            throw new IllegalArgumentException("table proxy cannot be wrapper");
        }
        if (table.__prop() != null) {
            throw new IllegalArgumentException("table proxy must be root table");
        }
        this.sqlClient = Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
        if (!sqlClient.getMicroServiceName().equals(table.getImmutableType().getMicroServiceName())) {
            throw new IllegalArgumentException("The sql client and entity type \"" + table.getImmutableType() + "\" do not belong to the same micro service: {sqlClient: \"" + sqlClient.getMicroServiceName() + "\", entity: \"" + table.getImmutableType().getMicroServiceName() + "\"}");
        }
        this.table = table;
        this.type = table.getImmutableType();
    }

    public <T extends Table<?>> T getTable() {
        Table<Object> table = this.table;
        if (table == null) {
            this.table = table = TableProxies.wrap(this.getTableImplementor());
        }
        return (T)table;
    }

    public TableImplementor<?> getTableImplementor() {
        TableImplementor<?> tableImplementor = this.tableImplementor;
        if (tableImplementor == null) {
            this.tableImplementor = tableImplementor = TableImplementor.create(this, this.type);
        }
        return tableImplementor;
    }

    public List<Predicate> getPredicates() {
        return Collections.unmodifiableList(this.predicates);
    }

    protected List<Expression<?>> getGroupExpressions() {
        return Collections.emptyList();
    }

    protected List<Predicate> getHavingPredicates() {
        return Collections.emptyList();
    }

    protected void setHavingPredicates(List<Predicate> havingPredicates) {
    }

    protected List<Order> getOrders() {
        return Collections.emptyList();
    }

    public final Iterable<Predicate> unfrozenPredicates() {
        return new Iterable<Predicate>(){

            @Override
            @NotNull
            public Iterator<Predicate> iterator() {
                return ConcattedIterator.of(AbstractMutableStatementImpl.this.predicates.iterator(), new FlaternIterator(AbstractMutableStatementImpl.this.filterPredicates.iterator()));
            }
        };
    }

    public void whereByFilter(TableImplementor<?> tableImplementor, List<Predicate> predicates) {
        this.filterPredicates.put(tableImplementor, predicates);
    }

    public Predicate getPredicate(AstContext astContext) {
        this.freeze(astContext);
        List<Predicate> ps = this.predicates;
        return ps.isEmpty() ? null : ps.get(0);
    }

    public Predicate getFilterPredicate(TableImplementor<?> tableImplementor, AstContext astContext) {
        this.freeze(astContext);
        List<Predicate> ps = this.filterPredicates.get(tableImplementor);
        return ps == null || ps.isEmpty() ? null : ps.get(0);
    }

    public abstract StatementContext getContext();

    public abstract AbstractMutableStatementImpl getParent();

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return this.sqlClient.createSubQuery(table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        return this.sqlClient.createAssociationSubQuery(table);
    }

    @Override
    public boolean hasVirtualPredicate() {
        for (Predicate predicate : this.unfrozenPredicates()) {
            if (!((Ast)((Object)predicate)).hasVirtualPredicate()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resolveVirtualPredicate(AstContext ctx) {
        ctx.pushStatement(this);
        this.getTableImplementor();
        this.predicates = ctx.resolveVirtualPredicates(this.predicates);
        List<Predicate> havingPredicates = this.getHavingPredicates();
        if (!havingPredicates.isEmpty()) {
            this.setHavingPredicates(ctx.resolveVirtualPredicates(havingPredicates));
        }
        this.filterPredicates.replaceAll(ctx::resolveVirtualPredicates);
        ctx.popStatement();
    }

    public final boolean freeze(AstContext ctx) {
        if (this.frozen) {
            return false;
        }
        this.onFrozen(ctx);
        this.frozen = true;
        return true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    protected void onFrozen(AstContext ctx) {
        this.filterPredicates.removeAll((t, ps) -> {
            if (ps.isEmpty()) {
                return true;
            }
            if (t.getParent() == null || t.getJoinType() == JoinType.INNER) {
                this.predicates.addAll((Collection<Predicate>)ps);
                return true;
            }
            return false;
        });
        this.predicates = AbstractMutableStatementImpl.mergePredicates(this.predicates);
        this.filterPredicates.replaceAll(AbstractMutableStatementImpl::mergePredicates);
    }

    public void applyVirtualPredicates(AstContext ctx) {
        int modCount = -1;
        while (modCount != ctx.modCount()) {
            modCount = ctx.modCount();
            this.resolveVirtualPredicate(ctx);
        }
    }

    public final void applyGlobalFilters(AstContext astContext, FilterLevel level, @Nullable List<Selection<?>> selections) {
        if (level != FilterLevel.IGNORE_ALL) {
            this.applyGlobalFiltersImpl(new ApplyFilterVisitor(astContext, level), selections, null);
        }
    }

    public final void applyDataLoaderGlobalFilters(TableImplementor<?> table) {
        AstContext astContext = new AstContext(this.sqlClient);
        ApplyFilterVisitor visitor = new ApplyFilterVisitor(astContext, FilterLevel.DEFAULT);
        for (Predicate predicate : this.unfrozenPredicates()) {
            visitor.apply(this, predicate);
        }
        for (Order order : this.getOrders()) {
            visitor.apply(this, order);
        }
        TableImplementor<?> root = this.getTableImplementor();
        this.applyGlobalFiltersImpl(visitor, null, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyGlobalFiltersImpl(ApplyFilterVisitor visitor, List<Selection<?>> selections, TableImplementor<?> start) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this);
        try {
            this.applyGlobalFilerImpl(visitor, start != null ? start : this.getTableImplementor());
            int modCount = -1;
            block3: while (modCount != this.modCount()) {
                modCount = this.modCount();
                if (selections != null) {
                    for (Selection<?> selection : selections) {
                        if (visitor.isApplied(this, selection)) continue;
                        Ast.from(selection, astContext).accept(visitor);
                        if (modCount != this.modCount()) continue block3;
                        visitor.apply(this, selection);
                    }
                }
                for (Predicate predicate : this.getPredicates()) {
                    if (visitor.isApplied(this, predicate)) continue;
                    ((Ast)((Object)predicate)).accept(visitor);
                    if (modCount != this.modCount()) continue block3;
                    visitor.apply(this, predicate);
                }
                for (Expression expression : this.getGroupExpressions()) {
                    if (visitor.isApplied(this, expression)) continue;
                    ((Ast)((Object)expression)).accept(visitor);
                    if (modCount != this.modCount()) continue block3;
                    visitor.apply(this, expression);
                }
                for (Predicate predicate : this.getHavingPredicates()) {
                    if (visitor.isApplied(this, predicate)) continue;
                    ((Ast)((Object)predicate)).accept(visitor);
                    if (modCount != this.modCount()) continue block3;
                    visitor.apply(this, predicate);
                }
                for (Order order : this.getOrders()) {
                    if (visitor.isApplied(this, order)) continue;
                    ((Ast)((Object)order.getExpression())).accept(visitor);
                    if (modCount != this.modCount()) continue block3;
                    visitor.apply(this, order);
                }
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void applyGlobalFilerImpl(ApplyFilterVisitor visitor, TableImplementor<?> table) {
        FilterLevel level = visitor.level;
        if (level == FilterLevel.IGNORE_ALL || this.filterPredicates.get(table) != null) {
            return;
        }
        Filter<Props> globalFilter = level == FilterLevel.IGNORE_USER_FILTERS ? this.getSqlClient().getFilters().getLogicalDeletedFilter(table.getImmutableType()) : this.getSqlClient().getFilters().getFilter(table.getImmutableType());
        if (globalFilter != null) {
            FilterArgsImpl args = new FilterArgsImpl(table, (Props)TableProxies.wrap(table), false);
            globalFilter.filter(args);
            this.whereByFilter(table, args.toPredicates());
            this.modify();
        }
    }

    public void validateMutable() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot mutate the statement because it has been frozen");
        }
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    @Override
    public Filterable where(Predicate ... predicates) {
        this.validateMutable();
        for (Predicate predicate : predicates) {
            if (predicate == null) continue;
            this.predicates.add(predicate);
            this.modify();
        }
        return this;
    }

    public ExecutionPurpose getPurpose() {
        return this.getContext().getPurpose();
    }

    protected static List<Predicate> mergePredicates(List<Predicate> predicates) {
        if (predicates.size() < 2) {
            return predicates;
        }
        VirtualPredicateMergedResult.removeEmptyResult(predicates);
        return Collections.singletonList(Predicate.and(predicates.toArray(EMPTY_PREDICATES)));
    }

    public final int modCount() {
        return this.modCount;
    }

    protected final void modify() {
        ++this.modCount;
        AbstractMutableStatementImpl parent = this.getParent();
        if (parent != null) {
            parent.modify();
        }
    }

    private static class ApplyFilterVisitor
    extends AstVisitor {
        final FilterLevel level;
        private final IdentityPairSet<AbstractMutableStatementImpl, Object> appliedSet = new IdentityPairSet();

        public ApplyFilterVisitor(AstContext ctx, FilterLevel level) {
            super(ctx);
            this.level = level;
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            if (subQuery instanceof ConfigurableSubQueryImpl) {
                MutableSubQueryImpl statement = ((ConfigurableSubQueryImpl)subQuery).getBaseQuery();
                FilterManager.executing(statement.filterOwner(), () -> ((AbstractMutableStatementImpl)statement).applyGlobalFiltersImpl(this, null, null));
                return false;
            }
            return true;
        }

        @Override
        public void visitTableReference(TableImplementor<?> table, ImmutableProp prop, boolean rawId) {
            AstContext ctx = this.getAstContext();
            if (prop != null && prop.isId() && (rawId || TableUtils.isRawIdAllowed(table, ctx.getSqlClient()))) {
                table = table.getParent();
            }
            while (table != null) {
                table.getStatement().applyGlobalFilerImpl(this, table);
                table = table.getParent();
            }
        }

        public boolean isApplied(AbstractMutableStatementImpl statement, Selection<?> selection) {
            return this.appliedSet.has(statement, selection);
        }

        public boolean isApplied(AbstractMutableStatementImpl statement, Expression<?> expression) {
            return this.appliedSet.has(statement, expression);
        }

        public boolean isApplied(AbstractMutableStatementImpl statement, Order order) {
            return this.appliedSet.has(statement, order);
        }

        public boolean apply(AbstractMutableStatementImpl statement, Selection<?> selection) {
            return this.appliedSet.add(statement, selection);
        }

        public void apply(AbstractMutableStatementImpl statement, Expression<?> expression) {
            this.appliedSet.add(statement, expression);
        }

        public void apply(AbstractMutableStatementImpl statement, Order order) {
            this.appliedSet.add(statement, order);
        }
    }
}

