/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftPreProcessor;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClientImpl;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.mutation.AssociatedSaveMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.LockMode;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.SubQueryProvider;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.di.AopProxyProvider;
import org.babyfish.jimmer.sql.di.InitializationType;
import org.babyfish.jimmer.sql.di.LogicalDeletedValueGeneratorProvider;
import org.babyfish.jimmer.sql.di.TransientResolverProvider;
import org.babyfish.jimmer.sql.di.UserIdGeneratorProvider;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.BinLogPropReader;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.IdOnlyTargetCheckingLevel;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.LogicalDeletedBehavior;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSqlClient
extends SubQueryProvider {
    public static Builder newBuilder() {
        return new JSqlClientImpl.BuilderImpl();
    }

    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T var1);

    public MutableUpdate createUpdate(TableProxy<?> var1);

    public MutableDelete createDelete(TableProxy<?> var1);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> var1);

    public Entities getEntities();

    public Triggers getTriggers();

    public Triggers getTriggers(boolean var1);

    public Associations getAssociations(TypedProp.Association<?, ?> var1);

    public Associations getAssociations(ImmutableProp var1);

    public Associations getAssociations(AssociationType var1);

    public Caches getCaches();

    public Filters getFilters();

    public BinLog getBinLog();

    public JSqlClient caches(Consumer<CacheDisableConfig> var1);

    public JSqlClient filters(Consumer<FilterConfig> var1);

    public JSqlClient disableSlaveConnectionManager();

    public JSqlClient executor(Executor var1);

    @Nullable
    default public <E> E findById(Class<E> type, Object id) {
        return this.getEntities().findById(type, id);
    }

    @Nullable
    default public <E> E findById(Fetcher<E> fetcher, Object id) {
        return this.getEntities().findById(fetcher, id);
    }

    @NotNull
    default public <E> List<E> findByIds(Class<E> type, Collection<?> ids) {
        return this.getEntities().findByIds(type, ids);
    }

    @NotNull
    default public <E> List<E> findByIds(Fetcher<E> fetcher, Collection<?> ids) {
        return this.getEntities().findByIds(fetcher, ids);
    }

    @NotNull
    default public <K, V> Map<K, V> findMapByIds(Class<V> type, Collection<K> ids) {
        return this.getEntities().findMapByIds(type, ids);
    }

    @NotNull
    default public <K, V> Map<K, V> findMapByIds(Fetcher<V> fetcher, Collection<K> ids) {
        return this.getEntities().findMapByIds(fetcher, ids);
    }

    default public <E> SimpleSaveResult<E> save(E entity, SaveMode mode) {
        return (SimpleSaveResult)this.getEntities().saveCommand(entity).setMode(mode).execute();
    }

    default public <E> SimpleSaveResult<E> save(E entity) {
        return this.save(entity, SaveMode.UPSERT);
    }

    default public <E> SimpleSaveResult<E> insert(E entity) {
        return this.save(entity, SaveMode.INSERT_ONLY);
    }

    default public <E> SimpleSaveResult<E> update(E entity) {
        return this.save(entity, SaveMode.UPDATE_ONLY);
    }

    default public <E> SimpleSaveResult<E> save(Input<E> input, SaveMode mode) {
        return this.save(input.toEntity(), mode);
    }

    default public <E> SimpleSaveResult<E> save(Input<E> input) {
        return this.save(input.toEntity(), SaveMode.UPSERT);
    }

    default public <E> SimpleSaveResult<E> insert(Input<E> input) {
        return this.save(input.toEntity(), SaveMode.INSERT_ONLY);
    }

    default public <E> SimpleSaveResult<E> update(Input<E> input) {
        return this.save(input.toEntity(), SaveMode.UPDATE_ONLY);
    }

    default public <E> SimpleSaveResult<E> merge(E entity) {
        return this.merge(entity, SaveMode.UPSERT);
    }

    default public <E> SimpleSaveResult<E> merge(Input<E> input) {
        return this.merge(input.toEntity(), SaveMode.UPSERT);
    }

    default public <E> SimpleSaveResult<E> merge(E entity, SaveMode mode) {
        return (SimpleSaveResult)this.getEntities().saveCommand(entity).setMode(mode).setAssociatedModeAll(AssociatedSaveMode.MERGE).execute();
    }

    default public <E> SimpleSaveResult<E> merge(Input<E> input, SaveMode mode) {
        return this.merge(input.toEntity(), mode);
    }

    default public <E> SimpleSaveResult<E> append(E entity) {
        return this.append(entity, SaveMode.INSERT_ONLY);
    }

    default public <E> SimpleSaveResult<E> append(Input<E> input) {
        return this.append(input.toEntity(), SaveMode.INSERT_ONLY);
    }

    default public <E> SimpleSaveResult<E> append(E entity, SaveMode mode) {
        return (SimpleSaveResult)this.getEntities().saveCommand(entity).setMode(mode).setAssociatedModeAll(AssociatedSaveMode.APPEND).execute();
    }

    default public <E> SimpleSaveResult<E> append(Input<E> input, SaveMode mode) {
        return this.append(input.toEntity(), mode);
    }

    default public DeleteResult deleteById(Class<?> type, Object id, DeleteMode mode) {
        return this.getEntities().delete(type, id, mode);
    }

    default public DeleteResult deleteById(Class<?> type, Object id) {
        return this.getEntities().delete(type, id, DeleteMode.AUTO);
    }

    default public DeleteResult deleteByIds(Class<?> type, Collection<?> ids, DeleteMode mode) {
        return this.getEntities().deleteAll(type, ids, mode);
    }

    default public DeleteResult deleteByIds(Class<?> type, Collection<?> ids) {
        return this.getEntities().deleteAll(type, ids, DeleteMode.AUTO);
    }

    public static interface Builder {
        public static final int DEFAULT_BATCH_SIZE = 128;
        public static final int DEFAULT_LIST_BATCH_SIZE = 16;

        public Builder setConnectionManager(ConnectionManager var1);

        public Builder setSlaveConnectionManager(ConnectionManager var1);

        public Builder setDialect(Dialect var1);

        public Builder setExecutor(Executor var1);

        public Builder setExecutorContextPrefixes(Collection<String> var1);

        public Builder setSqlFormatter(SqlFormatter var1);

        public Builder setZoneId(@Nullable ZoneId var1);

        public Builder setUserIdGeneratorProvider(UserIdGeneratorProvider var1);

        public Builder setLogicalDeletedValueGeneratorProvider(LogicalDeletedValueGeneratorProvider var1);

        public Builder setTransientResolverProvider(TransientResolverProvider var1);

        public Builder setIdGenerator(IdGenerator var1);

        public Builder setIdGenerator(Class<?> var1, IdGenerator var2);

        public Builder addScalarProvider(ScalarProvider<?, ?> var1);

        public Builder setScalarProvider(TypedProp<?, ?> var1, ScalarProvider<?, ?> var2);

        public Builder setScalarProvider(ImmutableProp var1, ScalarProvider<?, ?> var2);

        public Builder setDefaultSerializedTypeObjectMapper(ObjectMapper var1);

        public Builder setSerializedTypeObjectMapper(Class<?> var1, ObjectMapper var2);

        public Builder setSerializedPropObjectMapper(TypedProp<?, ?> var1, ObjectMapper var2);

        public Builder setSerializedPropObjectMapper(ImmutableProp var1, ObjectMapper var2);

        public Builder setDefaultJsonProviderCreator(Function<ImmutableProp, ScalarProvider<?, ?>> var1);

        public Builder setDefaultEnumStrategy(EnumType.Strategy var1);

        public Builder setDatabaseNamingStrategy(DatabaseNamingStrategy var1);

        public Builder setDefaultBatchSize(int var1);

        public Builder setDefaultListBatchSize(int var1);

        public Builder setInListPaddingEnabled(boolean var1);

        public Builder setExpandedInListPaddingEnabled(boolean var1);

        public Builder setOffsetOptimizingThreshold(int var1);

        public Builder setDefaultLockMode(LockMode var1);

        public Builder setMaxCommandJoinCount(int var1);

        public Builder setEntityManager(EntityManager var1);

        public Builder setCaches(Consumer<CacheConfig> var1);

        public Builder setCacheFactory(CacheFactory var1);

        public Builder setCacheOperator(CacheOperator var1);

        public Builder addCacheAbandonedCallback(CacheAbandonedCallback var1);

        public Builder addCacheAbandonedCallbacks(Collection<? extends CacheAbandonedCallback> var1);

        public Builder setTriggerType(TriggerType var1);

        public Builder setLogicalDeletedBehavior(LogicalDeletedBehavior var1);

        public Builder addFilters(Filter<?> ... var1);

        public Builder addFilters(Collection<? extends Filter<?>> var1);

        public Builder addDisabledFilters(Filter<?> ... var1);

        public Builder addDisabledFilters(Collection<? extends Filter<?>> var1);

        public Builder setDefaultDissociateActionCheckable(boolean var1);

        public Builder setIdOnlyTargetCheckingLevel(IdOnlyTargetCheckingLevel var1);

        public Builder addDraftPreProcessor(DraftPreProcessor<?> var1);

        public Builder addDraftPreProcessors(DraftPreProcessor<?> ... var1);

        public Builder addDraftPreProcessors(Collection<DraftPreProcessor<?>> var1);

        public Builder addDraftInterceptor(DraftInterceptor<?, ?> var1);

        public Builder addDraftInterceptors(DraftInterceptor<?, ?> ... var1);

        public Builder addDraftInterceptors(Collection<? extends DraftInterceptor<?, ?>> var1);

        public Builder setDefaultBinLogObjectMapper(ObjectMapper var1);

        public Builder setBinLogPropReader(ImmutableProp var1, BinLogPropReader var2);

        public Builder setBinLogPropReader(TypedProp.Scalar<?, ?> var1, BinLogPropReader var2);

        public Builder setBinLogPropReader(Class<?> var1, BinLogPropReader var2);

        public Builder setForeignKeyEnabledByDefault(boolean var1);

        public Builder setTargetTransferable(boolean var1);

        public Builder addCustomizers(Customizer ... var1);

        public Builder addCustomizers(Collection<? extends Customizer> var1);

        public Builder addInitializers(Initializer ... var1);

        public Builder addInitializers(Collection<? extends Initializer> var1);

        public Builder setDatabaseValidationMode(DatabaseValidationMode var1);

        public Builder setDatabaseValidationCatalog(String var1);

        public Builder setDatabaseValidationSchema(String var1);

        public Builder setAopProxyProvider(AopProxyProvider var1);

        public Builder setMicroServiceName(String var1);

        public Builder setMicroServiceExchange(MicroServiceExchange var1);

        public Builder setInitializationType(InitializationType var1);

        public JSqlClient build();
    }
}

