/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.ExecutorForLog;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlFunction;
import org.babyfish.jimmer.sql.runtime.StatementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Executor {
    public <R> R execute(@NotNull Args<R> var1);

    public BatchContext executeBatch(@NotNull JSqlClientImplementor var1, @NotNull Connection var2, @NotNull String var3, @Nullable ImmutableProp var4);

    default public void openCursor(long cursorId, String sql, List<Object> variables, List<Integer> variablePositions, ExecutionPurpose purpose, @Nullable ExecutorContext ctx, JSqlClientImplementor sqlClient) {
    }

    public static Executor log() {
        return ExecutorForLog.wrap(DefaultExecutor.INSTANCE);
    }

    public static Executor log(Executor executor) {
        return ExecutorForLog.wrap(executor);
    }

    public static interface BatchContext
    extends AutoCloseable {
        public String sql();

        public void add(List<Object> var1);

        public int[] execute();

        public Object[] generatedIds();

        @Override
        public void close();
    }

    public static class Args<R> {
        public final JSqlClientImplementor sqlClient;
        public final Connection con;
        public final String sql;
        public final List<Object> variables;
        @Nullable
        public final List<Integer> variablePositions;
        public final ExecutionPurpose purpose;
        @Nullable
        public final ExecutorContext ctx;
        public final StatementFactory statementFactory;
        public final SqlFunction<PreparedStatement, R> block;
        @Nullable
        public final Long closingCursorId;

        public Args(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, ExecutionPurpose purpose, StatementFactory statementFactory, SqlFunction<PreparedStatement, R> block) {
            this.sqlClient = sqlClient;
            this.con = con;
            this.sql = sql;
            this.variables = variables;
            this.variablePositions = variablePositions;
            this.purpose = purpose;
            this.ctx = ExecutorContext.create(sqlClient);
            this.statementFactory = statementFactory;
            this.block = block;
            this.closingCursorId = null;
        }

        public Args(JSqlClientImplementor sqlClient, Connection con, String sql, List<Object> variables, @Nullable List<Integer> variablePositions, ExecutionPurpose purpose, StatementFactory statementFactory, SqlFunction<PreparedStatement, R> block, long closingCursorId) {
            this.sqlClient = sqlClient;
            this.con = con;
            this.sql = sql;
            this.variables = variables;
            this.variablePositions = variablePositions;
            this.purpose = purpose;
            this.ctx = ExecutorContext.create(sqlClient);
            this.statementFactory = statementFactory;
            this.block = block;
            this.closingCursorId = closingCursorId;
        }
    }
}

