/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.babyfish.jimmer.sql.cache.CacheTracker;

public abstract class AbstractCacheTracker
implements CacheTracker {
    protected final List<CacheTracker.InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<CacheTracker.InvalidationListener>();
    protected final List<CacheTracker.ReconnectListener> reconnectListeners = new CopyOnWriteArrayList<CacheTracker.ReconnectListener>();
    private final CacheTracker.Firer firer = new FirerImpl();

    @Override
    public void addInvalidateListener(CacheTracker.InvalidationListener listener) {
        if (listener != null) {
            this.invalidationListeners.add(listener);
        }
    }

    @Override
    public void removeInvalidateListener(CacheTracker.InvalidationListener listener) {
        if (listener != null) {
            this.invalidationListeners.remove(listener);
        }
    }

    @Override
    public void addReconnectListener(CacheTracker.ReconnectListener listener) {
        if (listener != null) {
            this.reconnectListeners.add(listener);
        }
    }

    @Override
    public void removeReconnectListener(CacheTracker.ReconnectListener listener) {
        if (listener != null) {
            this.reconnectListeners.remove(listener);
        }
    }

    @Override
    public CacheTracker.Firer firer() {
        return this.firer;
    }

    @Override
    public CacheTracker.Publisher publisher() {
        return new PublisherImpl();
    }

    protected abstract void publishInvalidationEvent(CacheTracker.InvalidateEvent var1);

    private class FirerImpl
    implements CacheTracker.Firer {
        private FirerImpl() {
        }

        @Override
        public void invalidate(CacheTracker.InvalidateEvent message) {
            for (CacheTracker.InvalidationListener listener : AbstractCacheTracker.this.invalidationListeners) {
                listener.onInvalidate(message);
            }
        }

        @Override
        public void reconnect() {
            for (CacheTracker.ReconnectListener listener : AbstractCacheTracker.this.reconnectListeners) {
                listener.onReconnect();
            }
        }
    }

    private class PublisherImpl
    implements CacheTracker.Publisher {
        private PublisherImpl() {
        }

        @Override
        public void invalidate(CacheTracker.InvalidateEvent event) {
            AbstractCacheTracker.this.publishInvalidationEvent(event);
        }
    }
}

