/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.redisson;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InvalidateMessage
implements Serializable {
    @NotNull
    UUID trackerId;
    @NotNull
    String typeName;
    @Nullable
    String propName;
    @NotNull
    Collection<?> ids;

    InvalidateMessage(@NotNull UUID trackerId, @NotNull CacheTracker.InvalidateEvent event) {
        this.trackerId = trackerId;
        this.typeName = event.getType().toString();
        this.propName = event.getProp() != null ? event.getProp().getName() : null;
        this.ids = event.getIds();
    }

    CacheTracker.InvalidateEvent toEvent() {
        Class<?> javaType;
        try {
            javaType = Class.forName(this.typeName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot resolve the type name \"" + this.typeName + "\"");
        }
        ImmutableType type = ImmutableType.get(javaType);
        if (this.propName != null) {
            ImmutableProp prop = type.getProp(this.propName);
            return new CacheTracker.InvalidateEvent(prop, this.ids);
        }
        return new CacheTracker.InvalidateEvent(type, this.ids);
    }
}

