/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.time.Duration;
import org.babyfish.jimmer.sql.cache.CacheLocker;
import org.babyfish.jimmer.sql.cache.chain.LockedSimpleBinder;
import org.babyfish.jimmer.sql.cache.chain.ParameterizedLockedSimpleBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LockableBinder<K, V>
extends SimpleBinder<K, V> {
    @NotNull
    public String keyPrefix();

    @NotNull
    default public SimpleBinder<K, V> hardLock(@Nullable CacheLocker cacheLocker, @Nullable Duration leaseDuration) {
        return this.lock(cacheLocker, null, leaseDuration);
    }

    @NotNull
    default public SimpleBinder<K, V> softLock(@Nullable CacheLocker cacheLocker, @Nullable Duration leaseDuration) {
        return this.lock(cacheLocker, Duration.ZERO, leaseDuration);
    }

    @NotNull
    default public SimpleBinder<K, V> lock(@Nullable CacheLocker cacheLocker, @Nullable Duration waitDuration, @Nullable Duration leaseDuration) {
        if (cacheLocker == null) {
            return this;
        }
        if (this instanceof Parameterized) {
            return new ParameterizedLockedSimpleBinder((Parameterized)this, cacheLocker, waitDuration, leaseDuration);
        }
        return new LockedSimpleBinder(this, cacheLocker, waitDuration, leaseDuration);
    }

    public static interface Parameterized<K, V>
    extends LockableBinder<K, V>,
    SimpleBinder.Parameterized<K, V> {
        @Override
        @NotNull
        default public SimpleBinder.Parameterized<K, V> hardLock(@Nullable CacheLocker cacheLocker, @Nullable Duration leaseDuration) {
            return this.lock(cacheLocker, Duration.ZERO, leaseDuration);
        }

        @Override
        @NotNull
        default public SimpleBinder<K, V> softLock(@Nullable CacheLocker cacheLocker, @Nullable Duration leaseDuration) {
            return this.lock(cacheLocker, Duration.ZERO, leaseDuration);
        }

        @Override
        @NotNull
        default public SimpleBinder.Parameterized<K, V> lock(@Nullable CacheLocker cacheLocker, @Nullable Duration waitDuration, @Nullable Duration leaseDuration) {
            if (cacheLocker == null) {
                return this;
            }
            return new ParameterizedLockedSimpleBinder(this, cacheLocker, waitDuration, leaseDuration);
        }
    }
}

