/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.render;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.value.PropertyGetter;
import org.babyfish.jimmer.sql.ast.impl.value.ValueGetter;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.DbLiteral;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;

public class BatchSqlBuilder
extends AbstractSqlBuilder<BatchSqlBuilder> {
    private final AbstractSqlBuilder.ScopeManager scopeManager = new AbstractSqlBuilder.ScopeManager();
    private final List<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>();
    final JSqlClientImplementor sqlClient;
    private final String jsonSuffix;

    public BatchSqlBuilder(JSqlClientImplementor sqlClient) {
        String jsonSuffix = sqlClient.getDialect().getJsonLiteralSuffix();
        if (jsonSuffix != null) {
            jsonSuffix = jsonSuffix.isEmpty() ? null : ' ' + jsonSuffix;
        }
        this.sqlClient = sqlClient;
        this.jsonSuffix = jsonSuffix;
    }

    @Override
    public JSqlClientImplementor sqlClient() {
        return this.sqlClient;
    }

    public BatchSqlBuilder variable(ValueGetter getter) {
        this.sql("?");
        this.appendJsonSuffix(getter.metadata().isJson());
        this.templateVariables.add(new GetterVariable(getter));
        return this;
    }

    public BatchSqlBuilder defaultVariable(ValueGetter getter) {
        this.sql("?");
        this.appendJsonSuffix(getter.metadata().isJson());
        this.templateVariables.add(new DefaultVariable(getter));
        return this;
    }

    public BatchSqlBuilder variable(Function<Object, Object> getter) {
        this.sql("?");
        this.templateVariables.add(new LambdaVariable(getter));
        return this;
    }

    @Override
    public BatchSqlBuilder rawVariable(Object value) {
        if (value instanceof ImmutableProp) {
            throw new IllegalArgumentException("value cannot property");
        }
        if (value == null) {
            throw new IllegalArgumentException("The \"" + BatchSqlBuilder.class.getName() + "\" does not accept null value");
        }
        if (value instanceof TupleImplementor) {
            throw new IllegalArgumentException("The \"" + BatchSqlBuilder.class.getName() + "\" does not accept tuple value");
        }
        if (value instanceof ImmutableSpi) {
            throw new IllegalArgumentException("The \"" + BatchSqlBuilder.class.getName() + "\" does not accept embeddable value");
        }
        this.sql("?");
        this.templateVariables.add(new LiteralVariable(value));
        return this;
    }

    public BatchSqlBuilder value(ImmutableProp prop) {
        if (prop.isEmbedded(EmbeddedLevel.BOTH)) {
            throw new IllegalArgumentException("The \"" + BatchSqlBuilder.class.getName() + "\" does not accept embeddable property \"" + prop + "\"");
        }
        return this.variable(PropertyGetter.propertyGetters(this.sqlClient, prop).get(0));
    }

    private void appendJsonSuffix(boolean isJson) {
        if (this.jsonSuffix != null && isJson) {
            this.sql(this.jsonSuffix);
        }
    }

    public Tuple2<String, VariableMapper> build() {
        if (this.scopeManager.current != null) {
            throw new IllegalStateException("Internal bug: Did not leave all scopes");
        }
        return new Tuple2<String, VariableMapper>(this.builder.toString(), new VariableMapper(this.templateVariables));
    }

    @Override
    protected AbstractSqlBuilder.ScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    protected SqlFormatter formatter() {
        return this.sqlClient.getSqlFormatter();
    }

    private static class GetterVariable
    extends TemplateVariable {
        private final ValueGetter getter;

        private GetterVariable(ValueGetter getter) {
            this.getter = getter;
        }

        @Override
        Object get(Object row) {
            Object value = this.getter.get(row);
            return value != null ? value : new DbLiteral.DbNull(this.getter.metadata().getSqlType());
        }
    }

    private static class DefaultVariable
    extends TemplateVariable {
        private final Object value;

        DefaultVariable(ValueGetter getter) {
            Object value = getter.metadata().getDefaultValue();
            this.value = value != null ? value : new DbLiteral.DbNull(getter.metadata().getSqlType());
        }

        @Override
        Object get(Object row) {
            return this.value;
        }
    }

    private static class LambdaVariable
    extends TemplateVariable {
        private final Function<Object, Object> getter;

        private LambdaVariable(Function<Object, Object> getter) {
            this.getter = getter;
        }

        @Override
        Object get(Object row) {
            return this.getter.apply(row);
        }
    }

    private static class LiteralVariable
    extends TemplateVariable {
        private final Object value;

        private LiteralVariable(Object value) {
            this.value = value;
        }

        @Override
        Object get(Object row) {
            return this.value;
        }
    }

    public static class VariableMapper {
        private final List<TemplateVariable> templateVariables;

        VariableMapper(List<TemplateVariable> templateVariables) {
            this.templateVariables = templateVariables;
        }

        public List<Object> variables(Object row) {
            ArrayList<Object> variables = new ArrayList<Object>(this.templateVariables.size());
            for (TemplateVariable templateVariable : this.templateVariables) {
                variables.add(templateVariable.get(row));
            }
            return variables;
        }
    }

    private static abstract class TemplateVariable {
        private TemplateVariable() {
        }

        abstract Object get(Object var1);
    }
}

