/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.PropId;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.runtime.DissociationInfo;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;

public class MutableDeleteImpl
extends AbstractMutableStatementImpl
implements MutableDelete {
    private final MutableRootQueryImpl<TableEx<?>> deleteQuery;
    private boolean isDissociationDisabled;

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.DELETE), sqlClient, immutableType);
    }

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.DELETE), sqlClient, table);
    }

    @Override
    public <T extends Table<?>> T getTable() {
        return this.deleteQuery.getTable();
    }

    @Override
    public TableImplementor<?> getTableImplementor() {
        return this.deleteQuery.getTableImplementor();
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public StatementContext getContext() {
        return this.deleteQuery.getContext();
    }

    @Override
    public MutableDelete where(Predicate ... predicates) {
        this.deleteQuery.where(predicates);
        return this;
    }

    @Override
    public void whereByFilter(TableImplementor<?> tableImplementor, List<Predicate> predicates) {
        this.deleteQuery.whereByFilter(tableImplementor, predicates);
    }

    @Override
    public MutableDelete disableDissociation() {
        this.isDissociationDisabled = true;
        return this;
    }

    @Override
    public Integer execute() {
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    @Override
    protected void onFrozen(AstContext astContext) {
        this.deleteQuery.freeze(astContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeImpl(Connection con) {
        MutationCache cache;
        ArrayList<Object> ids;
        boolean directly;
        JSqlClientImplementor sqlClient = this.getSqlClient();
        TableImplementor<?> table = this.getTableImplementor();
        AstContext astContext = new AstContext(sqlClient);
        this.applyVirtualPredicates(astContext);
        this.applyGlobalFilters(astContext, this.getContext().getFilterLevel(), null);
        this.deleteQuery.freeze(astContext);
        astContext.pushStatement(this.deleteQuery);
        try {
            UseTableVisitor visitor = new UseTableVisitor(astContext);
            for (Predicate predicate : this.deleteQuery.unfrozenPredicates()) {
                ((Ast)((Object)predicate)).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
        boolean binLogOnly = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY;
        DissociationInfo info = sqlClient.getEntityManager().getDissociationInfo(table.getImmutableType());
        boolean bl = directly = table.isEmpty(it -> astContext.getTableUsedState((TableImplementor<?>)it) == TableUsedState.USED) && binLogOnly && (this.isDissociationDisabled || info == null || info.isDirectlyDeletable(sqlClient.getMetadataStrategy()));
        if (directly) {
            SqlBuilder builder = new SqlBuilder(astContext);
            astContext.pushStatement(this);
            try {
                this.renderDirectly(builder);
                Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
                Integer n = sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), this.getPurpose(), null, PreparedStatement::executeUpdate));
                return n;
            }
            finally {
                astContext.popStatement();
            }
        }
        if (binLogOnly) {
            ids = (ArrayList<Object>)this.deleteQuery.select(table.get(table.getImmutableType().getIdProp())).distinct().execute(con);
            cache = null;
        } else {
            List rows = (List)this.deleteQuery.select(table).execute(con);
            PropId idPropId = table.getImmutableType().getIdProp().getId();
            ids = new ArrayList<Object>(rows.size());
            cache = new MutationCache(sqlClient, false);
            for (ImmutableSpi row : rows) {
                cache.save(row, false);
                ids.add(row.__get(idPropId));
            }
        }
        if (ids.isEmpty()) {
            return 0;
        }
        Deleter deleter = new Deleter(new DeleteCommandImpl.Data(sqlClient, DeleteMode.PHYSICAL), con, cache, binLogOnly ? null : new MutationTrigger(), new HashMap<AffectedTable, Integer>());
        deleter.addPreHandleInput(table.getImmutableType(), ids);
        return deleter.execute(true).getTotalAffectedRowCount();
    }

    private void renderDirectly(SqlBuilder builder) {
        Predicate predicate = this.deleteQuery.getPredicate(builder.getAstContext());
        TableImplementor<?> table = this.getTableImplementor();
        builder.sql("delete");
        if (this.getSqlClient().getDialect().isDeletedAliasRequired()) {
            ((SqlBuilder)builder.sql(" ")).sql(table.getAlias());
        }
        ((SqlBuilder)((SqlBuilder)builder.from().sql(table.getImmutableType().getTableName(this.getSqlClient().getMetadataStrategy()))).sql(" ")).sql(table.getAlias());
        if (predicate != null) {
            builder.enter(AbstractSqlBuilder.ScopeType.WHERE);
            ((Ast)((Object)predicate)).renderTo(builder);
            builder.leave();
        }
    }
}

